/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.task;

import cn.smarthse.fwgj.dao.thirdGj.ThirdGjOrgCustomerMapper;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgCustomer;
import cn.smarthse.fwgj.provider.supervise.thirdGjCheck.IThirdGjCheckProviderToSupervise;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjCheckInfoService;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"xxljob.switch"}, havingValue="on")
public class GjCheckInfoTask {
    private final IThirdGjCheckInfoService infoService;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @DubboReference
    private IThirdGjCheckProviderToSupervise checkProviderToSupervise;
    private final ThirdGjOrgCustomerMapper customerMapper;

    @XxlJob(value="GjCheckInfoTask-checkInfoAboutStateTasks")
    public void checkInfoAboutStateTasks() {
        this.logger.debug("\u5b9a\u65f6\u4efb\u52a1-\u4fee\u6539\u670d\u52a1\u68c0\u67e5\u7684\u72b6\u6001-\u5f00\u59cb");
        this.infoService.searchAndUpdateCheckInfoAboutState(null);
        this.logger.debug("\u5b9a\u65f6\u4efb\u52a1-\u4fee\u6539\u670d\u52a1\u68c0\u67e5\u7684\u72b6\u6001-\u7ed3\u675f");
    }

    @XxlJob(value="GjCheckInfoTask-delUnusedCheckTasks")
    public void delUnusedCheckTasks() {
        this.logger.debug("\u5b9a\u65f6\u4efb\u52a1-\u903b\u8f91\u5220\u9664[\u5df2\u89e3\u7ea6]\u7b7e\u7ea6\u4f01\u4e1a\u7684\u68c0\u67e5\u8bb0\u5f55-\u5f00\u59cb");
        List customerIdList = this.customerMapper.searchNeedChangeCustomerState().stream().map(ThirdGjOrgCustomer::getId).collect(Collectors.toList());
        this.checkProviderToSupervise.handleRemainingCheck(customerIdList);
        this.logger.debug("\u5b9a\u65f6\u4efb\u52a1-\u903b\u8f91\u5220\u9664[\u5df2\u89e3\u7ea6]\u7b7e\u7ea6\u4f01\u4e1a\u7684\u68c0\u67e5\u8bb0\u5f55-\u7ed3\u675f");
    }

    @XxlJob(value="GjCustomerTask-genCheckInfoForCustomerTask")
    public void genCheckInfoForCustomerTask() {
        String pattern = XxlJobHelper.getJobParam();
        Long id = null;
        LocalDate localDate = null;
        if (null != pattern && !pattern.equals("")) {
            List<String> list = Arrays.asList(pattern.split(","));
            id = list.get(0).equals("/") ? null : Long.valueOf(list.get(0));
            localDate = list.get(1).equals("/") ? null : LocalDate.parse(list.get(1), DateTimeFormatter.BASIC_ISO_DATE);
        }
        this.logger.debug("\u5b9a\u65f6\u4efb\u52a1-\u7ed9\u8fdb\u5165\u7b7e\u7ea6\u65f6\u95f4\u5185\u7684\u4f01\u4e1a\u4ea7\u751f\u670d\u52a1-\u5f00\u59cb");
        this.infoService.createCheckForTask(id);
        this.logger.debug("\u5b9a\u65f6\u4efb\u52a1-\u7ed9\u8fdb\u5165\u7b7e\u7ea6\u65f6\u95f4\u5185\u7684\u4f01\u4e1a\u4ea7\u751f\u670d\u52a1-\u7ed3\u675f");
    }

    public GjCheckInfoTask(IThirdGjCheckInfoService infoService, ThirdGjOrgCustomerMapper customerMapper) {
        this.infoService = infoService;
        this.customerMapper = customerMapper;
    }
}

