/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.task;

import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration
@ConditionalOnProperty(name={"xxljob.switch"}, havingValue="on")
public class CacheTask {
    private static final Logger log = LoggerFactory.getLogger(CacheTask.class);
    private final RedisTemplate<String, Object> redisTemplate;

    @XxlJob(value="CacheTask-cacheEvict")
    public void cacheEvict() {
        String key = XxlJobHelper.getJobParam();
        log.info("CacheTask-cacheEvict begin key\uff1a{}", (Object)key);
        this.redisTemplate.delete((Object)key);
        log.info("CacheTask-cacheEvict end");
    }

    @XxlJob(value="CacheTask-cacheEvictByPrefix")
    public void cacheEvictByPrefix() {
        String pattern = XxlJobHelper.getJobParam();
        log.info("CacheTask-cacheEvictByPrefix begin key\uff1a{}", (Object)pattern);
        Set keys = this.redisTemplate.keys((Object)(pattern + "*"));
        if (keys != null) {
            this.redisTemplate.delete((Collection)keys);
        }
        log.info("CacheTask-cacheEvictByPrefix end");
    }

    public CacheTask(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

