/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.syn.task;

import cn.smarthse.fwgj.entity.thirdGj.ThirdGjCheckItem;
import cn.smarthse.fwgj.framework.RedisKey;
import cn.smarthse.fwgj.syn.service.ISynGjCheckService;
import cn.smarthse.util.common.StringUtils;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration
@ConditionalOnProperty(name={"xxljob.switch"}, havingValue="on")
public class SynGjTask {
    private static final Logger log = LoggerFactory.getLogger(SynGjTask.class);
    private final RedisTemplate<String, Object> redisTemplate;
    private final ISynGjCheckService synGjCheckService;

    @XxlJob(value="SynTask-initReferenceData")
    public void initReferenceData() {
        String key = XxlJobHelper.getJobParam();
        log.info("SynTask-initReferenceData begin key\uff1a{}", (Object)key);
        Set keys = StringUtils.isBlank((CharSequence)key) ? this.redisTemplate.keys((Object)"syn:referenceData:*") : this.redisTemplate.keys((Object)key);
        if (keys != null) {
            keys.forEach(cid -> {
                Long cidLong = Long.parseLong(cid);
                ThirdGjCheckItem referenceData = this.synGjCheckService.getItemReferenceData(cidLong);
                Long itemId = (Long)this.redisTemplate.opsForValue().get((Object)RedisKey.synReferenceData(cidLong));
                referenceData.setId(itemId);
                this.synGjCheckService.updateReferenceData(referenceData);
                this.redisTemplate.delete((Object)RedisKey.synReferenceData(cidLong));
                log.info("SynTask-initReferenceData cid\uff1a{}, itemId:{}", cid, (Object)itemId);
            });
        }
        log.info("SynTask-initReferenceData end");
    }

    public SynGjTask(RedisTemplate<String, Object> redisTemplate, ISynGjCheckService synGjCheckService) {
        this.redisTemplate = redisTemplate;
        this.synGjCheckService = synGjCheckService;
    }
}

