/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.service.thirdGj.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.util.IdUtil;
import cn.smarthse.fwgj.dao.thirdGj.ThirdGjOrgMessageMapper;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgMessage;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgMessageReceiver;
import cn.smarthse.fwgj.model.param.admin.ThirdGjOrgOneMessageParam;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjOrgMessageReceiverService;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjOrgMessageService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Service
public class ThirdGjOrgMessageServiceImpl
extends ServiceImpl<ThirdGjOrgMessageMapper, ThirdGjOrgMessage>
implements IThirdGjOrgMessageService {
    @Autowired
    private IThirdGjOrgMessageReceiverService thirdGjOrgMessageReceiverService;

    @Override
    @Transactional
    public void sendOneMessageToByUserType(ThirdGjOrgOneMessageParam msg) {
        if (Objects.isNull(msg)) {
            return;
        }
        LocalDateTime now = LocalDateTime.now();
        ThirdGjOrgMessage thirdGjOrgMessage = new ThirdGjOrgMessage().setId(Long.valueOf(IdUtil.getSnowflakeNextId())).setBusinessType(msg.getBusinessType()).setBusinessContent(msg.getBusinessContent()).setCid(msg.getCid()).setSendTime(msg.getSendTime()).setSendUnitId(msg.getSendUnitId()).setCreateDate(now).setUpdateDate(now);
        if (Objects.isNull(thirdGjOrgMessage.getSendTime())) {
            thirdGjOrgMessage.setSendTime(now);
        }
        Long unitId = msg.getUnitId();
        if (this.save(thirdGjOrgMessage) && Objects.nonNull(unitId)) {
            ThirdGjOrgMessageReceiver thirdGjOrgMessageReceiver = new ThirdGjOrgMessageReceiver().setUserType(msg.getUserType()).setUnitId(unitId).setMessageId(thirdGjOrgMessage.getId()).setCreateDate(now).setUpdateDate(now);
            this.thirdGjOrgMessageReceiverService.save(thirdGjOrgMessageReceiver);
        }
    }

    @Override
    @Transactional
    public void sendMoreMessageToByUserType(List<ThirdGjOrgOneMessageParam> msgList) {
        if (CollUtil.isEmpty(msgList)) {
            return;
        }
        ArrayList<ThirdGjOrgMessage> list = new ArrayList<ThirdGjOrgMessage>(msgList.size());
        ArrayList<ThirdGjOrgMessageReceiver> list2 = new ArrayList<ThirdGjOrgMessageReceiver>(msgList.size());
        LocalDateTime now = LocalDateTime.now();
        Snowflake snowflake = IdUtil.getSnowflake();
        for (ThirdGjOrgOneMessageParam msg : msgList) {
            ThirdGjOrgMessage thirdGjOrgMessage = new ThirdGjOrgMessage().setId(Long.valueOf(snowflake.nextId())).setBusinessId(msg.getBusinessId()).setBusinessType(msg.getBusinessType()).setBusinessContent(msg.getBusinessContent()).setCid(msg.getCid()).setSendTime(msg.getSendTime()).setSendUnitId(msg.getSendUnitId()).setSendUnitName(msg.getSendUnitName()).setCreateDate(now).setUpdateDate(now);
            if (Objects.isNull(thirdGjOrgMessage.getSendTime())) {
                thirdGjOrgMessage.setSendTime(now);
            }
            list.add(thirdGjOrgMessage);
            Long unitId = msg.getUnitId();
            if (!Objects.nonNull(unitId)) continue;
            ThirdGjOrgMessageReceiver thirdGjOrgMessageReceiver = new ThirdGjOrgMessageReceiver().setUserType(msg.getUserType()).setUnitId(unitId).setMessageId(thirdGjOrgMessage.getId()).setCreateDate(now).setUpdateDate(now);
            list2.add(thirdGjOrgMessageReceiver);
        }
        this.saveBatch(list);
        this.thirdGjOrgMessageReceiverService.saveBatch(list2);
    }
}

