/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.service.thirdGj.impl;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.fwgj.dao.ReformItemBasicMapper;
import cn.smarthse.fwgj.dao.thirdGj.ThirdGjOrgCustomerMapper;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjCheckInfo;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrg;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgAuditLog;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgCustomer;
import cn.smarthse.fwgj.enums.GjCustomerCheckStatusEnum;
import cn.smarthse.fwgj.enums.GjCustomerCycleEnum;
import cn.smarthse.fwgj.enums.GjCustomerWarningStatusEnum;
import cn.smarthse.fwgj.enums.ThirdGjOrgAuditLogTypeEnum;
import cn.smarthse.fwgj.enums.ThirdGjOrgAuditOptEnum;
import cn.smarthse.fwgj.enums.ThirdGjOrgAuditResultEnum;
import cn.smarthse.fwgj.enums.ThirdGjOrgCustomerStateEnum;
import cn.smarthse.fwgj.enums.ThirdGjOrgCustomerTypeEnum;
import cn.smarthse.fwgj.enums.ThirdGjOrgCustomerUnsignTypeEnum;
import cn.smarthse.fwgj.enums.thirdGj.CheckStatusEnums;
import cn.smarthse.fwgj.framework.Constant;
import cn.smarthse.fwgj.model.param.GjOrgCustomerQueryParam;
import cn.smarthse.fwgj.model.param.admin.GjOrgSignCompAuditParam;
import cn.smarthse.fwgj.model.param.admin.JurisdictionalUnitListParam;
import cn.smarthse.fwgj.model.param.admin.OnUnitServiceStatisticsParam;
import cn.smarthse.fwgj.model.param.admin.UnitServcieAreaStatisticsListParam;
import cn.smarthse.fwgj.model.param.admin.UnitServcieAreaStatisticsTotalParam;
import cn.smarthse.fwgj.model.param.company.CompanyCustomerSearchParam;
import cn.smarthse.fwgj.model.param.third.GjOrgCompanyQueryParam;
import cn.smarthse.fwgj.model.vo.CompanyInfoVo;
import cn.smarthse.fwgj.model.vo.HomeData;
import cn.smarthse.fwgj.model.vo.admin.GjOrgSignCompHistoryVo;
import cn.smarthse.fwgj.model.vo.admin.JurisdictionalUnitListAdminVo;
import cn.smarthse.fwgj.model.vo.admin.JurisdictionalUnitTabStatisticsAdminVo;
import cn.smarthse.fwgj.model.vo.admin.OnUnitServiceStatisticsAdminVo;
import cn.smarthse.fwgj.model.vo.admin.UnitServiceAreaStatisticsAdminVo;
import cn.smarthse.fwgj.model.vo.company.CompanyAreaChangedVo;
import cn.smarthse.fwgj.model.vo.company.CompanyCustomerHistoryListVo;
import cn.smarthse.fwgj.model.vo.company.CompanyCustomerStatisticVo;
import cn.smarthse.fwgj.model.vo.third.GjOrgCheckStatisticVo;
import cn.smarthse.fwgj.model.vo.third.GjOrgCompanyAreaVo;
import cn.smarthse.fwgj.model.vo.third.GjOrgCompanyListVo;
import cn.smarthse.fwgj.model.vo.third.GjOrgCustomerStatisticVo;
import cn.smarthse.fwgj.model.vo.third.ReformStasticsVo;
import cn.smarthse.fwgj.provider.supervise.thirdGjCheck.ThirdGjCheckProviderToSupervise;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjCheckInfoService;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjOrgAuditLogService;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjOrgCustomerService;
import cn.smarthse.modules.datacentre.enums.CompanyBelongTypeEnum;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import jakarta.annotation.Resource;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.HealthException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ThirdGjOrgCustomerServiceImpl
extends ServiceImpl<ThirdGjOrgCustomerMapper, ThirdGjOrgCustomer>
implements IThirdGjOrgCustomerService {
    @Resource
    private IThirdGjOrgAuditLogService auditLogService;
    @Autowired
    private IThirdGjCheckInfoService infoService;
    @Autowired
    private ReformItemBasicMapper reformItemBasicMapper;
    @Autowired
    private ThirdGjCheckProviderToSupervise thirdGjCheckProviderToSupervise;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;

    @Override
    public Long getCurCustomerIdByCid(Long cid) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(ThirdGjOrgCustomer::getCid, (Object)cid)).in(ThirdGjOrgCustomer::getState, new Object[]{ThirdGjOrgCustomerStateEnum.sign.getValue(), ThirdGjOrgCustomerStateEnum.cancel_audit.getValue(), ThirdGjOrgCustomerStateEnum.cancel_refued.getValue()})).orderByDesc(ThirdGjOrgCustomer::getCreateDate)).last("limit 1");
        ThirdGjOrgCustomer customer = (ThirdGjOrgCustomer)this.getOne((Wrapper)queryWrapper);
        if (customer == null) {
            return null;
        }
        return customer.getId();
    }

    @Override
    public GjOrgCheckStatisticVo getGjOrjCheckStatistic(Long orgId) {
        return ((ThirdGjOrgCustomerMapper)this.baseMapper).getGjOrjCheckStatistic(orgId);
    }

    @Override
    public List<GjOrgCompanyAreaVo> getGjOrjCompanyAreaList(Long orgId) {
        return ((ThirdGjOrgCustomerMapper)this.baseMapper).getGjOrjCompanyAreaList(orgId);
    }

    @Override
    public JqGridData<GjOrgCompanyListVo> getGjOrgCompanyList(GjOrgCompanyQueryParam param) {
        List<Object> list;
        if (param.getType() == 2) {
            param.setRenewalCustomerState(param.getState());
            param.setState(null);
        }
        if (!CollectionUtils.isEmpty(list = ((ThirdGjOrgCustomerMapper)this.baseMapper).getGjOrgCompanyList(param)) && param.getOrgId() != null) {
            this.setRenewalCustomer(list, param.getOrgId());
        }
        if (param.getType() == 2) {
            list = list.stream().filter(o -> o.getRenewalCustomerState() != null && o.getRenewalCustomerState().equals(param.getRenewalCustomerState().intValue())).collect(Collectors.toList());
        }
        if (param.getHasNearDue() != null && param.getHasNearDue() == 1) {
            list = list.stream().filter(o -> o.getIsNearDue() != null && o.getIsNearDue().equals(param.getHasNearDue())).collect(Collectors.toList());
        }
        Integer pageTotal = list.size() % param.getRows() == 0 ? list.size() / param.getRows() : list.size() / param.getRows() + 1;
        List rst = list.stream().skip((long)(param.getPage() - 1) * (long)param.getRows()).limit(param.getRows()).collect(Collectors.toList());
        JqGridData jqGridData = new JqGridData();
        jqGridData.setTotal(pageTotal);
        jqGridData.setPage(Integer.valueOf(param.getPage()));
        jqGridData.setRecords(Integer.valueOf(list.size()));
        jqGridData.setRows(rst);
        return jqGridData;
    }

    void setRenewalCustomer(List<GjOrgCompanyListVo> list, Long orgId) {
        List<Long> cids = list.stream().map(GjOrgCompanyListVo::getCid).collect(Collectors.toList());
        List<ThirdGjOrgCustomer> renewalList = this.getRenewalCustomerList(orgId, cids);
        if (!CollectionUtils.isEmpty(renewalList)) {
            list.forEach(item -> renewalList.forEach(renewal -> {
                if (item.getCid().equals(renewal.getCid())) {
                    if (renewal.getState().equals(ThirdGjOrgCustomerStateEnum.sign_not_effective.getValue()) || renewal.getState().equals(ThirdGjOrgCustomerStateEnum.cancel_audit.getValue()) || renewal.getState().equals(ThirdGjOrgCustomerStateEnum.sign.getValue()) || renewal.getState().equals(ThirdGjOrgCustomerStateEnum.cancel_refued.getValue())) {
                        item.setExpireTime(renewal.getExpireTime());
                    }
                    item.setRenewalCustomerId(renewal.getId());
                    item.setRenewalCustomerState(renewal.getState());
                }
            }));
        }
    }

    void setRenewalCustomer2(List<ThirdGjOrgCustomer> list, Long orgId) {
        List<Long> cids = list.stream().map(ThirdGjOrgCustomer::getCid).collect(Collectors.toList());
        List<ThirdGjOrgCustomer> renewalList = this.getRenewalCustomerList(orgId, cids);
        if (!CollectionUtils.isEmpty(renewalList)) {
            list.forEach(item -> renewalList.forEach(renewal -> {
                if (item.getCid().equals(renewal.getCid()) && (renewal.getState().equals(ThirdGjOrgCustomerStateEnum.sign_not_effective.getValue()) || renewal.getState().equals(ThirdGjOrgCustomerStateEnum.cancel_audit.getValue()) || renewal.getState().equals(ThirdGjOrgCustomerStateEnum.sign.getValue()) || renewal.getState().equals(ThirdGjOrgCustomerStateEnum.cancel_refued.getValue()))) {
                    item.setExpireTime(renewal.getExpireTime());
                }
            }));
        }
    }

    public List<ThirdGjOrgCustomer> getRenewalCustomerList(Long orgId, List<Long> cids) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(ThirdGjOrgCustomer::getType, (Object)ThirdGjOrgCustomerTypeEnum.type2.getValue())).eq(ThirdGjOrgCustomer::getOrgId, (Object)orgId)).ge(ThirdGjOrgCustomer::getSignTime, (Object)LocalDate.now())).in(ThirdGjOrgCustomer::getState, new Object[]{0, 1, 2, 3, 4, 6})).groupBy(ThirdGjOrgCustomer::getCid);
        if (!CollectionUtils.isEmpty(cids)) {
            queryWrapper.in(ThirdGjOrgCustomer::getCid, cids);
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public int getSignedCompanyNumByOrgId(Long orgId) {
        List<ThirdGjOrgCustomer> customerList = this.getCustomerListByOrgId(orgId);
        return CollectionUtils.isEmpty(customerList) ? 0 : customerList.size();
    }

    @Override
    public int getUnCheckCompanyNumByOrgId(Long orgId) {
        List<ThirdGjOrgCustomer> customerList = this.getCustomerListByOrgId(orgId);
        if (CollectionUtils.isEmpty(customerList)) {
            return 0;
        }
        int rst = (int)customerList.stream().filter(customer -> customer.getCurCycle() == 1 && customer.getFirstCheckNum() == 0 || customer.getCurCycle() == 2 && customer.getSecondCheckNum() == 0).count();
        return rst;
    }

    @Override
    public int getNeedCheckCompanyNumByOrgId(Long orgId) {
        List<ThirdGjOrgCustomer> customerList = this.getCustomerListByOrgId(orgId);
        if (CollectionUtils.isEmpty(customerList)) {
            return 0;
        }
        return (int)customerList.stream().filter(customer -> customer.getNeedCheck() == 1).count();
    }

    @Override
    public int getNeedCheckCompanyNumByAdmin(Long orgId, Long areaId, Integer areaLevel) {
        List<ThirdGjOrgCustomer> customers = this.getCustomersByAdmin(orgId, areaId, areaLevel);
        if (CollectionUtils.isEmpty(customers)) {
            return 0;
        }
        return (int)customers.stream().filter(customer -> customer.getNeedCheck() == 1).count();
    }

    @Override
    public int getOverDueCompanyNumByOrgId(Long orgId, Integer status) {
        List<ThirdGjOrgCustomer> customerList = this.getCustomerListByOrgId(orgId);
        if (CollectionUtils.isEmpty(customerList)) {
            return 0;
        }
        if (status == 0) {
            return (int)customerList.stream().filter(customer -> Objects.equals(customer.getWarningStatus(), GjCustomerWarningStatusEnum.NO_WARNING.getValue())).count();
        }
        if (status == 1) {
            return (int)customerList.stream().filter(customer -> Objects.equals(customer.getWarningStatus(), GjCustomerWarningStatusEnum.WARNING.getValue()) || Objects.equals(customer.getWarningStatus(), GjCustomerWarningStatusEnum.OVERDUE_WARNING.getValue())).count();
        }
        if (status == 2) {
            return (int)customerList.stream().filter(customer -> Objects.equals(customer.getWarningStatus(), GjCustomerWarningStatusEnum.OVERDUE.getValue()) || Objects.equals(customer.getWarningStatus(), GjCustomerWarningStatusEnum.OVERDUE_WARNING.getValue())).count();
        }
        return customerList.size();
    }

    @Override
    public int getNearDueCompanyNumByOrgId(Long orgId) {
        List<ThirdGjOrgCustomer> customerList = this.getCustomerListByOrgId(orgId);
        this.setRenewalCustomer2(customerList, orgId);
        if (CollectionUtils.isEmpty(customerList)) {
            return 0;
        }
        Calendar instance = Calendar.getInstance();
        instance.add(5, 60);
        return (int)customerList.stream().filter(customer -> instance.getTime().getTime() > customer.getExpireTime().getTime()).count();
    }

    @Override
    public int getNearDueCompanyNumByAdmin(Long orgId, Long areaId, Integer areaLevel) {
        List<ThirdGjOrgCustomer> customerList = this.getCustomersByAdmin(orgId, areaId, areaLevel);
        if (CollectionUtils.isEmpty(customerList)) {
            return 0;
        }
        Calendar instance = Calendar.getInstance();
        instance.add(5, 60);
        return (int)customerList.stream().filter(customer -> instance.getTime().getTime() > customer.getExpireTime().getTime()).count();
    }

    @Override
    public List<ThirdGjOrgCustomer> getCustomerListByOrgId(Long orgId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(ThirdGjOrgCustomer::getState, new Object[]{2, 4, 6});
        if (orgId != null) {
            queryWrapper.eq(ThirdGjOrgCustomer::getOrgId, (Object)orgId);
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<ThirdGjOrgCustomer> getCustomersByAdmin(Long orgId, Long areaId, Integer areaLevel) {
        return ((ThirdGjOrgCustomerMapper)this.baseMapper).getCustomersByAdminAreaId(orgId, areaId, areaLevel);
    }

    @Override
    public int getCustomersNumByAdmin(Long orgId, Long areaId, Integer areaLevel) {
        List<ThirdGjOrgCustomer> customers = this.getCustomersByAdmin(orgId, areaId, areaLevel);
        return CollectionUtils.isEmpty(customers) ? 0 : customers.size();
    }

    @Override
    public GjOrgCustomerStatisticVo getCustomerStatisticForGjOrj(Long customerId) {
        GjOrgCustomerStatisticVo rst = new GjOrgCustomerStatisticVo();
        ThirdGjOrgCustomer customer = (ThirdGjOrgCustomer)this.getById(customerId);
        CompanyInfoVo companyBaseInfo = ((ThirdGjOrgCustomerMapper)this.baseMapper).getCompanyBaseInfo(customer.getCid());
        ReformStasticsVo reformStatisticsByCid = this.reformItemBasicMapper.getReformStatisticsByCid(customer.getCid());
        rst.setCid(customer.getCid());
        rst.setUnitName(companyBaseInfo.getName());
        rst.setAddress(companyBaseInfo.getWorkAddress());
        rst.setCheckedTotalNum(this.infoService.getCheckNumByCustomer(customerId, null, null));
        rst.setFirstCheckStatus(customer.getFirstCheckStatus());
        rst.setSecondCheckStatus(customer.getSecondCheckStatus());
        rst.setUnAcceptRiskNum(reformStatisticsByCid.getUnacceptRiskNum());
        rst.setUnReformRiskNum(reformStatisticsByCid.getUnReformRiskNum());
        rst.setState(customer.getState());
        rst.setWarningStatus(customer.getWarningStatus());
        rst.setCanCancelCustomerNum(this.getCanCancelCustomerNum(customer.getCid()));
        rst.setCheckContinueGjOrgCustomer(Boolean.valueOf(this.checkContinueGjOrgCustomer(customer.getCid(), customer.getOrgId())));
        rst.setSecondCheckStartDate(this.calSecondCheckStartDateByCustomer(customer));
        List<JurisdictionalUnitListAdminVo> remainingSigningTimeList = ((ThirdGjOrgCustomerMapper)this.baseMapper).countRemainingSigningTime(Arrays.asList(customer.getCid()));
        if (!CollectionUtils.isEmpty(remainingSigningTimeList)) {
            rst.setExpirationDays(remainingSigningTimeList.get(0).getRemainingSigningTime());
        }
        return rst;
    }

    @Override
    public CompanyCustomerStatisticVo getCustomerStatisticForCompany(Long customerId) {
        CompanyCustomerStatisticVo rst = new CompanyCustomerStatisticVo();
        ThirdGjOrgCustomer customer = (ThirdGjOrgCustomer)this.getById(customerId);
        ReformStasticsVo reformStatisticsByCid = this.reformItemBasicMapper.getReformStatisticsByCid(customer.getCid());
        rst.setCustomerId(customerId);
        rst.setOrgId(customer.getOrgId());
        rst.setGjOrgId(customer.getGjOrgId());
        rst.setCheckedTotalNum(this.infoService.getCheckNumByCustomer(customerId, null, null));
        rst.setFirstCheckStatus(customer.getFirstCheckStatus());
        rst.setSecondCheckStatus(customer.getSecondCheckStatus());
        rst.setUnAcceptRiskNum(reformStatisticsByCid.getUnacceptRiskNum());
        rst.setUnReformRiskNum(reformStatisticsByCid.getUnReformRiskNum());
        rst.setWarningStatus(customer.getWarningStatus());
        rst.setType(customer.getType());
        rst.setState(customer.getState());
        rst.setSecondCheckStartDate(this.calSecondCheckStartDateByCustomer(customer));
        List<JurisdictionalUnitListAdminVo> remainingSigningTimeList = ((ThirdGjOrgCustomerMapper)this.baseMapper).countRemainingSigningTime(Arrays.asList(customer.getCid()));
        if (!CollectionUtils.isEmpty(remainingSigningTimeList)) {
            rst.setExpirationDays(remainingSigningTimeList.get(0).getRemainingSigningTime());
        }
        return rst;
    }

    private Date calSecondCheckStartDateByCustomer(ThirdGjOrgCustomer customer) {
        if (customer.getCurCycle() == null || customer.getCurCycle() == 2) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(customer.getSignTime());
        calendar.add(1, customer.getCurContractYear() - 1);
        calendar.add(2, 6);
        calendar.add(5, 1);
        return calendar.getTime();
    }

    @Override
    @Transactional
    public void searchAndUpdateCustomerAboutCheck(Long customerId) {
        if (null == customerId) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(ThirdGjOrgCustomer::getState, new Object[]{ThirdGjOrgCustomerStateEnum.sign.getValue(), ThirdGjOrgCustomerStateEnum.cancel_audit.getValue(), ThirdGjOrgCustomerStateEnum.cancel_refued.getValue()});
            List customerList = this.list((Wrapper)queryWrapper);
            customerList.forEach(this::handleCustomerCheckRelatedStatus);
            this.updateBatchById(customerList);
        } else {
            ThirdGjOrgCustomer customer = (ThirdGjOrgCustomer)this.getById(customerId);
            this.handleCustomerCheckRelatedStatus(customer);
            this.updateById(customer);
        }
    }

    @Override
    @Transactional
    public void searchAndUpdateCustomerAboutState(Long customerId) {
        if (null == customerId) {
            List<ThirdGjOrgCustomer> customerList = ((ThirdGjOrgCustomerMapper)this.baseMapper).searchNeedChangeCustomerState();
            customerList.stream().forEach(customer -> {
                customer.setState(ThirdGjOrgCustomerStateEnum.cancel.getValue());
                customer.setUnsignType(ThirdGjOrgCustomerUnsignTypeEnum.EXPIRE.getValue());
                customer.setCancelTime(customer.getExpireTime());
            });
            this.updateBatchById(customerList);
        } else {
            ThirdGjOrgCustomer customer2 = (ThirdGjOrgCustomer)this.getById(customerId);
            customer2.setState(ThirdGjOrgCustomerStateEnum.cancel.getValue());
            customer2.setUnsignType(ThirdGjOrgCustomerUnsignTypeEnum.EXPIRE.getValue());
            customer2.setCancelTime(customer2.getExpireTime());
            this.updateById(customer2);
        }
    }

    @Override
    @Transactional
    public void searchAndUpdateCustomerAboutCur(Long customerId) {
        LocalDate nowDate = LocalDate.now();
        if (null == customerId) {
            List<ThirdGjOrgCustomer> customerList = ((ThirdGjOrgCustomerMapper)this.baseMapper).searchNeedChangeCustomerCur();
            List collect = customerList.stream().filter(c -> nowDate.isAfter(c.getSignTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().plusYears(c.getCurContractYear().intValue())) || nowDate.isAfter(c.getSignTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().plusMonths(12L * (long)(c.getCurContractYear() - 1) + 6L * (long)c.getCurCycle().intValue()))).collect(Collectors.toList());
            collect.stream().forEach(customer -> this.handleCustomerCurRelatedStatus((ThirdGjOrgCustomer)customer, nowDate));
            this.updateBatchById(collect);
            List collect2 = customerList.stream().filter(c -> nowDate.isEqual(c.getSignTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate())).collect(Collectors.toList());
            collect2.stream().forEach(customer -> this.handleCustomerCurStatus2((ThirdGjOrgCustomer)customer, nowDate));
            this.updateBatchById(collect2);
        } else {
            ThirdGjOrgCustomer customer2 = (ThirdGjOrgCustomer)this.getById(customerId);
            this.handleCustomerCurRelatedStatus(customer2, nowDate);
            this.handleCustomerCurStatus2(customer2, nowDate);
            this.updateById(customer2);
        }
    }

    @Override
    @Transactional
    public void searchAndUpdateCustomerAboutUpdateNotEffect() {
        List<ThirdGjOrgCustomer> customerList = this.getNotEffectCustomerList();
        if (!CollectionUtils.isEmpty(customerList)) {
            Iterator<ThirdGjOrgCustomer> iterator = customerList.iterator();
            while (iterator.hasNext()) {
                ThirdGjOrgCustomer customer = iterator.next();
                if (this.isExistsActiveGjOrgCustomer(customer.getOrgId(), customer.getCid())) {
                    iterator.remove();
                    continue;
                }
                customer.setState(ThirdGjOrgCustomerStateEnum.sign.getValue());
                customer.setIsShowData(Integer.valueOf(1));
                customer.setFirstCheckStatus(Integer.valueOf(1));
            }
        }
        if (!CollectionUtils.isEmpty(customerList)) {
            List<Long> cids = customerList.stream().map(ThirdGjOrgCustomer::getCid).collect(Collectors.toList());
            this.updateBatchById(customerList);
            this.updateCustomerIsShowData(cids);
            this.thirdGjCheckProviderToSupervise.addAutoCreateCheck(customerList);
        }
    }

    public List<ThirdGjOrgCustomer> getNotEffectCustomerList() {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(ThirdGjOrgCustomer::getIsValid, (Object)Constant.ACTIVE_YES)).eq(ThirdGjOrgCustomer::getIsShowData, (Object)0)).eq(ThirdGjOrgCustomer::getType, (Object)ThirdGjOrgCustomerTypeEnum.type2.getValue())).in(ThirdGjOrgCustomer::getState, new Object[]{0, 4, 6})).le(ThirdGjOrgCustomer::getSignTime, (Object)new Date());
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<CompanyAreaChangedVo> selectAreaChanged(LocalDate date, Long cid) {
        return ((ThirdGjOrgCustomerMapper)this.baseMapper).selectAreaChanged(date, cid);
    }

    private void handleCustomerCurRelatedStatus(ThirdGjOrgCustomer customer, LocalDate nowDate) {
        LocalDate signDate = customer.getSignTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        Period between = Period.between(signDate, nowDate);
        int years = between.getYears();
        int months = between.getMonths();
        int days = between.getDays();
        int curYear = years + 1;
        int beforeYear = customer.getCurContractYear();
        int beforeCycle = customer.getCurCycle();
        customer.setCurContractYear(Integer.valueOf(curYear));
        if (beforeYear == curYear && (months == 6 && days > 0 || months > 6)) {
            customer.setCurCycle(GjCustomerCycleEnum.SECOND.getValue());
            customer.setSecondCheckStatus(GjCustomerCheckStatusEnum.CHECKING.getValue());
            customer.setNeedCheck(Integer.valueOf(1));
            if (customer.getFirstCheckStatus().equals(GjCustomerCheckStatusEnum.CHECKING.getValue())) {
                customer.setFirstCheckStatus(GjCustomerCheckStatusEnum.INCOMPLETE.getValue());
            }
        } else {
            customer.setCurCycle(GjCustomerCycleEnum.FIRST.getValue());
            customer.setFirstCheckStatus(GjCustomerCheckStatusEnum.CHECKING.getValue());
            customer.setNeedCheck(Integer.valueOf(1));
        }
        ThirdGjCheckInfo info = new ThirdGjCheckInfo();
        info.setOrgId(customer.getOrgId());
        info.setCid(customer.getCid());
        info.setUnitName(customer.getUnitName());
        info.setCustomerId(customer.getId());
        info.setCheckStatus(CheckStatusEnums.CHECKING.getCode());
        info.setCreateSignTime(customer.getSignTime());
        info.setIsAutoCreate(Integer.valueOf(1));
        if (beforeYear != curYear) {
            info.setCheckName(String.format("%s\u5408\u540c-\u670d\u52a1\u5468\u671f%s-%s\u670d\u52a1-\u7cfb\u7edf\u81ea\u52a8\u521b\u5efa", signDate, curYear, GjCustomerCycleEnum.getName((Integer)1)));
            info.setCreateContractYear(Integer.valueOf(curYear));
            info.setCreateCycle(Integer.valueOf(1));
        }
        if (beforeYear == curYear && (months == 6 && days > 0 || months > 6)) {
            info.setCheckName(String.format("%s\u5408\u540c-\u670d\u52a1\u5468\u671f%s-%s\u670d\u52a1-\u7cfb\u7edf\u81ea\u52a8\u521b\u5efa", signDate, curYear, GjCustomerCycleEnum.getName((Integer)2)));
            info.setCreateContractYear(Integer.valueOf(curYear));
            info.setCreateCycle(Integer.valueOf(2));
        }
        this.infoService.save(info);
    }

    private void handleCustomerCurStatus2(ThirdGjOrgCustomer customer, LocalDate nowDate) {
        LocalDate signDate = customer.getSignTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        customer.setFirstCheckStatus(GjCustomerCheckStatusEnum.CHECKING.getValue());
        ThirdGjCheckInfo autoCreateCheck = this.infoService.getAutoCreateCheckByCustomer(customer.getId(), 1, 1);
        if (autoCreateCheck == null) {
            ThirdGjCheckInfo info = new ThirdGjCheckInfo();
            info.setOrgId(customer.getOrgId());
            info.setCid(customer.getCid());
            info.setUnitName(customer.getUnitName());
            info.setCustomerId(customer.getId());
            info.setCheckStatus(CheckStatusEnums.CHECKING.getCode());
            info.setCreateSignTime(customer.getSignTime());
            info.setIsAutoCreate(Integer.valueOf(1));
            info.setCheckName(String.format("%s\u5408\u540c-\u670d\u52a1\u5468\u671f%s-%s\u670d\u52a1-\u7cfb\u7edf\u81ea\u52a8\u521b\u5efa", signDate, 1, GjCustomerCycleEnum.getName((Integer)1)));
            info.setCreateContractYear(Integer.valueOf(1));
            info.setCreateCycle(Integer.valueOf(1));
            this.infoService.save(info);
        }
    }

    private void handleCustomerCheckRelatedStatus(ThirdGjOrgCustomer customer) {
        ThirdGjCheckInfo autoCreateCheck = this.infoService.getAutoCreateCheckByCustomer(customer.getId(), customer.getCurContractYear(), customer.getCurCycle());
        if (autoCreateCheck == null) {
            return;
        }
        Integer checkNum = this.infoService.getCheckNumByCustomer(customer.getId(), customer.getCurContractYear(), customer.getCurCycle());
        customer.setWarningStatus(this.infoService.getCustomerWarningStatusByCustomerId(customer.getId()));
        if (Objects.equals(customer.getCurCycle(), GjCustomerCycleEnum.FIRST.getValue())) {
            customer.setFirstCheckNum(checkNum);
            if (Objects.equals(autoCreateCheck.getCheckStatus(), CheckStatusEnums.NOT_STARTED.getCode())) {
                customer.setFirstCheckStatus(GjCustomerCheckStatusEnum.CHECKING.getValue());
                customer.setNeedCheck(Integer.valueOf(0));
            } else if (Objects.equals(autoCreateCheck.getCheckStatus(), CheckStatusEnums.CHECKING.getCode())) {
                customer.setFirstCheckStatus(GjCustomerCheckStatusEnum.CHECKING.getValue());
                customer.setNeedCheck(Integer.valueOf(1));
            } else if (Objects.equals(autoCreateCheck.getCheckStatus(), CheckStatusEnums.DONE.getCode()) || Objects.equals(autoCreateCheck.getCheckStatus(), CheckStatusEnums.END.getCode())) {
                customer.setFirstCheckStatus(GjCustomerCheckStatusEnum.DONE.getValue());
                customer.setNeedCheck(Integer.valueOf(2));
            }
        } else if (Objects.equals(customer.getCurCycle(), GjCustomerCycleEnum.SECOND.getValue())) {
            customer.setSecondCheckNum(checkNum);
            if (Objects.equals(autoCreateCheck.getCheckStatus(), CheckStatusEnums.NOT_STARTED.getCode())) {
                customer.setSecondCheckStatus(GjCustomerCheckStatusEnum.CHECKING.getValue());
                customer.setNeedCheck(Integer.valueOf(1));
            } else if (Objects.equals(autoCreateCheck.getCheckStatus(), CheckStatusEnums.CHECKING.getCode())) {
                customer.setSecondCheckStatus(GjCustomerCheckStatusEnum.CHECKING.getValue());
                customer.setNeedCheck(Integer.valueOf(1));
            } else if (Objects.equals(autoCreateCheck.getCheckStatus(), CheckStatusEnums.DONE.getCode()) || Objects.equals(autoCreateCheck.getCheckStatus(), CheckStatusEnums.END.getCode())) {
                customer.setSecondCheckStatus(GjCustomerCheckStatusEnum.DONE.getValue());
                customer.setNeedCheck(Integer.valueOf(2));
            }
        }
    }

    @Override
    public HomeData getHomeData(Long orgId) {
        return ((ThirdGjOrgCustomerMapper)this.baseMapper).getHomeData(orgId);
    }

    @Override
    public void updateStateById(Long id, Integer state) {
        LambdaUpdateWrapper lambdaUpdateWrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)lambdaUpdateWrapper.eq(ThirdGjOrgCustomer::getId, (Object)id)).eq(ThirdGjOrgCustomer::getIsValid, (Object)true)).set(ThirdGjOrgCustomer::getState, (Object)state);
        this.update((Wrapper)lambdaUpdateWrapper);
    }

    @Override
    @Transactional
    public ThirdGjOrgCustomer orgSignCompAudit(GjOrgSignCompAuditParam param) {
        ThirdGjOrgCustomer orgCustomer = (ThirdGjOrgCustomer)this.getById(param.getGjOrgCustomerId());
        if (param.getSignType().equals(ThirdGjOrgAuditLogTypeEnum.third_gj_org_customer_cancel.getValue())) {
            if (param.getState().equals(ThirdGjOrgAuditResultEnum.PASS.getValue())) {
                orgCustomer.setState(ThirdGjOrgCustomerStateEnum.cancel.getValue());
                orgCustomer.setUnsignType(ThirdGjOrgCustomerUnsignTypeEnum.CANCEL.getValue());
                orgCustomer.setCancelTime(new Date());
            } else {
                orgCustomer.setState(ThirdGjOrgCustomerStateEnum.cancel_refued.getValue());
            }
        } else if (param.getSignType().equals(ThirdGjOrgAuditLogTypeEnum.third_gj_org_customer_sign.getValue())) {
            if (param.getType() == 1 && param.getState().equals(ThirdGjOrgAuditResultEnum.PASS.getValue())) {
                if (this.isExistsActiveGjOrgCustomer(orgCustomer.getOrgId(), orgCustomer.getCid())) {
                    throw new HealthException("\u8be5\u4f01\u4e1a\u5df2\u88ab\u7b7e\u7ea6\uff01");
                }
                orgCustomer.setConcludeTime(new Date());
                orgCustomer.setIsShowData(Integer.valueOf(1));
                this.initCustomerCheckStatusForAudit(orgCustomer);
                this.updateCustomerIsShowData(Collections.singletonList(orgCustomer.getCid()));
            }
            if (param.getType() == 2 && param.getState().equals(ThirdGjOrgAuditResultEnum.PASS.getValue())) {
                orgCustomer.setState(ThirdGjOrgCustomerStateEnum.sign_not_effective.getValue());
                orgCustomer.setConcludeTime(new Date());
                this.initCustomerCheckStatusForAudit(orgCustomer);
            } else {
                orgCustomer.setState(param.getState());
            }
        }
        this.updateById(orgCustomer);
        ThirdGjOrgAuditLog log = new ThirdGjOrgAuditLog().setType(param.getSignType()).setBusinessId(param.getGjOrgCustomerId()).setOptPeople(param.getOptPeople()).setOptValue(ThirdGjOrgAuditOptEnum.customer_sign_opt_2.getOptValue()).setOpt(ThirdGjOrgAuditOptEnum.customer_sign_opt_2.getOptName()).setOptDesc(param.getReason());
        if (param.getState().equals(ThirdGjOrgAuditResultEnum.RETURNED.getValue())) {
            log.setOptValue(ThirdGjOrgAuditOptEnum.customer_sign_opt_3.getOptValue());
            log.setOpt(ThirdGjOrgAuditOptEnum.customer_sign_opt_3.getOptName());
        }
        if (param.getSignType().equals(ThirdGjOrgAuditLogTypeEnum.third_gj_org_customer_cancel.getValue())) {
            if (param.getState().equals(ThirdGjOrgAuditResultEnum.PASS.getValue())) {
                log.setOptValue(ThirdGjOrgAuditOptEnum.customer_cancel_opt_2.getOptValue());
                log.setOpt(ThirdGjOrgAuditOptEnum.customer_cancel_opt_2.getOptName());
            }
            if (param.getState().equals(ThirdGjOrgAuditResultEnum.RETURNED.getValue())) {
                log.setOptValue(ThirdGjOrgAuditOptEnum.customer_cancel_opt_3.getOptValue());
                log.setOpt(ThirdGjOrgAuditOptEnum.customer_cancel_opt_3.getOptName());
            }
        }
        this.auditLogService.save(log);
        return orgCustomer;
    }

    @Override
    @Transactional
    public ThirdGjOrgCustomer cancelSignByAdmin(Long gjOrgCustomerId, String optPeople) {
        ThirdGjOrgCustomer orgCustomer = (ThirdGjOrgCustomer)this.getById(gjOrgCustomerId);
        if (orgCustomer == null) {
            return null;
        }
        List<ThirdGjOrgCustomer> customerList = this.getRenewalCustomerList(orgCustomer.getOrgId(), orgCustomer.getCid());
        ArrayList auditLogs = new ArrayList();
        customerList.add(orgCustomer);
        customerList.forEach(customer -> {
            customer.setState(ThirdGjOrgCustomerStateEnum.cancel.getValue());
            customer.setUnsignType(ThirdGjOrgCustomerUnsignTypeEnum.ADMIN_CANCEL.getValue());
            customer.setCancelTime(new Date());
            ThirdGjOrgAuditLog log = new ThirdGjOrgAuditLog().setType(ThirdGjOrgAuditLogTypeEnum.third_gj_org_customer_cancel.getValue()).setBusinessId(customer.getId()).setOptPeople(optPeople).setOptDesc("\u76d1\u7ba1\u89e3\u7ea6").setOptValue(ThirdGjOrgAuditOptEnum.customer_cancel_opt_2.getOptValue()).setOpt(ThirdGjOrgAuditOptEnum.customer_cancel_opt_2.getOptName());
            auditLogs.add(log);
        });
        this.updateBatchById(customerList);
        this.auditLogService.updateBatchById(auditLogs);
        return orgCustomer;
    }

    public List<ThirdGjOrgCustomer> getRenewalCustomerList(Long orgId, Long cid) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(ThirdGjOrgCustomer.class);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ThirdGjOrgCustomer::getOrgId, (Object)orgId)).eq(ThirdGjOrgCustomer::getCid, (Object)cid)).eq(ThirdGjOrgCustomer::getIsValid, (Object)true)).eq(ThirdGjOrgCustomer::getType, (Object)ThirdGjOrgCustomerTypeEnum.type2.getValue())).eq(ThirdGjOrgCustomer::getState, (Object)ThirdGjOrgCustomerStateEnum.sign_not_effective.getValue());
        return ((ThirdGjOrgCustomerMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public ThirdGjOrgCustomer getLastGjOrgCustomer(Long orgId, Long cid) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(ThirdGjOrgCustomer.class);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ThirdGjOrgCustomer::getOrgId, (Object)orgId)).eq(ThirdGjOrgCustomer::getCid, (Object)cid)).eq(ThirdGjOrgCustomer::getIsValid, (Object)true)).orderByDesc(ThirdGjOrgCustomer::getId)).last("limit 1");
        return (ThirdGjOrgCustomer)((ThirdGjOrgCustomerMapper)this.baseMapper).selectOne((Wrapper)wrapper);
    }

    @Override
    public ThirdGjOrgCustomer getLastEffectiveGjOrgCustomer(Long orgId, Long cid) {
        ThirdGjOrgCustomer rst = null;
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(ThirdGjOrgCustomer.class);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ThirdGjOrgCustomer::getOrgId, (Object)orgId)).eq(ThirdGjOrgCustomer::getCid, (Object)cid)).eq(ThirdGjOrgCustomer::getType, (Object)ThirdGjOrgCustomerTypeEnum.type2.getValue())).in(ThirdGjOrgCustomer::getState, new Object[]{0, 4, 6})).eq(ThirdGjOrgCustomer::getIsValid, (Object)true)).orderByDesc(ThirdGjOrgCustomer::getCreateDate)).last("limit 1");
        rst = (ThirdGjOrgCustomer)this.getOne((Wrapper)wrapper);
        if (rst == null) {
            wrapper.clear();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ThirdGjOrgCustomer::getOrgId, (Object)orgId)).eq(ThirdGjOrgCustomer::getCid, (Object)cid)).in(ThirdGjOrgCustomer::getState, new Object[]{2, 4, 6})).eq(ThirdGjOrgCustomer::getIsValid, (Object)true)).orderByDesc(ThirdGjOrgCustomer::getCreateDate)).last("limit 1");
            rst = (ThirdGjOrgCustomer)this.getOne((Wrapper)wrapper);
        }
        return rst;
    }

    @Override
    public List<UnitServiceAreaStatisticsAdminVo> getUnitServiceAreaStatisticsListForAdmin(UnitServcieAreaStatisticsListParam param) {
        List<UnitServiceAreaStatisticsAdminVo> scopeList = ((ThirdGjOrgCustomerMapper)this.baseMapper).getServiceScopeStatisticsListForAdmin(param);
        List<UnitServiceAreaStatisticsAdminVo> voList = ((ThirdGjOrgCustomerMapper)this.baseMapper).getUnitServiceAreaStatisticsListForAdmin(param);
        Map<Long, UnitServiceAreaStatisticsAdminVo> voMap = voList.stream().collect(Collectors.toMap(v -> v.getAreaId(), v -> v));
        for (UnitServiceAreaStatisticsAdminVo scope : scopeList) {
            scope.setBelongType(param.getBelongType());
            if (!voMap.containsKey(scope.getAreaId())) continue;
            UnitServiceAreaStatisticsAdminVo vo = voMap.get(scope.getAreaId());
            scope.setContractedUnitNum(vo.getContractedUnitNum());
            scope.setUnservicedUnitNum(vo.getUnservicedUnitNum());
            scope.setAlarmUnitNum(vo.getAlarmUnitNum());
            scope.setAboutToExpireUnitNum(vo.getAboutToExpireUnitNum());
            scope.setUpperHalfCycleServicedUnitNum(vo.getUpperHalfCycleServicedUnitNum());
            scope.setLowerHalfCycleServicedUnitNum(vo.getLowerHalfCycleServicedUnitNum());
            scope.setUpperHalfCycleUnitNum(vo.getUpperHalfCycleUnitNum());
            scope.setLowerHalfCycleUnitNum(vo.getLowerHalfCycleUnitNum());
            scope.setFullname(vo.getFullname());
        }
        if (param.getAreaLevel() == 2 && param.getIncludeBelongType() != null && CompanyBelongTypeEnum.SHI.getValue().equals(param.getIncludeBelongType())) {
            UnitServcieAreaStatisticsTotalParam totalParam = new UnitServcieAreaStatisticsTotalParam();
            totalParam.setAreaId(param.getAreaId());
            totalParam.setAreaLevel(param.getAreaLevel());
            totalParam.setIfIncludeLt3Unit(param.getIfIncludeLt3Unit());
            totalParam.setBelongType(param.getIncludeBelongType());
            UnitServiceAreaStatisticsAdminVo otherVo = this.getUnitServiceAreaStatisticsTotalForAdmin(totalParam);
            if (otherVo == null) {
                otherVo = new UnitServiceAreaStatisticsAdminVo();
            }
            otherVo.setAreaName("\u5e02\u672c\u7ea7");
            otherVo.setBelongType(param.getIncludeBelongType());
            otherVo.setAreaId(param.getAreaId());
            otherVo.setAreaLevel(param.getAreaLevel());
            ArrayList<UnitServiceAreaStatisticsAdminVo> temp = new ArrayList<UnitServiceAreaStatisticsAdminVo>();
            temp.add(otherVo);
            temp.addAll(scopeList);
            scopeList = temp;
        }
        return scopeList;
    }

    @Override
    public UnitServiceAreaStatisticsAdminVo getUnitServiceAreaStatisticsTotalForAdmin(UnitServcieAreaStatisticsTotalParam param) {
        UnitServiceAreaStatisticsAdminVo scope;
        UnitServiceAreaStatisticsAdminVo unitServiceAreaStatisticsTotal = ((ThirdGjOrgCustomerMapper)this.baseMapper).getUnitServiceAreaStatisticsTotalForAdmin(param);
        if ((param.getBelongType() == null || CompanyBelongTypeEnum.NO.getValue().equals(param.getBelongType())) && (scope = ((ThirdGjOrgCustomerMapper)this.baseMapper).getServiceScopeStatisticsTotal(param)) != null) {
            unitServiceAreaStatisticsTotal.setOrgNum(scope.getOrgNum());
            unitServiceAreaStatisticsTotal.setGjNum(scope.getGjNum());
        }
        unitServiceAreaStatisticsTotal.setLatestUpdateTime(new Date());
        return unitServiceAreaStatisticsTotal;
    }

    @Override
    public JqGridData<JurisdictionalUnitListAdminVo> getSignedUnitListForAdmin(JurisdictionalUnitListParam param) {
        List<Long> cidList;
        List<JurisdictionalUnitListAdminVo> remainingSigningTimeList;
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<JurisdictionalUnitListAdminVo> signedUnitListForAdmin = ((ThirdGjOrgCustomerMapper)this.baseMapper).getSignedUnitListForAdmin(param);
        if (!CollectionUtils.isEmpty(signedUnitListForAdmin) && !CollectionUtils.isEmpty(remainingSigningTimeList = ((ThirdGjOrgCustomerMapper)this.baseMapper).countRemainingSigningTime(cidList = signedUnitListForAdmin.stream().map(v -> v.getCid()).collect(Collectors.toList())))) {
            Map<Long, Integer> remainingSigningTimeMap = remainingSigningTimeList.stream().collect(Collectors.toMap(v -> v.getCid(), v -> v.getRemainingSigningTime()));
            for (JurisdictionalUnitListAdminVo vo : signedUnitListForAdmin) {
                if (!remainingSigningTimeMap.containsKey(vo.getCid())) continue;
                vo.setRemainingSigningTime(remainingSigningTimeMap.get(vo.getCid()));
            }
        }
        return new JqGridData((Page)signedUnitListForAdmin, (JqGridParam)param);
    }

    @Override
    public JqGridData<JurisdictionalUnitListAdminVo> getHasOnceSignedUnitListForAdmin(JurisdictionalUnitListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<JurisdictionalUnitListAdminVo> list = ((ThirdGjOrgCustomerMapper)this.baseMapper).getHasOnceSignedUnitListForAdmin(param);
        return new JqGridData((Page)list, (JqGridParam)param);
    }

    @Override
    public OnUnitServiceStatisticsAdminVo getOneUnitServiceStatisticsForAdmin(OnUnitServiceStatisticsParam param) {
        OnUnitServiceStatisticsAdminVo vo = ((ThirdGjOrgCustomerMapper)this.baseMapper).getOneUnitServiceStatisticsForAdmin(param);
        List<JurisdictionalUnitListAdminVo> remainingSigningTimeList = ((ThirdGjOrgCustomerMapper)this.baseMapper).countRemainingSigningTime(Arrays.asList(param.getCid()));
        if (vo != null) {
            OnUnitServiceStatisticsAdminVo voRisk = ((ThirdGjOrgCustomerMapper)this.baseMapper).getOneUnitServiceRiskStatisticsForAdmin(param);
            if (voRisk != null) {
                vo.setToBeRectifiedNum(vo.getToBeRectifiedNum());
                vo.setToBeAcceptedNum(vo.getToBeAcceptedNum());
            }
            if (!CollectionUtils.isEmpty(remainingSigningTimeList)) {
                vo.setRemainingSigningTime(remainingSigningTimeList.get(0).getRemainingSigningTime());
            }
            String fullAreaName = this.sysAreaProvideService.getFullAreaName(vo.getAreaId(), " ");
            vo.setAreaAddress(fullAreaName);
        }
        return vo;
    }

    @Override
    public JqGridData<JurisdictionalUnitListAdminVo> getSigningApplicationUnitListForAdmin(JurisdictionalUnitListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        return new JqGridData((Page)((ThirdGjOrgCustomerMapper)this.baseMapper).getSigningApplicationUnitListForAdmin(param), (JqGridParam)param);
    }

    @Override
    public JqGridData<JurisdictionalUnitListAdminVo> getTerminationApplicationUnitListForAdmin(JurisdictionalUnitListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        return new JqGridData((Page)((ThirdGjOrgCustomerMapper)this.baseMapper).getTerminationApplicationUnitListForAdmin(param), (JqGridParam)param);
    }

    @Override
    public JqGridData<CompanyCustomerHistoryListVo> getGjOrgCustomerListData(GjOrgCustomerQueryParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        return new JqGridData((Page)((ThirdGjOrgCustomerMapper)this.baseMapper).getGjOrgCustomerList(param), (JqGridParam)param);
    }

    @Override
    public JqGridData<CompanyCustomerHistoryListVo> getSigningRecordsForOneUnit(GjOrgCustomerQueryParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        return new JqGridData((Page)((ThirdGjOrgCustomerMapper)this.baseMapper).getSigningRecordsForOneUnit(param), (JqGridParam)param);
    }

    @Override
    public JqGridData<CompanyCustomerHistoryListVo> listCustomerHistoryForCompany(CompanyCustomerSearchParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        return new JqGridData((Page)((ThirdGjOrgCustomerMapper)this.baseMapper).listCustomerHistoryForCompany(param), (JqGridParam)param);
    }

    @Override
    public JqGridData<GjOrgSignCompHistoryVo> listCustomerHistoryForOrj(CompanyCustomerSearchParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        return new JqGridData((Page)((ThirdGjOrgCustomerMapper)this.baseMapper).listCustomerHistoryForOrj(param), (JqGridParam)param);
    }

    @Override
    public JurisdictionalUnitTabStatisticsAdminVo getJurisdictionalUnitTabStatistics(JurisdictionalUnitListParam param) {
        JurisdictionalUnitTabStatisticsAdminVo vo = new JurisdictionalUnitTabStatisticsAdminVo();
        vo.setSigned(((ThirdGjOrgCustomerMapper)this.baseMapper).getJurisdictionalUnitSignedTabForAdmin(param));
        param.setIfIncludeLt3Unit(Integer.valueOf(1));
        vo.setApplication(((ThirdGjOrgCustomerMapper)this.baseMapper).getJurisdictionalUnitApplicationTabForAdmin(param));
        vo.setTermination(((ThirdGjOrgCustomerMapper)this.baseMapper).getJurisdictionalUnitTerminationTabForAdmin(param));
        return vo;
    }

    @Override
    public List<ThirdGjOrgCustomer> getCustomersByGjOrg(ThirdGjOrg gjOrg) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(ThirdGjOrgCustomer::getIsValid, (Object)Constant.ACTIVE_YES)).eq(ThirdGjOrgCustomer::getOrgId, (Object)gjOrg.getOrgId())).in(ThirdGjOrgCustomer::getState, new Object[]{2, 4, 6});
        if (gjOrg.getLevel() == 3) {
            ((LambdaQueryWrapper)queryWrapper.eq(ThirdGjOrgCustomer::getBelongType, (Object)0)).eq(ThirdGjOrgCustomer::getAreaId3, (Object)gjOrg.getAreaId());
        }
        if (gjOrg.getLevel() == 2) {
            ((LambdaQueryWrapper)queryWrapper.eq(ThirdGjOrgCustomer::getBelongType, (Object)gjOrg.getLevel())).eq(ThirdGjOrgCustomer::getAreaId2, (Object)gjOrg.getAreaId());
        }
        if (gjOrg.getLevel() == 1) {
            ((LambdaQueryWrapper)queryWrapper.eq(ThirdGjOrgCustomer::getBelongType, (Object)gjOrg.getLevel())).eq(ThirdGjOrgCustomer::getAreaId1, (Object)gjOrg.getAreaId());
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public boolean isExistsActiveGjOrgCustomer(Long orgId, Long cid) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(ThirdGjOrgCustomer.class);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ThirdGjOrgCustomer::getCid, (Object)cid)).in(ThirdGjOrgCustomer::getState, new Object[]{2, 4, 6})).eq(ThirdGjOrgCustomer::getIsValid, (Object)Constant.ACTIVE_YES)).orderByDesc(ThirdGjOrgCustomer::getId)).last("limit 1");
        ThirdGjOrgCustomer record = (ThirdGjOrgCustomer)this.getOne((Wrapper)wrapper);
        return record != null;
    }

    @Override
    public boolean checkSubmitGjOrgCustomer(Long cid) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(ThirdGjOrgCustomer.class);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ThirdGjOrgCustomer::getCid, (Object)cid)).in(ThirdGjOrgCustomer::getState, new Object[]{1, 2, 4, 6})).eq(ThirdGjOrgCustomer::getIsValid, (Object)Constant.ACTIVE_YES)).orderByDesc(ThirdGjOrgCustomer::getId)).last("limit 1");
        return this.getOne((Wrapper)wrapper) == null;
    }

    @Override
    public boolean checkContinueGjOrgCustomer(Long cid, Long orgId) {
        ThirdGjOrgCustomer last = this.getLastEffectiveGjOrgCustomer(orgId, cid);
        return last != null && last.getExpireTime() != null && last.getState() != null && DateUtils.addDay((Date)new Date(), (int)60).after(last.getExpireTime()) && !ThirdGjOrgCustomerStateEnum.cancel_audit.getValue().equals(last.getState());
    }

    @Override
    public boolean checkCompSignState(String creditCode) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(ThirdGjOrgCustomer.class);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ThirdGjOrgCustomer::getUnitCreditCode, (Object)creditCode)).in(ThirdGjOrgCustomer::getState, new Object[]{2, 4, 6})).eq(ThirdGjOrgCustomer::getIsValid, (Object)Constant.ACTIVE_YES)).orderByDesc(ThirdGjOrgCustomer::getId)).last("limit 1");
        return this.getOne((Wrapper)wrapper) != null;
    }

    @Override
    public void updateCustomerIsShowData(List<Long> cids) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(ThirdGjOrgCustomer.class);
        ((LambdaQueryWrapper)wrapper.in(ThirdGjOrgCustomer::getCid, cids)).eq(ThirdGjOrgCustomer::getIsValid, (Object)Constant.ACTIVE_YES);
        List customerList = this.list((Wrapper)wrapper);
        customerList.forEach(customer -> customer.setIsShowData(Integer.valueOf(0)));
        this.saveOrUpdateBatch(customerList);
    }

    @Override
    public Integer getCanCancelCustomerNum(Long cid) {
        if (cid == null) {
            return 0;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(ThirdGjOrgCustomer.class);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ThirdGjOrgCustomer::getCid, (Object)cid)).in(ThirdGjOrgCustomer::getState, new Object[]{ThirdGjOrgCustomerStateEnum.sign_not_effective.getValue(), ThirdGjOrgCustomerStateEnum.sign.getValue(), ThirdGjOrgCustomerStateEnum.cancel_refued.getValue()})).gt(ThirdGjOrgCustomer::getExpireTime, (Object)new Date())).eq(ThirdGjOrgCustomer::getIsValid, (Object)Constant.ACTIVE_YES);
        return Math.toIntExact(this.count((Wrapper)wrapper));
    }

    @Override
    public Map<Long, Long> getSignedEnterpriseIdList(List<Long> cidList) {
        List list;
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(ThirdGjOrgCustomer.class);
        ((LambdaQueryWrapper)wrapper.eq(ThirdGjOrgCustomer::getIsValid, (Object)Constant.ACTIVE_YES)).in(ThirdGjOrgCustomer::getState, new Object[]{ThirdGjOrgCustomerStateEnum.sign.getValue(), ThirdGjOrgCustomerStateEnum.cancel_audit.getValue(), ThirdGjOrgCustomerStateEnum.cancel_refued.getValue()});
        if (CollUtil.isNotEmpty(cidList)) {
            wrapper.in(ThirdGjOrgCustomer::getCid, cidList);
        }
        if (CollUtil.isNotEmpty((Collection)(list = this.list((Wrapper)wrapper)))) {
            return list.stream().collect(Collectors.toMap(ThirdGjOrgCustomer::getCid, ThirdGjOrgCustomer::getOrgId, (v1, v2) -> v1));
        }
        return Collections.emptyMap();
    }

    @Override
    public void initCustomerCheckStatusForAudit(ThirdGjOrgCustomer customer) {
        double ceil;
        int curHalfCycleNum;
        LocalDate curHalfCycleEndDate;
        LocalDate signDate;
        LocalDate nowDate = LocalDate.now();
        if (nowDate.isBefore(signDate = customer.getSignTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate())) {
            customer.setCurCycle(GjCustomerCycleEnum.FIRST.getValue());
            customer.setFirstCheckStatus(GjCustomerCheckStatusEnum.NOT_STARTED.getValue());
            customer.setSecondCheckStatus(GjCustomerCheckStatusEnum.NOT_STARTED.getValue());
            customer.setWarningStatus(GjCustomerWarningStatusEnum.NO_WARNING.getValue());
            customer.setNeedCheck(Integer.valueOf(0));
            return;
        }
        Period between = Period.between(signDate, nowDate);
        int years = between.getYears();
        int months = between.getMonths();
        int monthsForCycle = between.getYears() * 12 + (between.getMonths() + 1);
        customer.setCurContractYear(Integer.valueOf(years + 1));
        if (months >= 6) {
            customer.setCurCycle(GjCustomerCycleEnum.SECOND.getValue());
            customer.setFirstCheckStatus(GjCustomerCheckStatusEnum.INCOMPLETE.getValue());
            customer.setSecondCheckStatus(GjCustomerCheckStatusEnum.CHECKING.getValue());
        } else {
            customer.setCurCycle(GjCustomerCycleEnum.FIRST.getValue());
            customer.setFirstCheckStatus(GjCustomerCheckStatusEnum.CHECKING.getValue());
            customer.setSecondCheckStatus(GjCustomerCheckStatusEnum.NOT_STARTED.getValue());
        }
        customer.setNeedCheck(Integer.valueOf(1));
        boolean hasWarning = false;
        boolean hasOver = false;
        if (years * 12 + months >= 6) {
            hasOver = true;
        }
        if ((curHalfCycleEndDate = signDate.plusMonths((long)(curHalfCycleNum = (int)(ceil = Math.ceil((double)monthsForCycle / 6.0))) * 6L)).minusMonths(1L).isBefore(nowDate)) {
            hasWarning = true;
        }
        if (hasOver && hasWarning) {
            customer.setWarningStatus(GjCustomerWarningStatusEnum.OVERDUE_WARNING.getValue());
        } else if (hasWarning) {
            customer.setWarningStatus(GjCustomerWarningStatusEnum.WARNING.getValue());
        } else if (hasOver) {
            customer.setWarningStatus(GjCustomerWarningStatusEnum.OVERDUE.getValue());
        } else {
            customer.setWarningStatus(GjCustomerWarningStatusEnum.NO_WARNING.getValue());
        }
    }
}

