/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.service.thirdGj.impl;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.fwgj.bootstrap.security.service.ShiroUtil;
import cn.smarthse.fwgj.dao.ReformItemBasicMapper;
import cn.smarthse.fwgj.dao.thirdGj.ThirdGjCheckInfoMapper;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjCheckInfo;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjCheckItem;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgAuditLog;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgCustomer;
import cn.smarthse.fwgj.enums.GjCheckInfoSupplyAuditStateEnum;
import cn.smarthse.fwgj.enums.GjCheckInfoSupplyStatusEnum;
import cn.smarthse.fwgj.enums.GjCheckInfoWarningStatusEnum;
import cn.smarthse.fwgj.enums.GjCustomerCycleEnum;
import cn.smarthse.fwgj.enums.GjCustomerWarningStatusEnum;
import cn.smarthse.fwgj.enums.ThirdGjOrgAuditLogTypeEnum;
import cn.smarthse.fwgj.enums.ThirdGjOrgAuditOptEnum;
import cn.smarthse.fwgj.enums.thirdGj.CheckStatusEnums;
import cn.smarthse.fwgj.model.param.CheckRecordParam;
import cn.smarthse.fwgj.model.param.CompanyListParam;
import cn.smarthse.fwgj.model.param.admin.GjServiceYearListParam;
import cn.smarthse.fwgj.model.param.admin.OneUnitServiceRecordListParam;
import cn.smarthse.fwgj.model.param.admin.OrgGjServiceListParam;
import cn.smarthse.fwgj.model.param.admin.UnitServiceIdentificationParam;
import cn.smarthse.fwgj.model.param.third.GjCheckQueryParam;
import cn.smarthse.fwgj.model.param.third.GjOrgWarningCheckParam;
import cn.smarthse.fwgj.model.vo.CheckNumVo;
import cn.smarthse.fwgj.model.vo.CompanyInfoVo;
import cn.smarthse.fwgj.model.vo.admin.OneUnitServiceRecordListAdminVo;
import cn.smarthse.fwgj.model.vo.admin.OrgGjServiceListAdminVo;
import cn.smarthse.fwgj.model.vo.third.CheckRecordVo;
import cn.smarthse.fwgj.model.vo.third.GjCheckListVo;
import cn.smarthse.fwgj.model.vo.third.GjOrgWarningCheckVo;
import cn.smarthse.fwgj.model.vo.third.GjUserStatisticsVo;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjCheckInfoService;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjCheckItemService;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjOrgAuditLogService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.platform.model.AreaModel;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ThirdGjCheckInfoServiceImpl
extends ServiceImpl<ThirdGjCheckInfoMapper, ThirdGjCheckInfo>
implements IThirdGjCheckInfoService {
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService areaProvideService;
    private final IThirdGjCheckItemService checkItemService;
    private final ReformItemBasicMapper reformItemBasicMapper;
    @Autowired
    private IThirdGjOrgAuditLogService thirdGjOrgAuditLogService;

    @Override
    public int getCheckCompanyNum(Long areaId, Integer year) {
        CompanyListParam param = new CompanyListParam();
        param.setStatus(2);
        AreaModel area = this.areaProvideService.getAreaById(areaId);
        return ((ThirdGjCheckInfoMapper)this.baseMapper).selectBatchCompanyByArea_COUNT(param).intValue();
    }

    @Override
    public int getUnCheckCompanyNum(Long areaId, Integer year) {
        CompanyListParam param = new CompanyListParam();
        param.setStatus(1);
        AreaModel area = this.areaProvideService.getAreaById(areaId);
        return ((ThirdGjCheckInfoMapper)this.baseMapper).selectBatchCompanyByArea_COUNT(param).intValue();
    }

    @Override
    public Map getUnCheckCompanyNumByAreaPid(Long areaId, Integer areaLevel) {
        return ((ThirdGjCheckInfoMapper)this.baseMapper).getUnCheckCompanyNumByAreaPid(areaId, areaLevel);
    }

    @Override
    public Date getLastCheckDateByCid(Long cid) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(ThirdGjCheckInfo.class);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ThirdGjCheckInfo::getCid, (Object)cid)).eq(ThirdGjCheckInfo::getIsValid, (Object)1)).in(ThirdGjCheckInfo::getCheckStatus, new Object[]{"2", "3"})).orderByDesc(ThirdGjCheckInfo::getId)).last("limit 1")).select(new SFunction[]{ThirdGjCheckInfo::getCheckTime});
        ThirdGjCheckInfo record = (ThirdGjCheckInfo)this.getOne((Wrapper)wrapper);
        return record != null ? record.getCheckTime() : null;
    }

    @Override
    public JqGridData<OrgGjServiceListAdminVo> getGjServiceListForAdmin(OrgGjServiceListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        if (param.getCurrentYear() == null) {
            param.setCurrentYear(Integer.valueOf(Calendar.getInstance().get(1)));
        }
        return new JqGridData((Page)((ThirdGjCheckInfoMapper)this.baseMapper).getGjServiceListForAdmin(param), (JqGridParam)param);
    }

    @Override
    public List<Integer> getGjServiceYearListForAdmin(GjServiceYearListParam param) {
        return ((ThirdGjCheckInfoMapper)this.baseMapper).getGjServiceYearListForAdmin(param);
    }

    @Override
    public List<OneUnitServiceRecordListAdminVo> getServiceRecordList(OneUnitServiceRecordListParam param) {
        return ((ThirdGjCheckInfoMapper)this.baseMapper).getServiceRecordList(param);
    }

    @Override
    public List<Long> getCheckInfoYears(Long cid) {
        return ((ThirdGjCheckInfoMapper)this.baseMapper).getCheckInfoYears(cid);
    }

    @Override
    public void identifyByAdmin(UnitServiceIdentificationParam param) {
        if (param.getCheckInfoId() == null) {
            throw new ServiceException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ThirdGjCheckInfo infoDB = (ThirdGjCheckInfo)this.getById(param.getCheckInfoId());
        if (infoDB == null) {
            throw new ServiceException("\u4e0d\u5b58\u5728\u8be5\u6570\u636e");
        }
        ThirdGjCheckInfo info = new ThirdGjCheckInfo();
        info.setId(param.getCheckInfoId());
        info.setCheckStatus(CheckStatusEnums.DONE.getCode());
        info.setWarningStatus(GjCheckInfoWarningStatusEnum.NO_WARNING.getValue());
        info.setSupplyStatus(GjCheckInfoSupplyStatusEnum.NO_NEED_SUPPLY.getValue());
        info.setSupplyAuditState(GjCheckInfoSupplyAuditStateEnum.NONE.getValue());
        info.setDoneType(Integer.valueOf(2));
        info.setCheckTime(new Date());
        this.updateById(info);
        ThirdGjOrgAuditLog auditLog = new ThirdGjOrgAuditLog();
        auditLog.setOptValue(ThirdGjOrgAuditOptEnum.check_info_opt_1.getOptValue()).setBusinessId(param.getCheckInfoId()).setType(ThirdGjOrgAuditLogTypeEnum.check_info_opt.getValue()).setOpt(ThirdGjOrgAuditOptEnum.check_info_opt_1.getOptName()).setOptDesc("\u76d1\u7ba1\u8ba4\u5b9a").setOptPeople(param.getOperatorName()).setCreateBy(param.getOperator()).setUpdateBy(param.getOperator());
        this.thirdGjOrgAuditLogService.save(auditLog);
    }

    @Override
    public JqGridData<ThirdGjOrgAuditLog> getIdentificationRecord(UnitServiceIdentificationParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<ThirdGjOrgAuditLog> list = null;
        list = this.thirdGjOrgAuditLogService.getGjOrgAuditLogList(param.getCheckInfoId(), ThirdGjOrgAuditLogTypeEnum.check_info_opt.getValue());
        return new JqGridData((Page)list, (JqGridParam)param);
    }

    @Override
    public JqGridData<GjOrgWarningCheckVo> listGjOrgWarningCheckForOrg(GjOrgWarningCheckParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        return new JqGridData((Page)((ThirdGjCheckInfoMapper)this.baseMapper).listGjOrgWarningCheckForOrg(param), (JqGridParam)param);
    }

    @Override
    public JqGridData<GjOrgWarningCheckVo> listWarningCheckForSup(GjOrgWarningCheckParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        return new JqGridData((Page)((ThirdGjCheckInfoMapper)this.baseMapper).listWarningCheckForSup(param), (JqGridParam)param);
    }

    @Override
    public JqGridData<GjOrgWarningCheckVo> listSupplyCompletedForSup(GjOrgWarningCheckParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        return new JqGridData((Page)((ThirdGjCheckInfoMapper)this.baseMapper).listSupplyCompletedForSup(param), (JqGridParam)param);
    }

    @Override
    public JqGridData<GjOrgWarningCheckVo> listUnauditedSupplyForSup(GjOrgWarningCheckParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        return new JqGridData((Page)((ThirdGjCheckInfoMapper)this.baseMapper).listUnauditedSupplyForSup(param), (JqGridParam)param);
    }

    @Override
    public ThirdGjCheckInfo changeSupplyState(GjOrgWarningCheckParam param) {
        ThirdGjCheckInfo checkInfo = (ThirdGjCheckInfo)this.getById(param.getCheckInfoId());
        if (param.getSupplyAuditState() == GjCheckInfoSupplyAuditStateEnum.UNAUDITED.getValue()) {
            if (checkInfo.getSupplyAuditState() == GjCheckInfoSupplyAuditStateEnum.UNAUDITED.getValue()) {
                throw new ServiceException("\u5f53\u524d\u8865\u5f55\u5df2\u5904\u4e8e\u5f85\u5ba1\u6838\uff01");
            }
            if (checkInfo.getSupplyStatus() == GjCheckInfoSupplyStatusEnum.CANT_SUPPLY.getValue() && checkInfo.getWarningStatus() == GjCheckInfoWarningStatusEnum.EXPIRED_MORE.getValue()) {
                checkInfo.setSupplyStatus(GjCheckInfoSupplyStatusEnum.CANT_SUPPLY.getValue());
                checkInfo.setSupplyAuditState(GjCheckInfoSupplyAuditStateEnum.UNAUDITED.getValue());
                this.updateById(checkInfo);
            }
        }
        if (param.getSupplyAuditState() == GjCheckInfoSupplyAuditStateEnum.PASSED.getValue() || param.getSupplyAuditState() == GjCheckInfoSupplyAuditStateEnum.RETURNED.getValue()) {
            checkInfo.setSupplyAuditState(param.getSupplyAuditState());
            if (param.getSupplyAuditState() == GjCheckInfoSupplyAuditStateEnum.PASSED.getValue()) {
                checkInfo.setSupplyStatus(GjCheckInfoSupplyStatusEnum.COULD_SUPPLY.getValue());
            } else {
                checkInfo.setSupplyStatus(GjCheckInfoSupplyStatusEnum.CANT_SUPPLY.getValue());
            }
            this.updateById(checkInfo);
        }
        return checkInfo;
    }

    @Override
    public JqGridData<GjCheckListVo> getGjCheckListData(GjCheckQueryParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        return new JqGridData((Page)((ThirdGjCheckInfoMapper)this.baseMapper).getGjCheckListData(param), (JqGridParam)param);
    }

    @Override
    public GjUserStatisticsVo getCheckStatistics(Long gjUserId, Long orgId) {
        List<GjUserStatisticsVo> reformList;
        GjUserStatisticsVo result = new GjUserStatisticsVo();
        ArrayList<Long> gjUserIdList = new ArrayList<Long>(1);
        gjUserIdList.add(gjUserId);
        List<GjUserStatisticsVo> list = ((ThirdGjCheckInfoMapper)this.baseMapper).getCheckStatistics(gjUserIdList, orgId);
        if (!CollectionUtils.isEmpty(list)) {
            result.setGjCheckInfoNum(list.get(0).getGjCheckInfoNum());
            result.setCurrGjCheckInfoNum(list.get(0).getCurrGjCheckInfoNum());
        }
        if (!CollectionUtils.isEmpty(reformList = this.reformItemBasicMapper.getReformStatisticsByFinder(gjUserIdList, orgId))) {
            result.setUnRiskNum(reformList.get(0).getUnRiskNum());
            result.setCurrRiskNum(reformList.get(0).getCurrRiskNum());
        }
        return result;
    }

    @Override
    public List<GjUserStatisticsVo> getCheckStatistics(List<Long> gjUserIdList, Long orgId) {
        return ((ThirdGjCheckInfoMapper)this.baseMapper).getCheckStatistics(gjUserIdList, orgId);
    }

    @Override
    public List<CheckNumVo> listCheckNum(Long cid, Long customerId) {
        return ((ThirdGjCheckInfoMapper)this.baseMapper).selectBatchCheckNum(cid, customerId);
    }

    @Override
    public Integer getCheckNumByCCC(Long customerId, Integer contractYear, Integer cycle) {
        List list;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ThirdGjCheckInfo::getCustomerId, (Object)customerId);
        if (contractYear != null) {
            queryWrapper.eq(ThirdGjCheckInfo::getCreateContractYear, (Object)contractYear);
            if (cycle != null) {
                queryWrapper.eq(ThirdGjCheckInfo::getCreateCycle, (Object)cycle);
            }
        }
        if (null == (list = this.list((Wrapper)queryWrapper))) {
            return 0;
        }
        return list.size();
    }

    @Override
    public List<CheckRecordVo> listCheckRecord(CheckRecordParam param) {
        if (param.getCustomerId() == null) {
            throw new ServiceException("\u7b7e\u7ea6id,\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return ((ThirdGjCheckInfoMapper)this.baseMapper).selectBatchCheckRecord(param);
    }

    @Override
    public List<CheckRecordVo> listCheckRecordForOrj(CheckRecordParam param) {
        return ((ThirdGjCheckInfoMapper)this.baseMapper).selectBatchCheckRecord(param);
    }

    @Override
    public JqGridData<CheckRecordVo> listCheckRecordForCompany(CheckRecordParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        return new JqGridData((Page)((ThirdGjCheckInfoMapper)this.baseMapper).selectBatchCheckRecord(param), (JqGridParam)param);
    }

    @Override
    public Integer getCheckTotalNum(Long cid, Long customerId) {
        return ((ThirdGjCheckInfoMapper)this.baseMapper).countCheckNumByCid(cid, customerId);
    }

    @Override
    public Integer getCustomerWarningStatusByCustomerId(Long customerId) {
        boolean hasWarning = false;
        boolean hasOverdue = false;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(ThirdGjCheckInfo::getIsAutoCreate, (Object)1)).eq(ThirdGjCheckInfo::getCustomerId, (Object)customerId);
        List checkInfoList = this.list((Wrapper)queryWrapper);
        for (ThirdGjCheckInfo checkInfo : checkInfoList) {
            if (hasWarning && hasOverdue) break;
            if (Objects.equals(checkInfo.getWarningStatus(), GjCheckInfoWarningStatusEnum.WARNING.getValue())) {
                hasWarning = true;
            }
            if (!Objects.equals(checkInfo.getWarningStatus(), GjCheckInfoWarningStatusEnum.EXPIRED_LESS.getValue()) && !Objects.equals(checkInfo.getWarningStatus(), GjCheckInfoWarningStatusEnum.EXPIRED_MORE.getValue())) continue;
            hasOverdue = true;
        }
        if (hasWarning && hasOverdue) {
            return GjCustomerWarningStatusEnum.OVERDUE_WARNING.getValue();
        }
        if (hasWarning) {
            return GjCustomerWarningStatusEnum.WARNING.getValue();
        }
        if (hasOverdue) {
            return GjCustomerWarningStatusEnum.OVERDUE.getValue();
        }
        return GjCustomerWarningStatusEnum.NO_WARNING.getValue();
    }

    @Override
    public Integer getCheckNumByCustomer(Long customerId, Integer contractYear, Integer cycle) {
        return ((ThirdGjCheckInfoMapper)this.baseMapper).countCheckNumByCustomer(customerId, contractYear, cycle);
    }

    @Override
    public ThirdGjCheckInfo getAutoCreateCheckByCustomer(Long customerId, Integer contractYear, Integer cycle) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(ThirdGjCheckInfo::getIsAutoCreate, (Object)1)).eq(ThirdGjCheckInfo::getCustomerId, (Object)customerId)).eq(ThirdGjCheckInfo::getCreateContractYear, (Object)contractYear)).eq(ThirdGjCheckInfo::getCreateCycle, (Object)cycle)).orderByDesc(ThirdGjCheckInfo::getCreateDate)).last("limit 1");
        return (ThirdGjCheckInfo)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @Transactional
    public void searchAndUpdateCheckInfoAboutState(Long infoId) {
        LocalDate nowDate = LocalDate.now();
        List<ThirdGjCheckInfo> checkInfoList = ((ThirdGjCheckInfoMapper)this.baseMapper).searchNeedChangeCheckInfoStatus();
        checkInfoList.stream().forEach(checkInfo -> {
            LocalDate signDate = checkInfo.getCreateSignTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            Period between = Period.between(signDate, nowDate);
            int years = between.getYears();
            int months = between.getMonths();
            int days = between.getDays();
            if (checkInfo.getSupplyAuditState() == GjCheckInfoSupplyAuditStateEnum.NONE.getValue()) {
                if (years + 1 == checkInfo.getCreateContractYear()) {
                    if (Objects.equals(checkInfo.getCreateCycle(), GjCustomerCycleEnum.SECOND.getValue())) {
                        months -= 6;
                    }
                    if (months == 5 && days > 0) {
                        checkInfo.setWarningStatus(GjCheckInfoWarningStatusEnum.WARNING.getValue());
                        checkInfo.setSupplyStatus(GjCheckInfoSupplyStatusEnum.NO_NEED_SUPPLY.getValue());
                    } else if (months == 6 && days > 0) {
                        checkInfo.setWarningStatus(GjCheckInfoWarningStatusEnum.EXPIRED_LESS.getValue());
                        checkInfo.setSupplyStatus(GjCheckInfoSupplyStatusEnum.COULD_SUPPLY.getValue());
                        checkInfo.setCheckStatus(CheckStatusEnums.INCOMPLETE.getCode());
                    } else if (months >= 7 && days > 0) {
                        checkInfo.setWarningStatus(GjCheckInfoWarningStatusEnum.EXPIRED_MORE.getValue());
                        checkInfo.setSupplyStatus(GjCheckInfoSupplyStatusEnum.CANT_SUPPLY.getValue());
                        checkInfo.setCheckStatus(CheckStatusEnums.INCOMPLETE.getCode());
                    }
                }
                if (years + 1 > checkInfo.getCreateContractYear() && Objects.equals(checkInfo.getCreateCycle(), GjCustomerCycleEnum.SECOND.getValue())) {
                    if ((months = months + years * 12 - 6) == 6 && days > 0) {
                        checkInfo.setWarningStatus(GjCheckInfoWarningStatusEnum.EXPIRED_LESS.getValue());
                        checkInfo.setSupplyStatus(GjCheckInfoSupplyStatusEnum.COULD_SUPPLY.getValue());
                        checkInfo.setCheckStatus(CheckStatusEnums.INCOMPLETE.getCode());
                    } else if (months >= 7 && days > 0) {
                        checkInfo.setWarningStatus(GjCheckInfoWarningStatusEnum.EXPIRED_MORE.getValue());
                        checkInfo.setSupplyStatus(GjCheckInfoSupplyStatusEnum.CANT_SUPPLY.getValue());
                        checkInfo.setCheckStatus(CheckStatusEnums.INCOMPLETE.getCode());
                    }
                }
            }
        });
        this.updateBatchById(checkInfoList);
    }

    @Override
    @Transactional
    public ThirdGjCheckInfo getOrAddLastCheckWithAreaAndYear(Long cid) {
        int year = Calendar.getInstance().get(1);
        CompanyInfoVo companyInfo = ((ThirdGjCheckInfoMapper)this.baseMapper).selectCompanyInfo(cid);
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"cid", (Object)cid)).eq((Object)"year", (Object)year)).eq((Object)"area_id", (Object)companyInfo.getAreaId())).orderByDesc((Object)"create_date")).last("limit 1");
        ThirdGjCheckInfo info = (ThirdGjCheckInfo)this.getOne((Wrapper)wrapper);
        if (info == null) {
            if (companyInfo.getPickupCount() != null && companyInfo.getPickupCount() < 3) {
                return null;
            }
            Integer checkTotalNum = this.getCheckTotalNum(cid, info.getCustomerId());
            info = new ThirdGjCheckInfo();
            info.setCheckName("\u7b2c" + (checkTotalNum + 1) + "\u6b21-" + companyInfo.getName() + "\u68c0\u67e5");
            info.setCheckStatus(CheckStatusEnums.NOT_STARTED.getCode());
            info.setCid(cid);
            info.setCheckPeople(ShiroUtil.getLoginUserNickname());
            info.setGjUserId(ShiroUtil.getLoginUserId());
            info.setAreaId(companyInfo.getAreaId());
            AreaModel areaInfo = this.areaProvideService.getAreaById(companyInfo.getAreaId());
            info.setAreaId1(areaInfo.getProvinceId());
            info.setAreaId2(areaInfo.getCityId());
            info.setAreaId3(areaInfo.getAreaId());
            info.setAreaId4(areaInfo.getStreetId());
            this.save(info);
            ThirdGjCheckItem item = new ThirdGjCheckItem();
            item.setCheckId(info.getId());
            this.checkItemService.save(item);
        }
        return info;
    }

    @Override
    public ThirdGjCheckInfo getLastCheckForApp(Long cid, ThirdGjOrgCustomer customer) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(ThirdGjCheckInfo::getCid, (Object)cid)).eq(ThirdGjCheckInfo::getCustomerId, (Object)customer.getId())).eq(ThirdGjCheckInfo::getIsAutoCreate, (Object)1)).eq(ThirdGjCheckInfo::getCreateContractYear, (Object)customer.getCurContractYear())).eq(ThirdGjCheckInfo::getCreateCycle, (Object)customer.getCurCycle())).orderByDesc(ThirdGjCheckInfo::getCreateDate)).last("limit 1");
        ThirdGjCheckInfo autoCreateCheck = (ThirdGjCheckInfo)this.getOne((Wrapper)queryWrapper);
        if (CheckStatusEnums.NOT_STARTED.getCode().equals(autoCreateCheck.getCheckStatus()) || CheckStatusEnums.CHECKING.getCode().equals(autoCreateCheck.getCheckStatus())) {
            return autoCreateCheck;
        }
        queryWrapper.clear();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(ThirdGjCheckInfo::getCid, (Object)cid)).eq(ThirdGjCheckInfo::getCustomerId, (Object)customer.getId())).eq(ThirdGjCheckInfo::getCreateContractYear, (Object)customer.getCurContractYear())).eq(ThirdGjCheckInfo::getCreateCycle, (Object)customer.getCurCycle())).orderByDesc(ThirdGjCheckInfo::getCreateDate)).last("limit 1");
        return (ThirdGjCheckInfo)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public Long getCheckInfoBySourceId(String source, String sourceId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(ThirdGjCheckInfo.class);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ThirdGjCheckInfo::getSourceId, (Object)sourceId)).eq(ThirdGjCheckInfo::getSource, (Object)source)).eq(ThirdGjCheckInfo::getIsValid, (Object)true)).select(new SFunction[]{ThirdGjCheckInfo::getId}).last("limit 1");
        ThirdGjCheckInfo record = (ThirdGjCheckInfo)this.getOne((Wrapper)wrapper);
        return record == null ? null : record.getId();
    }

    @Override
    @Transactional
    public void createCheckForTask(Long id) {
        List<ThirdGjOrgCustomer> customerList = ((ThirdGjCheckInfoMapper)this.baseMapper).listCustomerForGenCheckInfoTask(id, new Date());
        if (!CollectionUtils.isEmpty(customerList)) {
            ArrayList addList = new ArrayList();
            customerList.stream().forEach(customer -> {
                ThirdGjCheckInfo checkInfo = new ThirdGjCheckInfo();
                LocalDate signDate = customer.getSignTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                checkInfo.setCheckName(String.format("%s\u5408\u540c-\u670d\u52a1\u5468\u671f%s-%s\u670d\u52a1-\u7cfb\u7edf\u81ea\u52a8\u521b\u5efa", signDate, customer.getCurContractYear(), GjCustomerCycleEnum.getName((Integer)customer.getCurCycle())));
                checkInfo.setOrgId(customer.getOrgId());
                checkInfo.setCid(customer.getCid());
                checkInfo.setUnitName(customer.getUnitName());
                checkInfo.setCustomerId(customer.getId());
                checkInfo.setIsAutoCreate(Integer.valueOf(1));
                checkInfo.setCreateContractYear(customer.getCurContractYear());
                checkInfo.setCreateCycle(customer.getCurCycle());
                checkInfo.setCreateSignTime(customer.getSignTime());
                checkInfo.setCheckStatus(CheckStatusEnums.CHECKING.getCode());
                checkInfo.setSupplyStatus(GjCheckInfoSupplyStatusEnum.NO_NEED_SUPPLY.getValue());
                checkInfo.setWarningStatus(GjCheckInfoWarningStatusEnum.NO_WARNING.getValue());
                addList.add(checkInfo);
            });
            this.saveBatch(addList);
        }
    }

    public ThirdGjCheckInfoServiceImpl(IThirdGjCheckItemService checkItemService, ReformItemBasicMapper reformItemBasicMapper) {
        this.checkItemService = checkItemService;
        this.reformItemBasicMapper = reformItemBasicMapper;
    }
}

