/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.service.sys.impl;

import cn.smarthse.fwgj.dao.sys.ThirdGjUserLogMapper;
import cn.smarthse.fwgj.entity.sys.ThirdGjUserLog;
import cn.smarthse.fwgj.enums.ThirdGjOrgAuditResultEnum;
import cn.smarthse.fwgj.enums.ThirdGjUserLogForbiddenStateEnum;
import cn.smarthse.fwgj.enums.ThirdGjUserLogStateEnums;
import cn.smarthse.fwgj.model.param.admin.GjOrgListAdminParam;
import cn.smarthse.fwgj.model.vo.admin.GjOrgListAdminVo;
import cn.smarthse.fwgj.model.vo.third.GjUserForbiddenStateStatistics;
import cn.smarthse.fwgj.model.vo.third.GjUserStateStatistics;
import cn.smarthse.fwgj.service.sys.IThirdGjUserLogService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ThirdGjUserLogServiceImpl
extends ServiceImpl<ThirdGjUserLogMapper, ThirdGjUserLog>
implements IThirdGjUserLogService {
    @Override
    public void updateStateBatchByIds(List<Long> ids, Integer state, String reason) {
        if (CollectionUtils.isEmpty(ids) || state == null) {
            return;
        }
        LambdaUpdateWrapper lambdaUpdateWrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)lambdaUpdateWrapper.eq(ThirdGjUserLog::getIsValid, (Object)true)).in(ThirdGjUserLog::getId, ids)).set(ThirdGjUserLog::getState, (Object)state);
        if (state.equals(ThirdGjOrgAuditResultEnum.PASS.getValue())) {
            lambdaUpdateWrapper.set(ThirdGjUserLog::getForbiddenState, (Object)ThirdGjUserLogForbiddenStateEnum.PASS.getValue());
        } else {
            lambdaUpdateWrapper.set(ThirdGjUserLog::getReason, (Object)("\u5907\u6848\u5ba1\u6838\u88ab\u9000\u56de\uff1a" + reason));
        }
        this.update((Wrapper)lambdaUpdateWrapper);
    }

    @Override
    public List<GjOrgListAdminVo> getGjOrgList(Long gjUserId) {
        return ((ThirdGjUserLogMapper)this.baseMapper).getGjOrgList(gjUserId);
    }

    @Override
    public String getOrgNames(Long gjUserId) {
        List<GjOrgListAdminVo> gjOrgList = this.getGjOrgList(gjUserId);
        if (CollectionUtils.isEmpty(gjOrgList)) {
            return null;
        }
        return gjOrgList.stream().map(GjOrgListAdminVo::getOrgName).collect(Collectors.joining("\uff0c"));
    }

    @Override
    public List<GjOrgListAdminVo> getGjOrgSelectListForAdmin(GjOrgListAdminParam param) {
        return ((ThirdGjUserLogMapper)this.baseMapper).getGjOrgSelectListForAdmin(param);
    }

    @Override
    public List<GjOrgListAdminVo> getOrgOptListForAdmin(GjOrgListAdminParam param) {
        return ((ThirdGjUserLogMapper)this.baseMapper).getOrgOptListForAdmin(param);
    }

    @Override
    public ThirdGjUserLog getGjUserLog(Long gjUserId, Long orgId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ThirdGjUserLog::getIsValid, (Object)true)).eq(ThirdGjUserLog::getGjUserId, (Object)gjUserId)).eq(ThirdGjUserLog::getOrgId, (Object)orgId)).last("limit 1");
        return (ThirdGjUserLog)((ThirdGjUserLogMapper)this.baseMapper).selectOne((Wrapper)wrapper);
    }

    @Override
    public boolean checkGjUserLog(Long gjUserLogId, Long orgId) {
        if (gjUserLogId == null) {
            return false;
        }
        ThirdGjUserLog record = (ThirdGjUserLog)this.getById(gjUserLogId);
        return record != null && record.getOrgId() != null && record.getOrgId().equals(orgId);
    }

    @Override
    public boolean checkGjUserLog(List<Long> gjUserLogIdList, Long orgId) {
        if (CollectionUtils.isEmpty(gjUserLogIdList)) {
            return false;
        }
        List list = this.listByIds(gjUserLogIdList);
        return !list.stream().anyMatch(record -> record == null || record.getOrgId() == null || !record.getOrgId().equals(orgId));
    }

    @Override
    public boolean checkGjUser(Long gjUserId, Long orgId) {
        if (gjUserId == null) {
            return false;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(ThirdGjUserLog.class);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ThirdGjUserLog::getGjUserId, (Object)gjUserId)).eq(ThirdGjUserLog::getIsValid, (Object)1)).select(new SFunction[]{ThirdGjUserLog::getOrgId});
        List list = this.list((Wrapper)wrapper);
        return !CollectionUtils.isEmpty((Collection)list) && list.stream().anyMatch(record -> record.getOrgId() != null && record.getOrgId().equals(orgId));
    }

    @Override
    public List<ThirdGjUserLog> getByGjUserIdAndOrgIds(Long gjUserId, List<Long> orgIdList) {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lambda().eq(ThirdGjUserLog::getGjUserId, (Object)gjUserId)).eq(ThirdGjUserLog::getIsValid, (Object)1)).in(ThirdGjUserLog::getOrgId, orgIdList);
        return ((ThirdGjUserLogMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public List<ThirdGjUserLog> getThirdGjUserLogList(Long orgId) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(ThirdGjUserLog::getIsValid, (Object)true)).eq(ThirdGjUserLog::getOrgId, (Object)orgId)).eq(ThirdGjUserLog::getState, (Object)ThirdGjUserLogStateEnums.PASS.getValue())).eq(ThirdGjUserLog::getForbiddenState, (Object)ThirdGjUserLogForbiddenStateEnum.PASS.getValue());
        return ((ThirdGjUserLogMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public int getGjUserNumByOrgId(Long orgId) {
        List<ThirdGjUserLog> thirdGjUserLogList = this.getThirdGjUserLogList(orgId);
        return CollectionUtils.isEmpty(thirdGjUserLogList) ? 0 : thirdGjUserLogList.size();
    }

    @Override
    public GjUserStateStatistics getGjUserStateStatistics(Long orgId) {
        List<GjUserStateStatistics> list = ((ThirdGjUserLogMapper)this.baseMapper).getGjUserStateStatisticsList(orgId);
        GjUserStateStatistics result = new GjUserStateStatistics();
        if (CollectionUtils.isEmpty(list)) {
            return result;
        }
        list.forEach(record -> {
            if (ThirdGjUserLogStateEnums.PENDING_AUDIT.getValue().equals(record.getState())) {
                result.setNum1(record.getNum().intValue());
            } else if (ThirdGjUserLogStateEnums.PASS.getValue().equals(record.getState())) {
                result.setNum2(record.getNum().intValue());
            } else if (ThirdGjUserLogStateEnums.REFUED.getValue().equals(record.getState())) {
                result.setNum3(record.getNum().intValue());
            } else if (ThirdGjUserLogStateEnums.STOP.getValue().equals(record.getState())) {
                result.setNum4(record.getNum().intValue());
            }
        });
        return result;
    }

    @Override
    public GjUserForbiddenStateStatistics getGjUserForbiddenStateStatistics(Long orgId) {
        List<GjUserForbiddenStateStatistics> list = ((ThirdGjUserLogMapper)this.baseMapper).getGjUserForbiddenStateStatisticsList(orgId);
        GjUserForbiddenStateStatistics result = new GjUserForbiddenStateStatistics();
        if (CollectionUtils.isEmpty(list)) {
            return result;
        }
        list.forEach(record -> {
            if (ThirdGjUserLogForbiddenStateEnum.Forbidden.getValue().equals(record.getForbiddenState())) {
                result.setNum0(record.getNum().intValue());
            } else if (ThirdGjUserLogForbiddenStateEnum.PENDING_AUDIT.getValue().equals(record.getForbiddenState())) {
                result.setNum1(record.getNum().intValue());
            } else if (ThirdGjUserLogForbiddenStateEnum.PASS.getValue().equals(record.getForbiddenState())) {
                result.setNum2(record.getNum().intValue());
            } else if (ThirdGjUserLogForbiddenStateEnum.REFUED.getValue().equals(record.getForbiddenState())) {
                result.setNum3(record.getNum().intValue());
            }
        });
        return result;
    }

    @Override
    public void updateState1(Long orgId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate(ThirdGjUserLog.class);
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(ThirdGjUserLog::getOrgId, (Object)orgId)).eq(ThirdGjUserLog::getState, (Object)ThirdGjUserLogStateEnums.REFUED.getValue())).set(ThirdGjUserLog::getState, (Object)ThirdGjUserLogStateEnums.PENDING_AUDIT.getValue());
        this.update((Wrapper)wrapper);
    }
}

