/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.service.sys.impl;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.util.Digests;
import cn.smarthse.common.util.Encodes;
import cn.smarthse.fwgj.dao.sys.SysUserMapper;
import cn.smarthse.fwgj.entity.sys.SysUser;
import cn.smarthse.fwgj.service.sys.ISysUserService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Date;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysUserServiceImpl
extends ServiceImpl<SysUserMapper, SysUser>
implements ISysUserService {
    @Override
    public Boolean haveThisUserName(String username) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)queryWrapper.eq(SysUser::getIsValid, (Object)Global.TRUE)).eq(SysUser::getUsername, (Object)username);
        List list = ((SysUserMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        return list != null && list.size() > 0;
    }

    @Override
    public Boolean checkEmail(String email, Long userId) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)queryWrapper.eq(SysUser::getIsValid, (Object)Global.TRUE)).eq(SysUser::getEmail, (Object)email);
        SysUser record = (SysUser)((SysUserMapper)this.baseMapper).selectOne((Wrapper)queryWrapper);
        return record == null || record.getId().equals(userId);
    }

    @Override
    @Transactional
    public SysUser register(SysUser sysUser) {
        sysUser.setUsername(sysUser.getUsername());
        sysUser.setCid(sysUser.getCid());
        this.setInitPassword(sysUser);
        sysUser.setEmail(sysUser.getEmail());
        sysUser.setCreateDate(new Date());
        sysUser.setUpdateDate(new Date());
        sysUser.setFaceId(Long.valueOf(0L));
        sysUser.setFullname(sysUser.getUsername());
        sysUser.setIsForbidden(Boolean.valueOf(false));
        sysUser.setCancelForbiddenTime(new Date());
        sysUser.setIsManger(Boolean.valueOf(true));
        sysUser.setIsValid(Boolean.valueOf(true));
        sysUser.setResource(Integer.valueOf(4));
        this.saveOrUpdate(sysUser);
        return sysUser;
    }

    private void setInitPassword(SysUser user) {
        String plainPassword = DigestUtils.md5Hex((String)"Zyj@123456");
        String plain = Encodes.unescapeHtml((String)plainPassword);
        byte[] salt = Digests.generateSalt((int)8);
        user.setSalt(Encodes.hexEncode((byte[])salt));
        byte[] hashPassword = Digests.sha1((byte[])plain.getBytes(), (byte[])salt, (int)1024);
        user.setPassword(Encodes.hexEncode((byte[])hashPassword));
        user.setPwdUpdateTime(new Date());
        user.setIsDefaultPwd(Boolean.valueOf(true));
    }

    @Override
    public SysUser getOrgAdminUser(Long cid, String orgName) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(SysUser::getIsValid, (Object)true)).eq(SysUser::getUsername, (Object)orgName)).eq(SysUser::getCid, (Object)cid)).eq(SysUser::getIsManger, (Object)1)).last("limit 1");
        return (SysUser)((SysUserMapper)this.baseMapper).selectOne((Wrapper)queryWrapper);
    }
}

