/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.provider.third;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.fwgj.converter.check.CheckInfoConverter;
import cn.smarthse.fwgj.converter.check.CheckItemConverter;
import cn.smarthse.fwgj.converter.check.ReformConverter;
import cn.smarthse.fwgj.dao.ReformItemBasicMapper;
import cn.smarthse.fwgj.entity.sys.ThirdOrganization;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjCheckInfo;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjCheckItem;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgAuditLog;
import cn.smarthse.fwgj.enums.GjCheckInfoSupplyAuditStateEnum;
import cn.smarthse.fwgj.enums.ThirdGjOrgAuditLogTypeEnum;
import cn.smarthse.fwgj.model.param.CheckRecordParam;
import cn.smarthse.fwgj.model.param.third.GjCheckQueryParam;
import cn.smarthse.fwgj.model.param.third.GjOrgWarningCheckParam;
import cn.smarthse.fwgj.model.vo.check.CheckVo;
import cn.smarthse.fwgj.model.vo.third.CheckRecordVo;
import cn.smarthse.fwgj.model.vo.third.GjCheckListVo;
import cn.smarthse.fwgj.model.vo.third.GjOrgWarningCheckVo;
import cn.smarthse.fwgj.provider.third.IThirdGjCheckProviderService;
import cn.smarthse.fwgj.service.sys.IThirdOrganizationService;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjCheckInfoService;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjCheckItemService;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjOrgAuditLogService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.vo.work.reform.RiskReformGjListVo;
import cn.smarthse.modules.health.vo.work.reform.RiskReformGjSearch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@DubboService
public class ThirdGjCheckProviderToThird
implements IThirdGjCheckProviderService {
    private static final Logger log = LoggerFactory.getLogger(ThirdGjCheckProviderToThird.class);
    private final IThirdGjCheckInfoService infoService;
    private final IThirdGjCheckItemService itemService;
    private final CheckInfoConverter infoConverter;
    private final CheckItemConverter itemConverter;
    private final ReformConverter reformConverter;
    private final IReformItemBasicService reformItemBasicService;
    private final ReformItemBasicMapper reformItemBasicMapper;
    private final IThirdGjOrgAuditLogService auditLogService;
    private final IThirdOrganizationService thirdOrganizationService;
    @DubboReference
    private ISysFileProvideService fileProvideService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService areaProvideService;

    public JqGridData<GjCheckListVo> getGjCheckListData(GjCheckQueryParam param) {
        return this.infoService.getGjCheckListData(param);
    }

    public List<CheckRecordVo> listCheckInfoForGjOrj(Long cid, Date beginTime, Date endTime) {
        if (cid == null) {
            return null;
        }
        CheckRecordParam param = new CheckRecordParam();
        param.setCid(cid);
        param.setBeginTime(beginTime);
        param.setEndTime(endTime);
        List<CheckRecordVo> rst = this.infoService.listCheckRecordForOrj(param);
        if (CollectionUtils.isNotEmpty(rst)) {
            rst.stream().forEach(check -> check.setReformStasticsVo(this.reformItemBasicMapper.getReformStatistics(check.getId())));
        }
        return rst;
    }

    public CheckVo getCheckSummaryInfoForOrj(Long checkInfoId) {
        CheckVo rst = new CheckVo();
        ThirdGjCheckInfo info = (ThirdGjCheckInfo)this.infoService.getById(checkInfoId);
        rst.setCheckInfoVo(this.infoConverter.EntityToVo(info));
        rst.getCheckInfoVo().setOrgName(((ThirdOrganization)this.thirdOrganizationService.getById(info.getOrgId())).getName());
        rst.getCheckInfoVo().setCheckFileUrl(this.fileProvideService.getListByIds(info.getCheckFile()));
        rst.getCheckInfoVo().setUnitManageSignUrl(this.fileProvideService.getFileUrl(info.getUnitManageSign()));
        ThirdGjCheckItem item = this.itemService.getItemByCheckId(checkInfoId);
        rst.setCheckItemVo(this.itemConverter.EntityToVo(item));
        rst.setReformStasticsVo(this.reformItemBasicMapper.getReformStatistics(checkInfoId));
        ArrayList list = new ArrayList();
        List reformListVos = this.reformConverter.voToListVo(this.reformItemBasicMapper.getReformList(checkInfoId, null));
        List pastReformListVos = this.reformConverter.voToListVo(this.reformItemBasicMapper.getPastReformListByCid(checkInfoId, info.getCid()));
        reformListVos.stream().forEach(reformVo -> reformVo.setIsThisFind(Integer.valueOf(1)));
        list.addAll(reformListVos);
        list.addAll(pastReformListVos);
        rst.setReformListVo(list);
        return rst;
    }

    public JqGridData<RiskReformGjListVo> getGjReformListData(RiskReformGjSearch param) {
        return this.reformItemBasicService.getGjReformListDataForThirdOrg(param);
    }

    public JqGridData<GjOrgWarningCheckVo> getGjOrgWarningCheckListForOrg(GjOrgWarningCheckParam param) {
        if (param.getOrgId() == null) {
            return new JqGridData();
        }
        return this.infoService.listGjOrgWarningCheckForOrg(param);
    }

    public JqGridData<GjOrgWarningCheckVo> listWarningCheckForSup(GjOrgWarningCheckParam param) {
        if (param.getLoginUserId() == null && param.getAreaId() == null) {
            return new JqGridData();
        }
        param.setAreaLevel(Integer.valueOf(this.areaProvideService.getAreaById(param.getAreaId()).getLevel().intValue()));
        return this.infoService.listWarningCheckForSup(param);
    }

    public JqGridData<GjOrgWarningCheckVo> listSupplyCompletedForSup(GjOrgWarningCheckParam param) {
        return this.infoService.listSupplyCompletedForSup(param);
    }

    public JqGridData<ThirdGjOrgAuditLog> listSupplyHistory(GjOrgWarningCheckParam param) {
        return this.auditLogService.listSupplyAuditLog(param, ThirdGjOrgAuditLogTypeEnum.check_info_supply_opt.getValue());
    }

    public JqGridData<GjOrgWarningCheckVo> listUnauditedSupplyForSup(GjOrgWarningCheckParam param) {
        JqGridData<GjOrgWarningCheckVo> rst = this.infoService.listUnauditedSupplyForSup(param);
        if (CollectionUtils.isNotEmpty((Collection)rst.getRows())) {
            for (GjOrgWarningCheckVo checkVo : rst.getRows()) {
                checkVo.setReason(this.auditLogService.getSupplyReasonByCheckInfoId(checkVo.getId()));
            }
        }
        return rst;
    }

    @Transactional
    public void submitSupply(GjOrgWarningCheckParam param) {
        if (param.getCheckInfoId() == null) {
            return;
        }
        param.setSupplyAuditState(GjCheckInfoSupplyAuditStateEnum.UNAUDITED.getValue());
        ThirdGjCheckInfo checkInfo = this.infoService.changeSupplyState(param);
        this.auditLogService.addSupplyAuditLog(checkInfo, param);
    }

    @Transactional
    public void auditSupply(GjOrgWarningCheckParam param) {
        if (param.getCheckInfoId() == null || param.getSupplyAuditState() == null || param.getSupplyAuditState() != GjCheckInfoSupplyAuditStateEnum.PASSED.getValue() && param.getSupplyAuditState() != GjCheckInfoSupplyAuditStateEnum.RETURNED.getValue()) {
            throw new ServiceException("\u53c2\u6570\u5f02\u5e38\uff01");
        }
        ThirdGjCheckInfo checkInfo = this.infoService.changeSupplyState(param);
        this.auditLogService.addSupplyAuditLog(checkInfo, param);
    }

    public ThirdGjCheckProviderToThird(IThirdGjCheckInfoService infoService, IThirdGjCheckItemService itemService, CheckInfoConverter infoConverter, CheckItemConverter itemConverter, ReformConverter reformConverter, IReformItemBasicService reformItemBasicService, ReformItemBasicMapper reformItemBasicMapper, IThirdGjOrgAuditLogService auditLogService, IThirdOrganizationService thirdOrganizationService) {
        this.infoService = infoService;
        this.itemService = itemService;
        this.infoConverter = infoConverter;
        this.itemConverter = itemConverter;
        this.reformConverter = reformConverter;
        this.reformItemBasicService = reformItemBasicService;
        this.reformItemBasicMapper = reformItemBasicMapper;
        this.auditLogService = auditLogService;
        this.thirdOrganizationService = thirdOrganizationService;
    }
}

