/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.provider.company;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.fwgj.converter.GjOrgCustomerConverter;
import cn.smarthse.fwgj.dao.ReformItemBasicMapper;
import cn.smarthse.fwgj.dao.thirdGj.ThirdOrgMapper;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrg;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgAuditLog;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgCustomer;
import cn.smarthse.fwgj.enums.ThirdGjOrgAuditLogTypeEnum;
import cn.smarthse.fwgj.enums.ThirdGjOrgAuditOptEnum;
import cn.smarthse.fwgj.enums.ThirdGjOrgCustomerSourceEnum;
import cn.smarthse.fwgj.enums.ThirdGjOrgCustomerStateEnum;
import cn.smarthse.fwgj.enums.ThirdGjOrgCustomerTypeEnum;
import cn.smarthse.fwgj.model.param.GjOrgCustomerQueryParam;
import cn.smarthse.fwgj.model.param.company.CompanyCustomerSearchParam;
import cn.smarthse.fwgj.model.param.third.GjOrgCompanyQueryParam;
import cn.smarthse.fwgj.model.param.third.GjOrgCustomerAddParam;
import cn.smarthse.fwgj.model.vo.company.CompanyCustomerHistoryListVo;
import cn.smarthse.fwgj.model.vo.company.CompanyCustomerStatisticVo;
import cn.smarthse.fwgj.model.vo.third.GjOrgCheckStatisticVo;
import cn.smarthse.fwgj.model.vo.third.GjOrgCompanyAreaVo;
import cn.smarthse.fwgj.model.vo.third.GjOrgCompanyListVo;
import cn.smarthse.fwgj.model.vo.third.GjOrgCustomerVo;
import cn.smarthse.fwgj.model.vo.third.ReformStasticsVo;
import cn.smarthse.fwgj.model.vo.third.ThirdOrganizationVo;
import cn.smarthse.fwgj.provider.company.IThirdGjOrgCustomerProviderToCompany;
import cn.smarthse.fwgj.service.sys.IThirdGjUserLogService;
import cn.smarthse.fwgj.service.sys.IThirdGjUserService;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjOrgAuditLogService;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjOrgCustomerService;
import cn.smarthse.fwgj.service.thirdGj.IThirdGjOrgService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import java.util.List;
import java.util.Objects;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@DubboService
public class ThirdGjOrgCustomerProviderToCompany
implements IThirdGjOrgCustomerProviderToCompany {
    private static final Logger log = LoggerFactory.getLogger(ThirdGjOrgCustomerProviderToCompany.class);
    private final IThirdGjOrgService thirdGjOrgService;
    private final IThirdGjUserService thirdGjUserService;
    private final IThirdGjUserLogService thirdGjUserLogService;
    private final IThirdGjOrgAuditLogService thirdGjOrgAuditLogService;
    private final IThirdGjOrgCustomerService gjOrgCustomerService;
    private final ThirdOrgMapper thirdOrgMapper;
    private final ReformItemBasicMapper reformItemBasicMapper;
    private final GjOrgCustomerConverter gjOrgCustomerConverter;
    @DubboReference
    private ISysFileProvideService sysFileProvideService;

    public Long getCurCustomerIdByCid(Long cid) {
        return this.gjOrgCustomerService.getCurCustomerIdByCid(cid);
    }

    public GjOrgCheckStatisticVo getGjOrjCheckStatistic(Long orgId) {
        if (orgId == null) {
            return null;
        }
        GjOrgCheckStatisticVo rst = this.gjOrgCustomerService.getGjOrjCheckStatistic(orgId);
        rst.setScoreList(this.thirdGjOrgService.getScoreListByOrgId(orgId));
        rst.setGjUserNum(Integer.valueOf(this.thirdGjUserLogService.getGjUserNumByOrgId(orgId)));
        rst.setSignedCompanyNum(Integer.valueOf(this.gjOrgCustomerService.getSignedCompanyNumByOrgId(orgId)));
        rst.setOverDueNum(Integer.valueOf(this.gjOrgCustomerService.getOverDueCompanyNumByOrgId(orgId, 2)));
        rst.setNeedCheckNum(Integer.valueOf(this.gjOrgCustomerService.getNeedCheckCompanyNumByOrgId(orgId)));
        rst.setNearDueNum(Integer.valueOf(this.gjOrgCustomerService.getNearDueCompanyNumByOrgId(orgId)));
        return rst;
    }

    public List<GjOrgCompanyAreaVo> getGjOrjCompanyAreaList(Long orgId) {
        if (orgId == null) {
            return null;
        }
        return this.gjOrgCustomerService.getGjOrjCompanyAreaList(orgId);
    }

    public JqGridData<GjOrgCompanyListVo> getGjOrgCompanyList(GjOrgCompanyQueryParam param) {
        if (param.getOrgId() == null) {
            return new JqGridData();
        }
        return this.gjOrgCustomerService.getGjOrgCompanyList(param);
    }

    public CompanyCustomerStatisticVo getCompanyCustomerStatistic(Long customerId, Long cid) {
        ThirdGjOrg thirdGjOrg;
        if (customerId == null) {
            ReformStasticsVo reformStatisticsByCid = this.reformItemBasicMapper.getReformStatisticsByCid(cid);
            CompanyCustomerStatisticVo rst = new CompanyCustomerStatisticVo();
            rst.setUnAcceptRiskNum(reformStatisticsByCid.getUnacceptRiskNum());
            rst.setUnReformRiskNum(reformStatisticsByCid.getUnReformRiskNum());
            return rst;
        }
        CompanyCustomerStatisticVo rst = this.gjOrgCustomerService.getCustomerStatisticForCompany(customerId);
        ThirdOrganizationVo organization = this.thirdOrgMapper.getThirdOrganization(rst.getOrgId());
        if (organization != null) {
            rst.setOrgName(organization.getName());
            rst.setOrgCreditCode(organization.getCreditCode());
            rst.setOrgAddress(organization.getProvinceName() + organization.getCityName() + organization.getAreaName() + organization.getAddress());
        }
        if ((thirdGjOrg = (ThirdGjOrg)this.thirdGjOrgService.getById(rst.getGjOrgId())) != null) {
            rst.setScore(thirdGjOrg.getScore());
        }
        rst.setCanCancelCustomerNum(this.gjOrgCustomerService.getCanCancelCustomerNum(cid));
        rst.setCheckContinueGjOrgCustomer(Boolean.valueOf(this.gjOrgCustomerService.checkContinueGjOrgCustomer(cid, rst.getOrgId())));
        return rst;
    }

    public String getCustomerUnsignMsg(Long customerId) {
        ThirdGjOrgCustomer customer = (ThirdGjOrgCustomer)this.gjOrgCustomerService.getById(customerId);
        if (customer == null) {
            return null;
        }
        if (customer.getState() == ThirdGjOrgCustomerStateEnum.cancel_audit.getValue()) {
            ThirdOrganizationVo org = this.thirdOrgMapper.getThirdOrganization(customer.getOrgId());
            return org.getName() + "\u63d0\u51fa\u89e3\u7ea6\u8bf7\u6c42\uff0c\u76d1\u7ba1\u6b63\u5728\u5ba1\u6838\u4e2d";
        }
        return null;
    }

    public GjOrgCustomerVo getGjOrgCustomer(Long gjOrgCustomerId, Long cid) {
        ThirdGjOrgCustomer gjOrgCustomer = (ThirdGjOrgCustomer)this.gjOrgCustomerService.getById(gjOrgCustomerId);
        if (gjOrgCustomer == null) {
            return null;
        }
        if (!Objects.equals(gjOrgCustomer.getCid(), cid)) {
            return null;
        }
        GjOrgCustomerVo result = new GjOrgCustomerVo();
        result.setId(gjOrgCustomer.getId());
        result.setCid(gjOrgCustomer.getCid());
        result.setState(gjOrgCustomer.getState());
        result.setOrgMan(gjOrgCustomer.getOrgMan());
        result.setOrgTel(gjOrgCustomer.getOrgTel());
        result.setUnitName(gjOrgCustomer.getUnitName());
        result.setUnitCreditCode(gjOrgCustomer.getUnitCreditCode());
        result.setUnitMan(gjOrgCustomer.getUnitMan());
        result.setUnitTel(gjOrgCustomer.getUnitTel());
        result.setUnitAddress(gjOrgCustomer.getUnitAddress());
        result.setSignTime(gjOrgCustomer.getSignTime());
        result.setExpireTime(gjOrgCustomer.getExpireTime());
        result.setCancelReason(gjOrgCustomer.getCancelReason());
        result.setContractFileList(this.sysFileProvideService.getListByIds(gjOrgCustomer.getContractFileId()));
        ThirdOrganizationVo thirdOrganization = this.thirdOrgMapper.getThirdOrganization(gjOrgCustomer.getOrgId());
        if (thirdOrganization != null) {
            result.setOrgName(thirdOrganization.getName());
            result.setOrgCreditCode(thirdOrganization.getCreditCode());
            result.setOrgAddress(thirdOrganization.getAddress());
        }
        return result;
    }

    @Transactional
    public Long addGjOrgCustomer(GjOrgCustomerAddParam param) {
        if (!this.gjOrgCustomerService.checkContinueGjOrgCustomer(param.getCid(), param.getOrgId())) {
            throw new ServiceException(String.format("\u60a8\u8fd8\u4e0d\u80fd\u548c\u201c%s\u201d\u7eed\u7ea6\uff01", param.getUnitName()));
        }
        ThirdGjOrgCustomer record = new ThirdGjOrgCustomer();
        record.setOrgId(param.getOrgId());
        record.setUserId(param.getUserId());
        record.setCid(param.getCid());
        record.setOrgMan(param.getOrgMan());
        record.setOrgTel(param.getOrgTel());
        record.setUnitName(param.getUnitName());
        record.setUnitCreditCode(param.getUnitCreditCode());
        record.setUnitMan(param.getUnitMan());
        record.setUnitTel(param.getUnitTel());
        record.setAreaId(param.getAreaId());
        record.setAreaId1(param.getAreaId1());
        record.setAreaId2(param.getAreaId2());
        record.setAreaId3(param.getAreaId3());
        record.setAreaId4(param.getAreaId4());
        record.setUnitAddress(param.getUnitAddress());
        record.setType(ThirdGjOrgCustomerTypeEnum.type2.getValue());
        record.setSignTime(param.getSignTime());
        record.setExpireTime(param.getExpireTime());
        record.setContractFileId(param.getContractFileId());
        record.setSource(ThirdGjOrgCustomerSourceEnum.COMPANY.getValue());
        record.setState(ThirdGjOrgCustomerStateEnum.sign_audit.getValue());
        record.setIsShowData(Integer.valueOf(0));
        this.gjOrgCustomerService.save(record);
        this.thirdGjOrgAuditLogService.save(new ThirdGjOrgAuditLog().setType(ThirdGjOrgAuditLogTypeEnum.third_gj_org_customer_sign.getValue()).setBusinessId(record.getId()).setOpt(ThirdGjOrgAuditOptEnum.customer_sign_opt_1.getOptName()).setOptValue(ThirdGjOrgAuditOptEnum.customer_sign_opt_1.getOptValue()).setOptPeople(param.getUnitName()).setOptDesc("\u7eed\u7ea6"));
        return record.getId();
    }

    @Transactional
    public void cancelGjOrgCustomer(Long gjOrgCustomerId, String cancelReason, String companyName) {
        ThirdGjOrgCustomer record = new ThirdGjOrgCustomer();
        record.setId(gjOrgCustomerId);
        record.setState(ThirdGjOrgCustomerStateEnum.cancel_audit.getValue());
        record.setCancelReason(cancelReason);
        this.gjOrgCustomerService.updateById(record);
        this.thirdGjOrgAuditLogService.save(new ThirdGjOrgAuditLog().setType(ThirdGjOrgAuditLogTypeEnum.third_gj_org_customer_cancel.getValue()).setBusinessId(gjOrgCustomerId).setOpt(ThirdGjOrgAuditOptEnum.customer_cancel_opt_1.getOptName()).setOptValue(ThirdGjOrgAuditOptEnum.customer_cancel_opt_1.getOptValue()).setOptPeople(companyName).setOptDesc(cancelReason));
    }

    public boolean checkPermission(Long gjOrgCustomerId, Long cid) {
        ThirdGjOrgCustomer record = (ThirdGjOrgCustomer)this.gjOrgCustomerService.getById(gjOrgCustomerId);
        return record != null && record.getCid() != null && record.getCid().equals(cid);
    }

    public List<ThirdGjOrgAuditLog> getGjOrgAuditLogList(Long businessId, Integer type) {
        if (businessId == null) {
            return null;
        }
        return this.thirdGjOrgAuditLogService.getGjOrgAuditLogList(businessId, type);
    }

    public JqGridData<CompanyCustomerHistoryListVo> getGjOrgCustomerListData(GjOrgCustomerQueryParam param) {
        return this.gjOrgCustomerService.getGjOrgCustomerListData(param);
    }

    public JqGridData<CompanyCustomerHistoryListVo> getSigningRecordsForOneUnit(GjOrgCustomerQueryParam param) {
        return this.gjOrgCustomerService.getSigningRecordsForOneUnit(param);
    }

    public JqGridData<CompanyCustomerHistoryListVo> listCustomerHistoryForCompany(CompanyCustomerSearchParam param) {
        return this.gjOrgCustomerService.listCustomerHistoryForCompany(param);
    }

    public GjOrgCustomerVo getLastGjOrgCustomer(Long orgId, Long cid) {
        ThirdGjOrgCustomer gjOrgCustomer = this.gjOrgCustomerService.getLastGjOrgCustomer(orgId, cid);
        if (gjOrgCustomer == null) {
            return null;
        }
        GjOrgCustomerVo result = this.gjOrgCustomerConverter.ThirdGjOrgCustomer2GjOrgCustomerVo(gjOrgCustomer);
        result.setContractFileList(this.sysFileProvideService.getListByIds(gjOrgCustomer.getContractFileId()));
        ThirdOrganizationVo thirdOrganization = this.thirdOrgMapper.getThirdOrganization(gjOrgCustomer.getOrgId());
        if (thirdOrganization != null) {
            result.setOrgName(thirdOrganization.getName());
            result.setOrgCreditCode(thirdOrganization.getCreditCode());
            result.setOrgAddress(thirdOrganization.getAddress());
        }
        return result;
    }

    public boolean checkContinueGjOrgCustomer(Long cid, Long orgId) {
        return this.gjOrgCustomerService.checkContinueGjOrgCustomer(cid, orgId);
    }

    public ThirdGjOrgCustomerProviderToCompany(IThirdGjOrgService thirdGjOrgService, IThirdGjUserService thirdGjUserService, IThirdGjUserLogService thirdGjUserLogService, IThirdGjOrgAuditLogService thirdGjOrgAuditLogService, IThirdGjOrgCustomerService gjOrgCustomerService, ThirdOrgMapper thirdOrgMapper, ReformItemBasicMapper reformItemBasicMapper, GjOrgCustomerConverter gjOrgCustomerConverter) {
        this.thirdGjOrgService = thirdGjOrgService;
        this.thirdGjUserService = thirdGjUserService;
        this.thirdGjUserLogService = thirdGjUserLogService;
        this.thirdGjOrgAuditLogService = thirdGjOrgAuditLogService;
        this.gjOrgCustomerService = gjOrgCustomerService;
        this.thirdOrgMapper = thirdOrgMapper;
        this.reformItemBasicMapper = reformItemBasicMapper;
        this.gjOrgCustomerConverter = gjOrgCustomerConverter;
    }
}

