/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.controller.app;

import cn.hutool.core.util.DesensitizedUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.annotation.Log;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.fwgj.bootstrap.security.service.ShiroUtil;
import cn.smarthse.fwgj.entity.sys.ThirdGjUser;
import cn.smarthse.fwgj.framework.utils.JwtUtil;
import cn.smarthse.fwgj.service.sys.IThirdGjUserService;
import jakarta.validation.constraints.NotNull;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/m/user"})
@Validated
public class UserController
extends ControllerSupport {
    private final IThirdGjUserService thirdGjUserService;

    @GetMapping(value={"/getUser"})
    public ResponseData<ThirdGjUser> getUser() {
        ThirdGjUser userInfo = ShiroUtil.getUserInfo();
        ThirdGjUser data = new ThirdGjUser();
        data.setId(userInfo.getId());
        data.setFullname(StrUtil.hide((CharSequence)userInfo.getFullname(), (int)-1, (int)1));
        data.setUsername(userInfo.getUsername());
        data.setGjUserLogId(userInfo.getGjUserLogId());
        data.setMobile(DesensitizedUtil.mobilePhone((String)userInfo.getMobile()));
        data.setPost(userInfo.getPost());
        data.setZlbUserId(userInfo.getZlbUserId());
        return ResponseData.success((Object)data);
    }

    @Log(title="\u4fee\u6539\u5bc6\u7801\uff08\u767b\u5f55\u540e\uff09", type=29)
    @PostMapping(value={"/modifyPassword"})
    public ResponseData<String> modifyPassword(@NotNull String newPassword) {
        this.logger.info("\u4e61\u9547\u534f\u7ba1\u4fee\u6539\u5bc6\u7801:username: {}", (Object)JwtUtil.getUsername());
        this.thirdGjUserService.modifyPassword(ShiroUtil.getLoginUserId(), newPassword);
        return ResponseData.success(null);
    }

    @Log(title="\u4fee\u6539\u5bc6\u7801\uff08by\u65e7\u5bc6\u7801\uff09", type=29)
    @PostMapping(value={"/modifyPasswordByOldPwd"})
    public ResponseData<String> modifyPasswordByOldPwd(@NotNull String oldPassword, @NotNull String newPassword) {
        this.logger.info("\u4e61\u9547\u534f\u7ba1\u4fee\u6539\u5bc6\u7801:username: {}", (Object)JwtUtil.getUsername());
        this.thirdGjUserService.modifyPassword(ShiroUtil.getLoginUserId(), oldPassword, newPassword);
        return ResponseData.success(null);
    }

    public UserController(IThirdGjUserService thirdGjUserService) {
        this.thirdGjUserService = thirdGjUserService;
    }
}

