/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.controller.app;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.web.annotaion.RequestLimit;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.fwgj.bootstrap.security.service.ShiroUtil;
import cn.smarthse.fwgj.manage.IReformManage;
import cn.smarthse.fwgj.model.param.ReformParam;
import cn.smarthse.fwgj.model.param.SaveReformRecordParam;
import cn.smarthse.fwgj.model.vo.ReformDetailVo;
import cn.smarthse.fwgj.model.vo.check.ReformVo;
import cn.smarthse.fwgj.model.vo.third.ReformStasticsVo;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/m/reform"})
@Validated
public class ReformController
extends ControllerSupport {
    private final IReformManage reformManage;

    @GetMapping(value={"/getReformList"})
    public ResponseData<List<ReformVo>> getReformListByCheckId(@NotNull(message="\u5de1\u67e5id\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u5de1\u67e5id\u4e0d\u80fd\u4e3a\u7a7a") Long checkId) {
        return ResponseData.success(this.reformManage.getReformListByCheckId(checkId));
    }

    @GetMapping(value={"/getReformListByCid"})
    public ResponseData<List<ReformVo>> getReformListByCid(@NotNull Long cid) {
        return ResponseData.success(this.reformManage.getReformListByCid(cid));
    }

    @GetMapping(value={"/getReformList2"})
    public ResponseData<List<ReformVo>> getReformListBycheckIdId2(@NotNull(message="\u5de1\u67e5id\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u5de1\u67e5id\u4e0d\u80fd\u4e3a\u7a7a") Long checkId) {
        return ResponseData.success(this.reformManage.getReformListByPatrolId2(checkId));
    }

    @GetMapping(value={"/getReformListByCid2"})
    public ResponseData<List<ReformVo>> getReformListByCid2(@NotNull Long cid) {
        return ResponseData.success(this.reformManage.getReformListByCid2(cid));
    }

    @GetMapping(value={"/getPastReformList"})
    public ResponseData<List<ReformVo>> getPastReformList(@NotNull(message="\u5de1\u67e5id\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u5de1\u67e5id\u4e0d\u80fd\u4e3a\u7a7a") Long checkId) {
        Long orgId = ShiroUtil.getLoginOrgId();
        return ResponseData.success(this.reformManage.getPastReformList(checkId, orgId));
    }

    @GetMapping(value={"/getReformListData"})
    public ResponseData<JqGridData<ReformVo>> getReformListData(ReformParam param) {
        param.setOrgId(ShiroUtil.getLoginOrgId());
        return ResponseData.success(this.reformManage.getReformListData(param));
    }

    @GetMapping(value={"/getReform"})
    public ResponseData<ReformDetailVo> getReform(@NotNull(message="\u98ce\u9669id\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u98ce\u9669id\u4e0d\u80fd\u4e3a\u7a7a") Long reformId) {
        return ResponseData.success((Object)this.reformManage.getReformV2(reformId));
    }

    @RequestLimit(second=2, maxCount=1)
    @PostMapping(value={"/saveReformRecord"})
    public ResponseData<String> saveReformRecord(@RequestBody @Valid SaveReformRecordParam param) {
        param.setUserId(ShiroUtil.getLoginUserId());
        param.setFullName(ShiroUtil.getLoginUserNickname());
        this.reformManage.saveReformRecord(param);
        return ResponseData.success();
    }

    @Deprecated
    @GetMapping(value={"/getReformStatistics"})
    public ResponseData<ReformStasticsVo> getReformStatistics(@NotNull(message="cid\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="cid\u4e0d\u80fd\u4e3a\u7a7a") Long cid) {
        return ResponseData.success((Object)this.reformManage.getReformStatisticsByCid(cid));
    }

    public ReformController(IReformManage reformManage) {
        this.reformManage = reformManage;
    }
}

