/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.controller.app;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.web.annotaion.RequestLimit;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.fwgj.bootstrap.security.service.ShiroUtil;
import cn.smarthse.fwgj.manage.IThirdGjManage;
import cn.smarthse.fwgj.model.param.AddCheckParam;
import cn.smarthse.fwgj.model.param.AddReformListParam;
import cn.smarthse.fwgj.model.param.CheckRecordParam;
import cn.smarthse.fwgj.model.param.UpdateCheckParam;
import cn.smarthse.fwgj.model.param.check.UpdateCheckInfoParam;
import cn.smarthse.fwgj.model.vo.CheckItemReferenceDataVo;
import cn.smarthse.fwgj.model.vo.check.CheckVo;
import cn.smarthse.fwgj.model.vo.check.ReformListVo;
import cn.smarthse.fwgj.model.vo.third.CheckRecordVo;
import java.util.Calendar;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/m/check"})
@Validated
public class GjCheckController
extends ControllerSupport {
    private final IThirdGjManage checkManage;

    @GetMapping(value={"/listCheckRecord"})
    public ResponseData<List<CheckRecordVo>> listCheckRecord(CheckRecordParam param) {
        return ResponseData.success(this.checkManage.listCheckRecord(param));
    }

    @GetMapping(value={"/getCheck"})
    public ResponseData<CheckVo> getCheck(Long id) {
        return ResponseData.success((Object)this.checkManage.getCheck(id));
    }

    @PostMapping(value={"/addCheck"})
    public ResponseData<Long> addCheck(@RequestBody AddCheckParam param) {
        return ResponseData.success((Object)this.checkManage.addCheck(param.getCustomerId()));
    }

    @PostMapping(value={"/updateCheck"})
    public ResponseData<Boolean> updateCheck(@RequestBody UpdateCheckParam updateCheckParam) {
        if (updateCheckParam.getCheckInfoParam() != null) {
            updateCheckParam.getCheckInfoParam().setCheckPeople(ShiroUtil.getLoginUserNickname());
        }
        return ResponseData.success((Object)this.checkManage.updateCheck(updateCheckParam));
    }

    @PostMapping(value={"/delCheck"})
    public ResponseData<Boolean> delCheck(@RequestBody UpdateCheckInfoParam param) {
        this.checkManage.delCheck(param);
        return ResponseData.success((String)"");
    }

    @GetMapping(value={"/getReformListByPid"})
    public ResponseData<List<ReformListVo>> getReformListByPid(Long checkId, Long cid) {
        return ResponseData.success(this.checkManage.getReformListByPid(checkId, cid));
    }

    @PostMapping(value={"/commitReformAndCheck"})
    @RequestLimit(msg="\u63d0\u4ea4\u9891\u7e41\uff01\u8bf75\u79d2\u540e\u91cd\u8bd5")
    public ResponseData<String> commitReformAndCheck(@RequestBody AddReformListParam param) {
        param.setYear(Calendar.getInstance().get(1));
        return ResponseData.success((String)this.checkManage.commitReformAndCheck(param));
    }

    @PostMapping(value={"/createForClock"})
    public ResponseData<Long> createForClock(@RequestBody AddCheckParam param) {
        return ResponseData.success((Object)this.checkManage.createForClock(param.getCustomerId()));
    }

    @PostMapping(value={"/commitForClock"})
    public ResponseData<Boolean> commitForClock(@RequestBody UpdateCheckInfoParam param) {
        return ResponseData.success((Object)this.checkManage.commitForClock(param));
    }

    @GetMapping(value={"/getItemReferenceData"})
    public ResponseData<CheckItemReferenceDataVo> getItemReferenceData(Long cid) {
        return ResponseData.success((Object)this.checkManage.getItemReferenceData(cid));
    }

    public GjCheckController(IThirdGjManage checkManage) {
        this.checkManage = checkManage;
    }
}

