/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.controller;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.fwgj.bootstrap.security.service.LoginService;
import cn.smarthse.fwgj.bootstrap.security.token.LoginData;
import cn.smarthse.fwgj.entity.sys.ThirdGjUser;
import cn.smarthse.fwgj.manage.zlb.IZlbClientServiceService;
import cn.smarthse.fwgj.manage.zlb.PersonInfo;
import cn.smarthse.fwgj.manage.zlb.ZlbUserInfo;
import cn.smarthse.fwgj.service.sys.IThirdGjUserService;
import jakarta.validation.constraints.NotEmpty;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/m/login"})
@Validated
public class ZlbLoginController
extends ControllerSupport {
    private static final Logger log = LoggerFactory.getLogger(ZlbLoginController.class);
    private final LoginService loginService;
    private final IZlbClientServiceService zlbClientService;
    private final IThirdGjUserService thirdGjUserService;
    @Value(value="${zlb.appKey}")
    private String appKey;
    @Value(value="${zlb.appSecret}")
    private String appSecret;

    @Log(type=1, title="\u6d59\u91cc\u529e\u5355\u70b9\u767b\u5165")
    @PostMapping(value={"/zlb"})
    public ResponseData<LoginData> loginByZlb(@NotEmpty String ticket, String appId) {
        this.logger.debug("\u6d59\u91cc\u529e\u767b\u5f55: {}", (Object)ticket);
        ZlbUserInfo zlbUserInfo = this.zlbClientService.getZlbUserInfo(ticket, appId);
        PersonInfo personInfo = zlbUserInfo.getPersonInfo();
        if (zlbUserInfo == null) {
            return ResponseData.fail((String)"\u767b\u5165\u5931\u8d25\uff01");
        }
        if (!"PERSON".equalsIgnoreCase(zlbUserInfo.getUserType())) {
            return ResponseData.fail((String)"\u6cd5\u4eba\u7528\u6237\u65e0\u6743\u9650\uff01");
        }
        ThirdGjUser exists = this.thirdGjUserService.getUserByZlbUserId(zlbUserInfo.getUserId());
        if (exists != null) {
            LoginData result = this.loginService.loginByUsername(exists.getUsername(), null);
            result.setNickName(personInfo.getUserName());
            result.setZlbUserId(personInfo.getUserId());
            return ResponseData.success((Object)result);
        }
        if (StringUtils.isEmpty((CharSequence)personInfo.getIdNo())) {
            return ResponseData.fail((String)"\u76ee\u524d\u6682\u4e0d\u652f\u6301\u65e0\u8eab\u4efd\u8bc1\u7684\u6d59\u91cc\u529e\u7528\u6237\u767b\u5165\uff01");
        }
        exists = this.thirdGjUserService.getUserByIdcard(personInfo.getIdNo());
        if (exists == null) {
            return ResponseData.fail((String)"\u60a8\u6ca1\u6709\u670d\u52a1\u7ba1\u5bb6\u8d26\u53f7\uff01");
        }
        LoginData result = this.loginService.loginByUsername(exists.getUsername(), zlbUserInfo.getUserId());
        result.setNickName(personInfo.getUserName());
        result.setZlbUserId(personInfo.getUserId());
        return ResponseData.success((Object)result);
    }

    public ZlbLoginController(LoginService loginService, IZlbClientServiceService zlbClientService, IThirdGjUserService thirdGjUserService) {
        this.loginService = loginService;
        this.zlbClientService = zlbClientService;
        this.thirdGjUserService = thirdGjUserService;
    }
}

