/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.controller;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.fwgj.bootstrap.properties.SysProperties;
import cn.smarthse.fwgj.bootstrap.security.service.LoginService;
import cn.smarthse.fwgj.bootstrap.security.token.LoginData;
import cn.smarthse.fwgj.framework.RedisKey;
import cn.smarthse.fwgj.framework.utils.JwtUtil;
import cn.smarthse.fwgj.service.sys.IThirdGjUserService;
import cn.smarthse.modules.common.enums.BigLogBusinessModuleEnum;
import cn.smarthse.modules.datacentre.model.bigdata.BigLog;
import com.sx.log.enums.ActionTypeEnum;
import com.sx.log.enums.UserRoleEnum;
import jakarta.validation.constraints.NotEmpty;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/m/login"})
@Validated
public class LoginController
extends ControllerSupport {
    private final LoginService loginService;
    private final IThirdGjUserService userService;
    private final StringRedisTemplate stringRedisTemplate;
    private final SysProperties sysProperties;

    @Log(title="\u5bc6\u7801\u767b\u5f55", type=1)
    @BigLog(userRole=UserRoleEnum.ENTERPRISE_TYPE, actionType=ActionTypeEnum.LOGIN_TYPE, businessModule=BigLogBusinessModuleEnum.module5)
    @PostMapping(value={"/password"})
    public ResponseData<LoginData> loginByPassword(@NotEmpty(message="\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a") String username, @NotEmpty(message="\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") String password, @NotEmpty(message="\u56fe\u5f62\u9a8c\u8bc1\u7801key\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u56fe\u5f62\u9a8c\u8bc1\u7801key\u4e0d\u80fd\u4e3a\u7a7a") String key, @NotEmpty(message="\u56fe\u5f62\u9a8c\u8bc1\u7801vcode\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="\u56fe\u5f62\u9a8c\u8bc1\u7801vcode\u4e0d\u80fd\u4e3a\u7a7a") String vcode) {
        if (!this.loginService.checkVCode(key, vcode, true)) {
            return ResponseData.fail((String)"\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
        }
        LoginData result = this.loginService.loginByPassword(username, password);
        this.stringRedisTemplate.opsForValue().get((Object)RedisKey.getVCodeKey(key));
        return ResponseData.success((Object)result);
    }

    @PostMapping(value={"/token/refresh"})
    public ResponseData<LoginData> tokenRefresh(@RequestParam String refreshToken) {
        return ResponseData.success((Object)this.loginService.tokenRefresh(refreshToken));
    }

    @PostMapping(value={"/sendVCode"})
    public ResponseData<String> sendVCode(String key) {
        return ResponseData.success((String)"\u6210\u529f", (Object)this.loginService.sendVCode(key));
    }

    @PostMapping(value={"/checkVCode"})
    public ResponseData<Boolean> checkVcode(String key, @NotEmpty(message="\u9a8c\u8bc1\u7801") @NotEmpty(message="\u9a8c\u8bc1\u7801") String vode) {
        return ResponseData.success((Object)this.loginService.checkVCode(key, vode, false));
    }

    @PostMapping(value={"/logout"})
    public ResponseData<String> logout() {
        this.loginService.logout(JwtUtil.getUserId());
        return ResponseData.success();
    }

    public LoginController(LoginService loginService, IThirdGjUserService userService, StringRedisTemplate stringRedisTemplate, SysProperties sysProperties) {
        this.loginService = loginService;
        this.userService = userService;
        this.stringRedisTemplate = stringRedisTemplate;
        this.sysProperties = sysProperties;
    }
}

