/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.bootstrap.security.service;

import cn.smarthse.fwgj.bootstrap.security.token.ShiroPrincipal;
import cn.smarthse.fwgj.entity.sys.ThirdGjUser;
import cn.smarthse.fwgj.enums.ThirdGjUserLogForbiddenStateEnum;
import cn.smarthse.fwgj.framework.Constant;
import cn.smarthse.fwgj.framework.RedisKey;
import cn.smarthse.fwgj.model.vo.admin.GjOrgListAdminVo;
import cn.smarthse.fwgj.service.sys.IThirdGjUserLogService;
import cn.smarthse.fwgj.service.sys.IThirdGjUserService;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.DisabledAccountException;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TokenService {
    private final IThirdGjUserService userService;
    private final IThirdGjUserLogService userLogService;
    private final RedisTemplate<String, ShiroPrincipal> redisTemplate;

    public ShiroPrincipal getLoginUser(Long userId) {
        String loginUserKey = RedisKey.getLoginUserKey(userId);
        ShiroPrincipal principal = (ShiroPrincipal)this.redisTemplate.opsForValue().get((Object)loginUserKey);
        if (principal == null) {
            principal = new ShiroPrincipal();
            ThirdGjUser user = (ThirdGjUser)this.userService.getById(userId);
            if (user == null) {
                throw new AuthenticationException("\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u6388\u6743\u5931\u8d25\uff01");
            }
            if (user.getIsForbidden() == Constant.ACTIVE_YES) {
                throw new DisabledAccountException("\u8d26\u53f7\u88ab\u7981\u7528\uff01");
            }
            List<GjOrgListAdminVo> gjOrgList = this.getGjOrgList(user.getId());
            if (CollectionUtils.isEmpty(gjOrgList) || gjOrgList.stream().noneMatch(record -> ThirdGjUserLogForbiddenStateEnum.PASS.getValue().equals(record.getForbiddenState()))) {
                throw new DisabledAccountException("\u8d26\u53f7\u88ab\u7981\u7528\uff01");
            }
            principal.setUser(user);
            this.initDefaultOrgId(principal, this.userLogService.getGjOrgList(userId));
            this.redisTemplate.opsForValue().set((Object)loginUserKey, (Object)principal, Constant.REDIS_PRINCIPAL_TIME.longValue(), TimeUnit.MINUTES);
            return principal;
        }
        return principal;
    }

    public ThirdGjUser getByUsername(String username) {
        return this.userService.getUserByUsername(username);
    }

    public ThirdGjUser getByIdcard(String idcard) {
        return this.userService.getUserByIdcard(idcard);
    }

    public ThirdGjUser getByMobile(String mobile) {
        return this.userService.getUserByMobile(mobile);
    }

    public void bindZlbUserId(Long gjUserId, String zlbUserId) {
        this.userService.bindZlbUserId(gjUserId, zlbUserId);
    }

    public void initDefaultOrgId(ShiroPrincipal principal, List<GjOrgListAdminVo> gjOrgList) {
        if (CollectionUtils.isEmpty(gjOrgList)) {
            return;
        }
        if (CollectionUtils.isEmpty(gjOrgList = gjOrgList.stream().filter(record -> ThirdGjUserLogForbiddenStateEnum.PASS.getValue().equals(record.getForbiddenState())).collect(Collectors.toList()))) {
            return;
        }
        if (!CollectionUtils.isEmpty(gjOrgList)) {
            principal.setGjUserLogId(((GjOrgListAdminVo)gjOrgList.get(0)).getGjUserLogId());
            principal.setOrgId(((GjOrgListAdminVo)gjOrgList.get(0)).getOrgId());
            principal.setOrgName(((GjOrgListAdminVo)gjOrgList.get(0)).getOrgName());
            principal.setOrgAreaId(((GjOrgListAdminVo)gjOrgList.get(0)).getAreaId());
        }
    }

    public List<GjOrgListAdminVo> getGjOrgList(Long gjUserId) {
        return this.userLogService.getGjOrgList(gjUserId);
    }

    public TokenService(IThirdGjUserService userService, IThirdGjUserLogService userLogService, RedisTemplate<String, ShiroPrincipal> redisTemplate) {
        this.userService = userService;
        this.userLogService = userLogService;
        this.redisTemplate = redisTemplate;
    }
}

