/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.bootstrap.security.service;

import cn.smarthse.fwgj.bootstrap.security.token.ShiroPrincipal;
import cn.smarthse.fwgj.entity.sys.ThirdGjUser;
import java.util.Set;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.subject.Subject;

public class ShiroUtil {
    public static Subject getSubject() {
        return SecurityUtils.getSubject();
    }

    public static ShiroPrincipal getShiroPrincipal() {
        Subject subject = ShiroUtil.getSubject();
        return (ShiroPrincipal)subject.getPrincipal();
    }

    public static ThirdGjUser getUserInfo() {
        ShiroPrincipal principal = ShiroUtil.getShiroPrincipal();
        if (principal != null) {
            return principal.getUser();
        }
        return null;
    }

    public static void flushOrgId(Long orgId, Long gjUserLogId, String orgName, Long orgAreaId) {
        Subject subject = SecurityUtils.getSubject();
        if (subject.isAuthenticated()) {
            ShiroPrincipal principal = (ShiroPrincipal)subject.getPrincipal();
            principal.setOrgId(orgId);
            principal.setOrgAreaId(orgAreaId);
            principal.setGjUserLogId(gjUserLogId);
            principal.setOrgName(orgName);
            SimplePrincipalCollection newPrincipalCollection = new SimplePrincipalCollection((Object)principal, principal.getUser().getFullname());
            subject.runAs((PrincipalCollection)newPrincipalCollection);
        }
    }

    public static Long getLoginUserId() {
        ThirdGjUser user = ShiroUtil.getUserInfo();
        return user != null ? user.getId() : null;
    }

    public static String getLoginUsername() {
        ThirdGjUser user = ShiroUtil.getUserInfo();
        return user != null ? user.getUsername() : null;
    }

    public static String getLoginUserNickname() {
        ThirdGjUser user = ShiroUtil.getUserInfo();
        return user != null ? user.getFullname() : null;
    }

    public static Long getLoginGjUserIdLog() {
        ShiroPrincipal principal = ShiroUtil.getShiroPrincipal();
        return principal != null ? principal.getGjUserLogId() : null;
    }

    public static Long getLoginOrgId() {
        ShiroPrincipal principal = ShiroUtil.getShiroPrincipal();
        return principal != null ? principal.getOrgId() : null;
    }

    public static String getLoginOrgName() {
        ShiroPrincipal principal = ShiroUtil.getShiroPrincipal();
        return principal != null ? principal.getOrgName() : null;
    }

    public static Long getOrgAreaId() {
        ShiroPrincipal principal = ShiroUtil.getShiroPrincipal();
        return principal != null ? principal.getOrgAreaId() : null;
    }

    public static Set<String> getPermissionSet() {
        return ShiroUtil.getShiroPrincipal().getPermissionsSet();
    }

    public static Set<String> getRoleSet() {
        return ShiroUtil.getShiroPrincipal().getRoleSet();
    }

    public static boolean hasPermission(String permissionCode) {
        return ShiroUtil.getPermissionSet().contains(permissionCode);
    }

    public static boolean hasRole(String roleCode) {
        return ShiroUtil.getRoleSet().contains(roleCode);
    }

    public static boolean isSuperAdmin() {
        return ShiroUtil.getShiroPrincipal().getRoleSet().contains("superadmin");
    }
}

