/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.bootstrap.security.service;

import cn.hutool.captcha.CaptchaUtil;
import cn.hutool.captcha.LineCaptcha;
import cn.hutool.core.util.DesensitizedUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.core.utils.ServletUtils;
import cn.smarthse.fwgj.bootstrap.properties.SysProperties;
import cn.smarthse.fwgj.bootstrap.security.service.TokenService;
import cn.smarthse.fwgj.bootstrap.security.token.CasToken;
import cn.smarthse.fwgj.bootstrap.security.token.LoginData;
import cn.smarthse.fwgj.bootstrap.security.token.PasswordToken;
import cn.smarthse.fwgj.bootstrap.security.token.RegisterToken;
import cn.smarthse.fwgj.bootstrap.security.token.ShiroPrincipal;
import cn.smarthse.fwgj.entity.sys.ThirdGjUser;
import cn.smarthse.fwgj.framework.Constant;
import cn.smarthse.fwgj.framework.RedisKey;
import cn.smarthse.fwgj.framework.utils.CommonsUtils;
import cn.smarthse.fwgj.framework.utils.JwtUtil;
import cn.smarthse.fwgj.service.sys.IEmailService;
import cn.smarthse.fwgj.service.sys.IThirdGjUserLogService;
import cn.smarthse.fwgj.service.sys.IThirdGjUserService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AccountException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.ExpiredCredentialsException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.subject.Subject;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class LoginService {
    private final IThirdGjUserService sysUserService;
    private final IThirdGjUserLogService userLogService;
    private final IEmailService emailService;
    private final StringRedisTemplate stringRedisTemplate;
    private final RedisTemplate<String, Object> redisTemplate;
    private final TokenService tokenService;
    private final SysProperties sysProperties;

    private String generateVerificationCode() {
        return RandomUtil.randomNumbers((int)6);
    }

    public LoginData loginByPassword(String username, String password) {
        try {
            Subject subject = SecurityUtils.getSubject();
            PasswordToken token = new PasswordToken(username, password);
            subject.login((AuthenticationToken)token);
            return this.returnLoginInitParam((ShiroPrincipal)subject.getPrincipal());
        }
        catch (UnknownAccountException e) {
            throw new ServiceException("\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        catch (IncorrectCredentialsException e) {
            throw new ServiceException("\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        catch (DisabledAccountException e) {
            throw new ServiceException("\u8d26\u53f7\u88ab\u7981\u7528\uff01");
        }
        catch (AccountException e) {
            throw new ServiceException(e.getMessage());
        }
        catch (AuthenticationException e) {
            throw new ServiceException("\u8ba4\u8bc1\u5931\u8d25\uff01");
        }
    }

    public LoginData loginByUsername(String username, String zlbUserId) {
        Subject subject = SecurityUtils.getSubject();
        RegisterToken token = new RegisterToken(username, zlbUserId);
        try {
            subject.login((AuthenticationToken)token);
            ShiroPrincipal principal = (ShiroPrincipal)subject.getPrincipal();
            return this.returnLoginInitParam(principal);
        }
        catch (UnknownAccountException e) {
            throw new ServiceException("\u8d26\u53f7\u4e0d\u5b58\u5728\uff01");
        }
        catch (DisabledAccountException e) {
            throw new ServiceException("\u8d26\u53f7\u88ab\u7981\u7528\uff01");
        }
        catch (ExpiredCredentialsException e) {
            throw new ServiceException("\u9a8c\u8bc1\u7801\u5931\u6548\uff01");
        }
    }

    public LoginData loginByCas(CasToken token) {
        try {
            Subject subject = SecurityUtils.getSubject();
            subject.login((AuthenticationToken)token);
            return this.returnLoginInitParam((ShiroPrincipal)subject.getPrincipal());
        }
        catch (UnknownAccountException e) {
            throw new ServiceException("\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        catch (IncorrectCredentialsException e) {
            throw new ServiceException("\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u8bd5\uff01\uff01");
        }
        catch (DisabledAccountException e) {
            throw new ServiceException("\u8d26\u53f7\u88ab\u7981\u7528\uff01");
        }
    }

    private LoginData returnLoginInitParam(ShiroPrincipal principal) {
        Long userId = principal.getUserId();
        String isForbidden = principal.getUser().getIsForbidden().toString();
        String username = principal.getUser().getUsername();
        String name = principal.getUser().getFullname();
        String ip = ServletUtils.getClientIP((HttpServletRequest)ServletUtils.getRequest(), (String[])new String[0]);
        String secret = this.sysProperties.getLogin().getSecret();
        String audience = this.sysProperties.getLogin().getAudience();
        String token = JwtUtil.createToken(username, userId, name, ip, secret, audience, Constant.TOKEN_EXPIRE_TIME);
        String refreshToken = JwtUtil.createToken(username, userId, secret, audience, Constant.TOKEN_REFRESH_TIME);
        this.redisTemplate.opsForValue().set((Object)RedisKey.getLoginUserKey(userId), (Object)principal, Constant.REDIS_PRINCIPAL_TIME.longValue(), TimeUnit.MINUTES);
        principal.getUser().setPassword(null);
        principal.getUser().setSalt(null);
        principal.getUser().setFullname(StrUtil.hide((CharSequence)principal.getUser().getFullname(), (int)-1, (int)1));
        principal.getUser().setIdcard(DesensitizedUtil.idCardNum((String)principal.getUser().getIdcard(), (int)1, (int)2));
        principal.getUser().setMobile(DesensitizedUtil.mobilePhone((String)principal.getUser().getMobile()));
        return new LoginData(principal, token, refreshToken);
    }

    public LoginData tokenRefresh(String refreshToken) {
        String audience;
        Long userId = JwtUtil.getUserId(refreshToken);
        String ip = ServletUtils.getRequest().getRemoteAddr();
        if (userId == null) {
            throw new ServiceException("refreshToken\u65e0\u6548\uff01");
        }
        ThirdGjUser user = (ThirdGjUser)this.sysUserService.getById(userId);
        if (user == null) {
            throw new ServiceException("\u8d26\u53f7\u4e0d\u5b58\u5728\uff0ctoken\u5237\u65b0\u5931\u8d25\uff01");
        }
        String secret = this.sysProperties.getLogin().getSecret();
        if (!JwtUtil.verify(refreshToken, secret, audience = this.sysProperties.getLogin().getAudience())) {
            throw new ServiceException("token\u5237\u65b0\u5931\u8d25\uff01");
        }
        String newToken = JwtUtil.createToken(user.getUsername(), user.getId(), user.getFullname(), ip, secret, audience, Constant.TOKEN_EXPIRE_TIME);
        String newRefreshToken = JwtUtil.createToken(user.getUsername(), user.getId(), secret, audience, Constant.TOKEN_REFRESH_TIME);
        return new LoginData(newToken, newRefreshToken);
    }

    public boolean sendEmailCode(String email) {
        String code = this.generateVerificationCode();
        String text = String.format("\u3010\u6d59\u91cc\u536b\u4f01-\u4e61\u9547\u534f\u7ba1\u3011\u60a8\u7684\u9a8c\u8bc1\u7801\uff1a%s\uff0c\u8bf7\u5c3d\u5feb\u5b8c\u6210\u9a8c\u8bc1\u3002\u5982\u975e\u672c\u4eba\u64cd\u4f5c\uff0c\u8bf7\u5ffd\u7565\u30025\u5206\u949f\u5185\u6709\u6548\uff01", code);
        this.emailService.sendVcodeEmail(email, text);
        String encryptCode = CommonsUtils.encryptPassword(code, email);
        this.stringRedisTemplate.opsForValue().set((Object)RedisKey.getEmailCodeKey(email), (Object)encryptCode, (long)Constant.CODE_EXPIRE_TIME.intValue(), TimeUnit.MINUTES);
        return true;
    }

    public String sendVCode(String key) {
        LineCaptcha specCaptcha = CaptchaUtil.createLineCaptcha((int)130, (int)48, (int)4, (int)0);
        String code = specCaptcha.getCode().toLowerCase();
        this.stringRedisTemplate.opsForValue().set((Object)RedisKey.getVCodeKey(key), (Object)code, (long)Constant.CODE_EXPIRE_TIME.intValue(), TimeUnit.MINUTES);
        return specCaptcha.getImageBase64Data();
    }

    public boolean checkEmailCode(String email, String code) {
        Object modifyCode = this.stringRedisTemplate.opsForValue().get((Object)RedisKey.getEmailCodeKey(email));
        if (Objects.isNull(modifyCode)) {
            throw new ServiceException("\u9a8c\u8bc1\u7801\u8fc7\u671f\uff01");
        }
        String encryptCode = CommonsUtils.encryptPassword(String.valueOf(code), email);
        return Objects.equals(encryptCode, modifyCode.toString());
    }

    public boolean checkVCode(String key, String vcode, boolean isDelete) {
        Object vCodeCache = null;
        if (isDelete) {
            vCodeCache = this.stringRedisTemplate.opsForValue().get((Object)RedisKey.getVCodeKey(key));
            this.stringRedisTemplate.delete((Object)RedisKey.getVCodeKey(key));
        } else {
            vCodeCache = this.stringRedisTemplate.opsForValue().get((Object)RedisKey.getVCodeKey(key));
        }
        if (Objects.isNull(vCodeCache)) {
            throw new ServiceException("\u9a8c\u8bc1\u7801\u8fc7\u671f\uff01");
        }
        return vcode != null && vcode.equalsIgnoreCase(vCodeCache.toString());
    }

    public void logout(Long userId) {
        this.redisTemplate.delete((Object)RedisKey.getLoginUserKey(userId));
        this.redisTemplate.delete((Object)RedisKey.getForbiddenKey(userId));
    }

    public LoginService(IThirdGjUserService sysUserService, IThirdGjUserLogService userLogService, IEmailService emailService, StringRedisTemplate stringRedisTemplate, RedisTemplate<String, Object> redisTemplate, TokenService tokenService, SysProperties sysProperties) {
        this.sysUserService = sysUserService;
        this.userLogService = userLogService;
        this.emailService = emailService;
        this.stringRedisTemplate = stringRedisTemplate;
        this.redisTemplate = redisTemplate;
        this.tokenService = tokenService;
        this.sysProperties = sysProperties;
    }
}

