/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.bootstrap.security.realms;

import cn.smarthse.fwgj.bootstrap.security.service.TokenService;
import cn.smarthse.fwgj.bootstrap.security.token.RegisterToken;
import cn.smarthse.fwgj.bootstrap.security.token.ShiroPrincipal;
import cn.smarthse.fwgj.entity.sys.ThirdGjUser;
import cn.smarthse.fwgj.enums.ThirdGjUserLogForbiddenStateEnum;
import cn.smarthse.fwgj.framework.Constant;
import cn.smarthse.fwgj.model.vo.admin.GjOrgListAdminVo;
import java.util.List;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.CollectionUtils;

public class RegisterRealm
extends AuthorizingRealm {
    private static final Logger log = LoggerFactory.getLogger(RegisterRealm.class);
    @Autowired(required=false)
    @Lazy
    private TokenService tokenService;

    public boolean supports(AuthenticationToken token) {
        return token instanceof RegisterToken;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        RegisterToken token = (RegisterToken)authenticationToken;
        String username = token.getUsername();
        log.debug("{} - token auth start...", (Object)username);
        ThirdGjUser user = this.tokenService.getByUsername(username);
        if (user == null) {
            throw new UnknownAccountException("\u8d26\u53f7\u4e0d\u5b58\u5728\uff01");
        }
        if (user.getIsForbidden() == Constant.ACTIVE_YES) {
            throw new DisabledAccountException("\u8d26\u53f7\u88ab\u7981\u7528\uff01");
        }
        List<GjOrgListAdminVo> gjOrgList = this.tokenService.getGjOrgList(user.getId());
        if (CollectionUtils.isEmpty(gjOrgList) || gjOrgList.stream().noneMatch(record -> ThirdGjUserLogForbiddenStateEnum.PASS.getValue().equals(record.getForbiddenState()))) {
            throw new DisabledAccountException("\u8d26\u53f7\u88ab\u7981\u7528\uff01");
        }
        if (token.getZlbUserId() != null) {
            this.tokenService.bindZlbUserId(user.getId(), token.getZlbUserId());
        }
        ShiroPrincipal principal = new ShiroPrincipal(user);
        this.tokenService.initDefaultOrgId(principal, gjOrgList);
        return new SimpleAuthenticationInfo((Object)principal, (Object)"", this.getName());
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        Object obj = super.getAvailablePrincipal(principals);
        if (!(obj instanceof ShiroPrincipal)) {
            return info;
        }
        ShiroPrincipal principal = (ShiroPrincipal)obj;
        info.setStringPermissions(principal.getPermissionsSet());
        info.setRoles(principal.getRoleSet());
        return info;
    }
}

