/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.bootstrap.security.realms;

import cn.smarthse.fwgj.bootstrap.security.service.TokenService;
import cn.smarthse.fwgj.bootstrap.security.token.PasswordToken;
import cn.smarthse.fwgj.bootstrap.security.token.ShiroPrincipal;
import cn.smarthse.fwgj.entity.sys.ThirdGjUser;
import cn.smarthse.fwgj.enums.ThirdGjUserLogForbiddenStateEnum;
import cn.smarthse.fwgj.framework.Constant;
import cn.smarthse.fwgj.model.vo.admin.GjOrgListAdminVo;
import java.util.List;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.lang.util.ByteSource;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.CollectionUtils;

public class PasswordRealm
extends AuthorizingRealm {
    private static final Logger log = LoggerFactory.getLogger(PasswordRealm.class);
    @Autowired
    @Lazy
    private TokenService tokenService;

    public boolean supports(AuthenticationToken token) {
        return token instanceof UsernamePasswordToken;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        PasswordToken token = (PasswordToken)authenticationToken;
        log.debug("{} - password auth start...", (Object)token.getUsername());
        ThirdGjUser user = this.tokenService.getByUsername(token.getUsername());
        if (user == null) {
            user = this.tokenService.getByIdcard(token.getUsername());
        }
        if (user == null) {
            user = this.tokenService.getByMobile(token.getUsername());
        }
        if (user == null) {
            throw new UnknownAccountException("\u8d26\u53f7\u4e0d\u5b58\u5728\uff01");
        }
        if (user.getIsForbidden() == Constant.ACTIVE_YES) {
            throw new DisabledAccountException("\u8d26\u53f7\u88ab\u7981\u7528\uff01");
        }
        List<GjOrgListAdminVo> gjOrgList = this.tokenService.getGjOrgList(user.getId());
        if (CollectionUtils.isEmpty(gjOrgList) || gjOrgList.stream().noneMatch(record -> ThirdGjUserLogForbiddenStateEnum.PASS.getValue().equals(record.getForbiddenState()))) {
            throw new DisabledAccountException("\u8d26\u53f7\u88ab\u7981\u7528\uff01");
        }
        String credentials = user.getPassword();
        String realmName = super.getName();
        ByteSource credentialsSalt = ByteSource.Util.bytes((String)user.getSalt());
        ShiroPrincipal principal = new ShiroPrincipal(user);
        this.tokenService.initDefaultOrgId(principal, gjOrgList);
        return new SimpleAuthenticationInfo((Object)principal, (Object)credentials, credentialsSalt, realmName);
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        return null;
    }
}

