/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.bootstrap.security.filter;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.framework.core.utils.ServletUtils;
import cn.smarthse.fwgj.bootstrap.properties.SysProperties;
import cn.smarthse.fwgj.framework.Constant;
import cn.smarthse.fwgj.framework.utils.JwtUtil;
import com.alibaba.fastjson2.JSON;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.BearerToken;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.web.filter.authc.BasicHttpAuthenticationFilter;

public class JwtFilter
extends BasicHttpAuthenticationFilter {
    private final SysProperties sysProperties;

    public JwtFilter(SysProperties sysProperties) {
        this.sysProperties = sysProperties;
    }

    protected boolean isLoginAttempt(ServletRequest request, ServletResponse response) {
        return StrUtil.isNotEmpty((CharSequence)this.getAuthorization((HttpServletRequest)request));
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) {
        this.returnErr((ResponseData<Object>)new ResponseData(ResponseStateEnum.UNAUTHORIZED.getValue(), "\u767b\u5f55\u5931\u6548\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u767b\u5f55\uff01"), response);
        return false;
    }

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        if (this.isLoginAttempt(request, response)) {
            return this.executeLogin(request, response);
        }
        return false;
    }

    protected boolean executeLogin(ServletRequest request, ServletResponse response) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String token = httpServletRequest.getHeader(Constant.TOKEN_HEADER_NAME);
        if (JwtUtil.isTokenExpired(token).booleanValue()) {
            this.returnErr((ResponseData<Object>)new ResponseData(ResponseStateEnum.UNAUTHORIZED.getValue(), "\u767b\u5f55\u5931\u6548\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u767b\u5f55\uff01"), response);
            return false;
        }
        if (!JwtUtil.verify(token, this.sysProperties.getLogin().getSecret(), this.sysProperties.getLogin().getAudience())) {
            this.returnErr((ResponseData<Object>)new ResponseData(ResponseStateEnum.UNAUTHORIZED.getValue(), "\u975e\u6cd5\u7b7e\u540d\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u767b\u5f55\uff01"), response);
            return false;
        }
        BearerToken bearerToken = new BearerToken(token);
        try {
            this.getSubject(request, response).login((AuthenticationToken)bearerToken);
        }
        catch (IncorrectCredentialsException e) {
            this.returnErr((ResponseData<Object>)new ResponseData(ResponseStateEnum.UNAUTHORIZED.getValue(), "\u767b\u5f55\u5931\u6548\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u767b\u5f55\uff01"), response);
            return false;
        }
        catch (DisabledAccountException e) {
            e.printStackTrace();
            this.returnErr((ResponseData<Object>)new ResponseData(ResponseStateEnum.UNAUTHORIZED.getValue(), "\u8d26\u53f7\u88ab\u7981\u7528\uff01"), response);
            return false;
        }
        catch (AuthenticationException e) {
            this.returnErr((ResponseData<Object>)new ResponseData(ResponseStateEnum.UNAUTHORIZED.getValue(), "\u8ba4\u8bc1\u5931\u8d25\uff0c\u8bf7\u5c1d\u8bd5\u91cd\u65b0\u767b\u5f55\uff01"), response);
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.returnErr((ResponseData<Object>)new ResponseData(ResponseStateEnum.INTERNAL_SERVER_ERROR.getValue(), "500\u670d\u52a1\u5668\u51fa\u9519"), response);
            return false;
        }
        return true;
    }

    private String getAuthorization(HttpServletRequest httpRequest) {
        String authorization = httpRequest.getHeader(Constant.TOKEN_HEADER_NAME);
        if (StrUtil.isEmpty((CharSequence)authorization)) {
            authorization = httpRequest.getParameter(Constant.TOKEN_HEADER_NAME);
        }
        return authorization;
    }

    private void returnErr(ResponseData<Object> data, ServletResponse response) {
        ServletUtils.renderString((HttpServletResponse)((HttpServletResponse)response), (String)JSON.toJSONString(data));
    }
}

