/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.fwgj.bootstrap;

import cn.smarthse.fwgj.bootstrap.properties.EmailProperties;
import cn.smarthse.fwgj.bootstrap.properties.OssClientProperties;
import cn.smarthse.fwgj.bootstrap.properties.SysProperties;
import cn.smarthse.fwgj.framework.bean.OssClientBean;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.mail.javamail.JavaMailSenderImpl;

@Configuration
@ComponentScan(value={"cn.smarthse.fwgj", "cn.smarthse.framework.core", "cn.smarthse.framework.doc", "cn.smarthse.framework.dubbo3", "cn.smarthse.framework.encrypt", "cn.smarthse.framework.json", "cn.smarthse.framework.mybatisPlus", "cn.smarthse.framework.redis", "cn.smarthse.framework.web"})
@EnableConfigurationProperties(value={OssClientProperties.class, EmailProperties.class, SysProperties.class})
public class ContentConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ContentConfiguration.class);
    private final OssClientProperties ossClientProperties;
    private final EmailProperties emailProperties;

    @Bean(name={"ossClient"})
    public OssClientBean getOssClientBean() {
        log.info("\u914d\u7f6eOssClientBean {}", (Object)this.ossClientProperties.getOss_bucketname());
        OssClientBean ossClientBean = new OssClientBean();
        ossClientBean.setLocal(this.ossClientProperties.getOss_local());
        ossClientBean.setDomain(this.ossClientProperties.getDomain());
        ossClientBean.setEndpoint(this.ossClientProperties.getOss_endpoint());
        ossClientBean.setAccessKeyId(this.ossClientProperties.getOss_accesskey());
        ossClientBean.setAccessKeySecret(this.ossClientProperties.getOss_accesssecret());
        ossClientBean.setBucketName(this.ossClientProperties.getOss_bucketname());
        ossClientBean.setAsynch(this.ossClientProperties.isOss_asynch());
        ossClientBean.setPublicread(this.ossClientProperties.isPublicread());
        ossClientBean.setExptime(this.ossClientProperties.getExptime());
        return ossClientBean;
    }

    @Bean(value={"emailTemplate"})
    public JavaMailSenderImpl getJavaMailSenderImpl() {
        log.info("\u914d\u7f6e JavaMailSenderImpl {}", (Object)this.emailProperties);
        JavaMailSenderImpl emailTemplate = new JavaMailSenderImpl();
        emailTemplate.setDefaultEncoding(this.emailProperties.getDefault_encoding());
        emailTemplate.setHost(this.emailProperties.getHost());
        emailTemplate.setPort(this.emailProperties.getPort());
        emailTemplate.setUsername(this.emailProperties.getUsername());
        emailTemplate.setPassword(this.emailProperties.getPassword());
        Properties javaMailProperties = new Properties();
        javaMailProperties.setProperty("mail.smtp.auth", "true");
        javaMailProperties.setProperty("mail.smtp.timeout", "25000");
        javaMailProperties.put("mail.smtp.starttls.enable", (Object)true);
        javaMailProperties.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        emailTemplate.setJavaMailProperties(javaMailProperties);
        return emailTemplate;
    }

    public ContentConfiguration(OssClientProperties ossClientProperties, EmailProperties emailProperties) {
        this.ossClientProperties = ossClientProperties;
        this.emailProperties = emailProperties;
    }
}

