package cn.smarthse.fwgj.syn.service;


import cn.smarthse.fwgj.entity.thirdGj.ThirdGjCheckItem;
import cn.smarthse.fwgj.syn.param.SynGjCheckAddParam;

/**
 * 服务管家数据交换接口：检测数据
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2023/11/13 14:29
 */
public interface ISynGjCheckService {
    /**
     * 添加巡查数据
     * @param param 数据包
     * @return {@link Long} 返回巡查id
     * @author liaoly(廖凌云) [1302013247@qq.com]
     * @date 2023/11/13 14:35
     */
    Long addCheckInfo(SynGjCheckAddParam param);
    /**
     * 查询 服务管家巡查项参考数据
     * @param cid 单位id
     * @return {@link ThirdGjCheckItem}
     * @author liaoly(廖凌云) [1302013247@qq.com]
     * @date 2023/11/17 10:01
     */
    ThirdGjCheckItem getItemReferenceData(Long cid);
    /**
     * 更新 服务管家巡查项参考数据
     * @param referenceData 参考数据项
     * @author liaoly(廖凌云) [1302013247@qq.com]
     * @date 2023/11/17 10:03
     */
    void updateReferenceData(ThirdGjCheckItem referenceData);
}
