
package cn.smarthse.fwgj.syn.param;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import javax.validation.constraints.NotNull;
import lombok.Data;


/**
* 服务检查记录
* 
* @author chuhy
* @since 2023-06-27 03:16
*/
@Data
public class CheckItemParam implements Serializable {

	private static final long serialVersionUID = -2894292921451526110L;
	
	/**
	 * 1.职业病防治年度计划方案（0-否；1-是；2-合理缺项）
	 */
	@ApiModelProperty(value = "1.职业病防治年度计划方案（0-否；1-是；2-合理缺项）", example = "0", required = true)
	@NotNull
	private Integer check1;
	
	/**
	 * 2.管理制度及操作规程
	 */
	@ApiModelProperty(value = "2.管理制度及操作规程（0-否；1-是）", example = "0", required = true)
	@NotNull
	private Integer check2;
	
	/**
	 * 3.有害作业和无害作业分开
	 */
	@ApiModelProperty(value = "3.有害作业和无害作业分开（0-否；1-是）", example = "0", required = true)
	@NotNull
	private Integer check3;
	
	/**
	 * 4.职业病危害因素定期检测
	 */
	@ApiModelProperty(value = "4.职业病危害因素定期检测（0-否；1-是）", example = "1", required = true)
	@NotNull
	private Integer check4;
	
	/**
	 * 5.职业病危害现状评价
	 */
	@ApiModelProperty(value = "5.职业病危害现状评价（0-否；1-是；2-合理缺项）", example = "0", required = true)
	@NotNull
	private Integer check5;
	
	/**
	 * 6.职业健康体检
	 */
	@ApiModelProperty(value = "6.职业健康体检（0-否；1-是）", example = "1", required = true)
	@NotNull
	private Integer check6;
	
	/**
	 * 7.体检结果书面告知
	 */
	@ApiModelProperty(value = "7.体检结果书面告知（0-否；1-是）", example = "1", required = true)
	@NotNull
	private Integer check7;
	
	/**
	 * 8.职业禁忌证调岗
	 */
	@ApiModelProperty(value = "8.职业禁忌证调岗（0-否；1-是；2-合理缺项）", example = "1", required = true)
	@NotNull
	private Integer check8;
	
	/**
	 * 9.疑似职业病的报告和诊断
	 */
	@ApiModelProperty(value = "9.疑似职业病的报告和诊断（0-否；1-是；2-合理缺项）", example = "1", required = true)
	@NotNull
	private Integer check9;
	
	/**
	 * 10.职业病防治公告栏
	 */
	@ApiModelProperty(value = "10.职业病防治公告栏（0-否；1-是）", example = "1", required = true)
	@NotNull
	private Integer check10;
	
	/**
	 * 11.职业病危害警示标识与告知卡设置
	 */
	@ApiModelProperty(value = "11.职业病危害警示标识与告知卡设置（0-否；1-是）", example = "1", required = true)
	@NotNull
	private Integer check11;
	
	/**
	 * 12.职业病危害项目申报
	 */
	@ApiModelProperty(value = "12.职业病危害项目申报（0-否；1-是）", example = "1", required = true)
	@NotNull
	private Integer check12;
	
	/**
	 * 13.职业病危害劳动合同告知
	 */
	@ApiModelProperty(value = "13.职业病危害劳动合同告知（0-否；1-是）", example = "1", required = true)
	@NotNull
	private Integer check13;
	
	/**
	 * 14.主要负责人和职业健康管理员培训
	 */
	@ApiModelProperty(value = "14.主要负责人和职业健康管理员培训（0-否；1-是）", example = "1", required = true)
	@NotNull
	private Integer check14;
	
	/**
	 * 15.不得生产、经营、进口、使用国家明令禁止的设备和材料
	 */
	@ApiModelProperty(value = "15.不得生产、经营、进口、使用国家明令禁止的设备和材料（0-否；1-是）", example = "1", required = true)
	@NotNull
	private Integer check15;
	
	/**
	 * 16.职业病危害作业转移
	 */
	@ApiModelProperty(value = "16.职业病危害作业转移（0-否；1-是；2-合理缺项）", example = "1", required = true)
	@NotNull
	private Integer check16;
	
	/**
	 * 17.员工职业健康培训
	 */
	@ApiModelProperty(value = "17.员工职业健康培训（0-否；1-是）", example = "1", required = true)
	@NotNull
	private Integer check17;
	
	/**
	 * 18.防护设施配备和使用情况
	 */
	@ApiModelProperty(value = "18.防护设施配备和使用情况（0-否；1-是）", example = "1", required = true)
	@NotNull
	private Integer check18;
	
	/**
	 * 19.个人防护用品配置和使用情况
	 */
	@ApiModelProperty(value = "19.个人防护用品配置和使用情况（0-否；1-是）", example = "1", required = true)
	@NotNull
	private Integer check19;
	
	/**
	 * 20.建设项目职业病防护设施三同时
	 */
	@ApiModelProperty(value = "20.建设项目职业病防护设施三同时（0-否；1-是；2-合理缺项）", example = "1", required = true)
	@NotNull
	private Integer check20;
	
	/**
	 * 21.监管部门限期整改事项
	 */
	@ApiModelProperty(value = "21.监管部门限期整改事项（0-否；1-是；2-合理缺项）", example = "1", required = true)
	@NotNull
	private Integer check21;
	
	/**
	 * 22.建立职业卫生管理档案
	 */
	@ApiModelProperty(value = "22.建立职业卫生管理档案（0-否；1-是）", example = "1", required = true)
	@NotNull
	private Integer check22;
}
