package cn.smarthse.fwgj.syn.param;

import cn.smarthse.modules.health.vo.outdata.checkplan.FileParam;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Data;

/**
 *
 * 服务管家数据交换：巡查记录 添加
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2023/11/13 13:22
 */
@Data
public class CheckInfoParam implements Serializable {

    private static final long serialVersionUID = -1843519359121425650L;

    /**
     * 机构id
     */
    @ApiModelProperty(value = "机构id", example = "2528238548339712")
    @NotNull
    private Long orgId;

    /**
     * 单位id
     */
    @ApiModelProperty(value = "单位id", example = "7")
    @NotNull
    private Long cid;

    /**
     * 服务名称
     */
    @ApiModelProperty(value = "服务名称", example = "", required = true)
    @NotEmpty
    private String checkName;

    /**
     * 服务人
     */
    @ApiModelProperty(value = "服务人", required = true)
    @NotEmpty
    private String checkPeople;

    /**
     * 服务检查时间
     */
    @ApiModelProperty(value = "服务检查时间", example = "2023-11-20T13:55:58", required = true)
    @NotNull
    private Date checkTime;

    @ApiModelProperty(value = "巡查痕迹附件", notes = "集合", required = true)
    @NotEmpty
    private List<FileParam> checkFileList;

    /**
     * 企业负责人签字
     */
    @ApiModelProperty(value = "企业负责人签字", required = true)
    @NotNull
    private FileParam unitManageSign;

    /**
     * 服务中止类型(0-无；1-企业暂停；2-企业关闭；31-区域变更(跨地市迁移)； 32-区域变更(地市内迁移)；4-企业恢复(正常营业))
     */
    @ApiModelProperty(value="服务中止类型(0-无；1-企业暂停；2-企业关闭；31-区域变更(跨地市迁移)； 32-区域变更(地市内迁移)；4-企业恢复(正常营业))", example = "0", required = true)
    @NotNull
    private Integer stopType;

    @ApiModelProperty(value="来源(appId)", hidden = true)
    private String source;

    @ApiModelProperty(value = "来源数据id（唯一标识服务管家巡查记录id）", required = true)
    @NotNull
    private String sourceId;
}
