package cn.smarthse.fwgj.provider.third;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.fwgj.entity.sys.ThirdGjUser;
import cn.smarthse.fwgj.entity.sys.ThirdGjUserLog;
import cn.smarthse.fwgj.model.param.company.GjOrjSearchParam;
import cn.smarthse.fwgj.model.param.third.GjOrgParamParam;
import cn.smarthse.fwgj.model.param.third.GjOrgSummitParam;
import cn.smarthse.fwgj.model.param.third.GjUserAddParam;
import cn.smarthse.fwgj.model.param.third.GjUserQueryParam;
import cn.smarthse.fwgj.model.vo.admin.GjOrgServiceAreaStatisticsVo;
import cn.smarthse.fwgj.model.vo.company.CompanyGjOrjListVo;
import cn.smarthse.fwgj.model.vo.third.*;
import java.util.List;

/**
 *
 * 机构管家备案 dubbo 接口
 *
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2023/6/29 16:51
 */
public interface IThirdGjOrgProviderService {

    /**
     * 查询管家备案列表 （分页）
     * @param param 分页查询参数
     * @return {@link JqGridData<GjOrgListVo>}
     * @author liaoly
     * @date 2023/6/29 17:06
     */
    JqGridData<GjOrgListVo> getGjOrgListData(GjOrgParamParam param);

    /**
     * 查询管家备案 详情
     * @param gjOrgId 管家备案申请id
     * @return {@link GjOrgVo}
     * @author liaoly
     * @date 2023/6/30 17:28
     */
    GjOrgVo getGjOrg(Long gjOrgId);

    /**
     * 机构：备案时查询最近一次的备案信息
     * @param orgId 机构id
     * @return {@link GjOrgVo} 返回最近一次的备案信息
     * @author liaoly
     * @date 2023/9/12 8:40
     */
    GjOrgVo getLastGjOrg(Long orgId);
    /**
     * 是否存在备案
     * @param orgId 机构id
     * @return {@link boolean} 存在备案返回true，反之返回false
     * @author liaoly
     * @date 2023/9/12 9:10
     */
    boolean isExistsGjOrg(Long orgId);

    /**
     * 查询机构的管家账号列表
     * @param orgId 机构id
     * @return {@link List<ThirdGjUserVo>}
     * @author liaoly
     * @date 2023/6/30 11:06
     */
    List<ThirdGjUserVo> getGjUserList(Long orgId);

    /**
     * 查询机构的管家账号列表 （分页）
     * @param param 查询参数
     * @return {@link JqGridData<ThirdGjUserVo>}
     * @author liaoly
     * @date 2023/6/30 18:51
     */
    JqGridData<ThirdGjUserVo> getGjUserListData(GjUserQueryParam param);
    /**
     * 管家账号-详情
     * @param gjUserLogId 管家账号LogId
     * @return {@link GjOrgUserVo}
     * @author liaoly
     * @date 2023/7/3 13:54
     */
    GjOrgUserVo getGjUser(Long gjUserLogId);
    /**
     * 管家账号-详情
     * @param gjUserLogId 管家账号LogId
     * @return {@link GjOrgUserVo}
     * @author liaoly
     * @date 2023/7/3 13:54
     */
    ThirdGjUserLog getGjUserLog(Long gjUserLogId);
    /**
     * 校验gjUserLogId、orgId是否匹配 （匹配则机构端能操作、反之不能操作）
     * @param gjUserLogId
     * @param orgId
     * @return {@link boolean} （匹配则机构端能操作返回true、反之不能操作返回false）
     * @author liaoly
     * @date 2023/7/3 9:41
     */
    boolean checkGjUserLog(Long gjUserLogId, Long orgId);
    /**
     * 校验gjUserLogId、orgId是否匹配 （都匹配则机构端能操作、反之不能操作）
     * @param gjUserLogIdList
     * @param orgId
     * @return {@link boolean} （都匹配则机构端能操作返回true、反之不能操作返回false）
     * @author liaoly
     * @date 2023/7/3 9:41
     */
    boolean checkGjUserLog(List<Long> gjUserLogIdList, Long orgId);
    /**
     * 校验gjUserId、orgId是否匹配 （匹配则机构端能操作、反之不能操作）
     * @param gjUserId
     * @param orgId
     * @return {@link boolean} （匹配则机构端能操作返回true、反之不能操作返回false）
     * @author liaoly
     * @date 2023/7/3 9:41
     */
    boolean checkGjUser(Long gjUserId, Long orgId);
    /**
     * 机构: 管家申请 管家备案提交 (添加)
     * @param param
     * @return Long 返回gjOrgId
     * @author liaoly
     * @date 2023/7/5 8:43
     */
    Long addSubmitGjOrg(GjOrgSummitParam param);
    /**
     * 机构: 管家申请 管家备案提交 (更新)
     * @param param
     * @author liaoly
     * @date 2023/7/5 8:43
     */
    void updateSubmitGjOrg(GjOrgSummitParam param);
    /**
     * 机构添加管家账号
     * @param param  参数
     * @author liaoly
     * @date 2023/6/30 11:33
     */
    void addGjUser(GjUserAddParam param);
    /**
     * 机构编辑管家账号
     * @param thirdGjUser 管家账号
     * @author liaoly
     * @date 2023/6/30 14:16
     */
    void updateGjUser(ThirdGjUser thirdGjUser);
    /**
     * 机构导入管家账号
     * @param list excel解析的内容
     * @return {@link List<String>} 校验不通过的话，反复错误信息
     * @author liaoly
     * @date 2023/7/5 10:53
     */
    List<String> importGjUser(List<GjUserAddParam> list);
    /**
     * 编辑 并 提交管家账号审核
     * @param thirdGjUser
     * @author liaoly
     * @date 2023/7/20 15:56
     */
    void submitGjUser(ThirdGjUser thirdGjUser);
    /**
     * 机构: 管家账号 更新状态
     * @param gjUserlogId 管家账号log id
     * @param forbiddenState 禁用启用状态（0-禁用；1-启用待审核；2-启用；3-启用被退回）ThirdGjUserLogForbiddenStateEnum
     * @author liaoly
     * @date 2023/7/3 9:15
     */
    void updateForbiddenState(Long gjUserlogId, Integer forbiddenState);
    /**
     * 机构: 管家账号 更新状态 （批量）
     * @param gjUserlogIdList 管家账号log id
     * @param forbiddenState 禁用启用状态（0-禁用；1-启用待审核；2-启用；3-启用被退回）ThirdGjUserLogForbiddenStateEnum
     * @author liaoly
     * @date 2023/7/3 9:15
     */
    void updateForbiddenState(List<Long> gjUserlogIdList, Integer forbiddenState);

    /**
     * 机构: 管家账号 更新状态
     * @param gjUserlogId 管家账号log id
     * @param state 管家账号状态 管家账号状态（0-草稿；1-待审核；2-已通过；3-被退回；4-终止审核） ThirdGjUserLogStateEnums
     * @author liaoly
     * @date 2023/7/3 9:15
     */
    void updateState(Long gjUserlogId, Integer state);
    /**
     * 按状态统计管家账号数量
     * @param orgId 机构id
     * @return {@link GjUserStateStatistics}
     * @author liaoly
     * @date 2023/7/12 9:25
     */
    GjUserStateStatistics getGjUserStateStatistics(Long orgId);

    /**
     * 按禁用状态统计管家账号数量
     * @param orgId 机构id
     * @return {@link GjUserForbiddenStateStatistics}
     * @author liaoly
     * @date 2023/7/12 9:25
     */
    GjUserForbiddenStateStatistics getGjUserForbiddenStateStatistics(Long orgId);

    /**
     * 有哪些机构可以服务当前企业
     * @param param 企业行政区划
     * @return {@link null}
     * @author chuhy
     * @date 2023/7/14 18:23
     */
    JqGridData<CompanyGjOrjListVo> listOrjByCompanyAreaId(GjOrjSearchParam param);

    /**
     * 获取机构信息
     * @param orgId
     * @return {@link OrgInfoForSignVo}
     * @author chuhy
     * @date 2023/7/21 11:06
     */
    OrgInfoForSignVo getOrjInfoForSign(Long orgId);

    /**
     * 【机构端】获取机构的服务范围
     * @param orgId 机构id
     * @return {@link List< GjOrgServiceAreaStatisticsVo>}
     * @author chuhy
     * @date 2023/7/26 13:39
     */
    List<GjOrgServiceAreaStatisticsVo> getGjOrjCompanyAreaList(Long orgId);
    /**
     * 重置密码为 默认密码
     * @param gjUserId
     * @author liaoly
     * @date 2023/8/15 8:27
     */
    void resetPassword(Long gjUserId);
}
