package cn.smarthse.fwgj.provider.supervise.thirdGjUnitMange;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgAuditLog;
import cn.smarthse.fwgj.model.param.admin.*;
import cn.smarthse.fwgj.model.vo.admin.*;

import java.util.List;

/**
 * @Classname IOrgGjInfoAdminManageService
 * @Description 监管端-辖区企业清单
 * @Date 2023/6/29 14:08
 * @Author chenliang
 */
public interface IOrgUnitAdminManageServiceProvider {

    /**
     * @description: 辖区企业清单列表
     * @author: chenliang
     * @date: 2023/7/6 13:08
     * @param param
     * @return: {@link List<  UnitServiceAreaStatisticsAdminVo >}
     */
    List<UnitServiceAreaStatisticsAdminVo> getUnitServiceAreaStatisticsList(UnitServcieAreaStatisticsListParam param);

    /**
     * @description: 辖区企业清单合计
     * @author: chenliang
     * @date: 2023/7/6 13:26
     * @param param
     * @return: {@link UnitServiceAreaStatisticsAdminVo}
     */
    UnitServiceAreaStatisticsAdminVo getUnitServiceAreaStatisticsTotal(UnitServcieAreaStatisticsTotalParam param);

    /**
     * @description: 辖区企业清单-已签约企业列表企业列表
     * @author: chenliang
     * @date: 2023/7/7 13:31
     * @param param
     * @return: {@link JqGridData<JurisdictionalUnitListAdminVo>}
     */
    JqGridData<JurisdictionalUnitListAdminVo> getJurisdictionalUnitList(JurisdictionalUnitListParam param);

    /**
     * 辖区曾经签约过企业
     * @author: chenliang
     * @date: 2023/12/14 10:21
     * @param param
     * @return: {@link JqGridData< JurisdictionalUnitListAdminVo>}
     */
    JqGridData<JurisdictionalUnitListAdminVo> getHasOnceSignedUnitList(JurisdictionalUnitListParam param);

    /**
     * @description: 辖区企业清单-辖区签约申请企业列表
     * @author: chenliang
     * @date: 2023/7/7 14:51
     * @param param
     * @return: {@link JqGridData<JurisdictionalUnitListAdminVo>}
     */
    JqGridData<JurisdictionalUnitListAdminVo> getSigningApplicationUnitList(JurisdictionalUnitListParam param);

    /**
     * @description: 监管-辖区服务清单-单个企业统计
     * @author: chenliang
     * @date: 2023/7/15 9:15
     * @param param
     * @return: {@link OnUnitServiceStatisticsAdminVo}
     */
    OnUnitServiceStatisticsAdminVo getOneUnitServiceStatistics(OnUnitServiceStatisticsParam param);

    /**
     * @description: 单个公司的服务记录
     * @author: chenliang
     * @date: 2023/7/15 14:13
     * @param param
     * @return: {@link List<OneUnitServiceRecordListAdminVo>}
     */
    List<OneUnitServiceRecordListAdminVo> getServiceRecordList(OneUnitServiceRecordListParam param);

    /**
     * @description: 公司服务记录年份列表
     * @author: chenliang
     * @date: 2023/7/20 13:50
     * @param cid
     * @return: {@link List< Long>}
     */
    List<Long> getCheckInfoYears(Long cid);

    /**
     * @description: 辖区企业清单-辖区解约申请企业列表
     * @author: chenliang
     * @date: 2023/7/7 14:58
     * @param param
     * @return: {@link JqGridData<JurisdictionalUnitListAdminVo>}
     */
    JqGridData<JurisdictionalUnitListAdminVo> getTerminationApplicationUnitList(JurisdictionalUnitListParam param);

    /**
     * @description: 监管-辖区企业清单-tab统计
     * @author: chenliang
     * @date: 2023/7/18 16:31
     * @param param
     * @return: {@link JurisdictionalUnitTabStatisticsAdminVo}
     */
    JurisdictionalUnitTabStatisticsAdminVo getJurisdictionalUnitTabStatistics(JurisdictionalUnitListParam param);

    /**
     * 服务记录监管认定
     * @author: chenliang
     * @date: 2023/10/23 16:12
     * @param param
     * @return:
     */
    void identify(UnitServiceIdentificationParam param);

    /**
     * 监管认定记录
     * @author: chenliang
     * @date: 2023/10/23 16:39
     * @param param
     * @return: {@link JqGridData<ThirdGjOrgAuditLog>}
     */
    JqGridData<ThirdGjOrgAuditLog> getIdentificationRecord(UnitServiceIdentificationParam param);

}
