
package cn.smarthse.fwgj.provider.supervise.thirdGjOrgManage;


import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrg;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgAuditLog;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgCustomer;
import cn.smarthse.fwgj.model.param.admin.*;
import cn.smarthse.fwgj.model.param.third.GjOrgCompanyQueryParam;
import cn.smarthse.fwgj.model.vo.admin.*;
import cn.smarthse.fwgj.model.vo.third.GjOrgCompanyListVo;
import cn.smarthse.fwgj.model.vo.third.GjOrgCustomerVo;

import java.util.List;

/**
 * 管家服务机构信息管理 接口类
 *
 * @author wuxq
 * @date 2023/6/29 09:34
 */
public interface IThirdGjOrgManageServiceProvider {

    /**
     * 方法描述:  管家机构信息列表
     *
     * @param param 参数
     * @return PageInfo<GjOrgInfoVo>
     * @author wuxq
     * @date 2023/6/29
     */
    JqGridData<GjOrgInfoVo> getFwgjInfoListPageData(GjOrgInfoManageListParam param);

    /**
     * 方法描述:  机构管家服务工作统计
     *
     * @param   orgId 机构id
     * @param   areaId 区域id
     * @param   areaLevel 区域等级
     * @return  GjOrgServiceStatisticsVo
     * @author  wuxq
     * @date    2023/7/5
     */
    GjOrgServiceStatisticsVo getGjOrgServiceStatisticsData(Long orgId, Long areaId, Integer areaLevel);

    /**
     * 方法描述:  机构管家备案审核详情
     *
     * @param   gjOrgCustomerId 签约id
     * @return  ThirdGjOrgCustomer
     * @author  wuxq
     * @date    2023/7/5
     */
    GjOrgCustomerVo getOrgSignCompAuditDetail(Long gjOrgCustomerId);

    /**
     * 方法描述:  是否有签约审核权限
     *
     * @param   orgId 机构id
     * @param   areaId 监管账号区域
     * @param   areaLevel 监管账号区域等级
     * @return  Boolean
     * @author  wuxq
     * @date    2023/7/20
     */
    Boolean hasOrgSignCompAuditPermit(Long orgId, Long areaId, Integer areaLevel);

    /**
     * 方法描述:  管家机构签约/解约企业审核
     *
     * @param   param 审核参数
     * @return  void
     * @author  wuxq
     * @date    2023/7/5
     */
    void orgSignCompAudit(GjOrgSignCompAuditParam param);

    public void cancelSignByAdmin(Long gjOrgCustomerId, String optPeople);

    /**
     * 方法描述:  【监管】根据机构id查询机构与辖区内所有企业历次 签约或者解约成功的记录
     *
     * @param   type 2-签约记录；3-解约记录；
     * @param   orgId 机构id
     * @param   areaId 监管区域
     * @param   areaLevel 区域等级
     * @return  List<GjOrgSignCompHistoryVo>
     * @author  wuxq
     * @date    2023/7/6
     */
    JqGridData<GjOrgSignCompHistoryVo> getGjOrgSignAllCompLog(GjOrgSignCompLogParam param);

    /**
     * 方法描述:  根据机构id查询机构与某企业历次 签约或者解约成功的记录
     *
     * @param   type 2-签约记录；3-解约记录；
     * @param   orgId 机构id
     * @param   cid 企业id
     * @return  List<ThirdGjOrgAuditLog>
     * @author  wuxq
     * @date    2023/7/6
     */
    List<ThirdGjOrgAuditLog> getGjOrgSignOneCompLog(Integer type, Long orgId, Long cid);

    /**
     * 方法描述:  监管端查询当前辖区内的服务管家机构
     *
     * @param   areaId 行政区划
     * @param   areaLevel 等级
     * @param   keyword 关键词
     * @return  List<GjOrgInfoChooseVo>
     * @author  wuxq
     * @date    2023/7/10
     */
    List<GjOrgInfoChooseVo> getGjOrgInfoChooseVoList(Long orgId, Long areaId, Integer areaLevel, String keyword);

    /**
     * 方法描述: 监管端 - 服务企业列表
     *
     * @param param 查询参数
     * @return {@link JqGridData<  GjOrgCompanyListVo >}
     * @author chuhy
     * @date 2023/7/4 16:11
     */
    JqGridData<GjOrgCompanyListVo> getGjOrgCompanyList(GjOrgCompanyQueryParam param);

    /**
     * 方法描述:  给管家机构评分
     *
     * @param   param 参数对象
     * @return  Boolean
     * @author  wuxq
     * @date    2023/7/15
     */
    Boolean scoringForGjOrg(GjOrgScoringParam param);

    /**
     * 方法描述:  【监管端】禁用管家机构账号（取决监管账号区域，如西湖区监管账号只能禁用该机构西湖区域的服务范围）
     *
     * @param param 参数对象
     * @author  wuxq
     * @date    2023/7/6
     */
    void forbiddenGjOrg(ForbiddenGjOrgParam param);

    /**
     * 方法描述:  机构服务范围签约统计
     *
     * @param   loginUserAreaId 当前监管区域
     * @param   loginAreaLevel 当前监管区域等级
     * @param   orgId 机构id
     * @return  List<GjOrgServiceAreaStatisticsVo>
     * @author  wuxq
     * @date    2023/7/19
     */
    List<GjOrgServiceAreaStatisticsVo> getGjOrgServiceAreaStatisticsVoList(Long loginUserAreaId, Integer loginAreaLevel, Long orgId);

    /**
     * 方法描述: 查询当前监管区域下的机构备案信息
     *
     * @param   loginUserAreaId 当前账号区域
     * @param   loginAreaLevel 当前账号区域id
     * @param   orgId 机构id
     * @return  List<ThirdGjOrg>
     * @author  wuxq
     * @date    2023/7/20
     */
    List<ThirdGjOrg> getGjOrgList(Long loginUserAreaId, Integer loginAreaLevel, Long orgId);

    /**
     * 方法描述:  导入服务管家机构（系统中无账号则先注册，再备案申请该区域管家机构资质）
     *
     * @param   list 文件数据
     * @return  void
     * @author  wuxq
     * @date    2023/7/25
     */
    List<String> importGjOrg(List<GjOrgAddParam> list);

    /**
     * 方法描述:  管家机构添加企业清单-批量导入企业
     *
     * @param   list 导入数据
     * @return  List<String>
     * @author  wuxq
     * @date    2023/8/3
     */
    GjOrgCustomerLotDetailImportResultVo importGjOrgCustomerLotDetails(Long lotId, List<GjOrgCustomerLotDetailImportParam> list);

    /**
     * 方法描述:  查询管家机构详情
     *
     * @param   id ThirdGjOrg.id
     * @return  ThirdGjOrg
     * @author  wuxq
     * @date    2023/8/23
     */
    ThirdGjOrg getGjOrgById(Long id);

    /**
     * 方法描述:  辖区内备案已满六个月的管家机构数据
     *
     * @param   areaId 监管区域id
     * @param   areaLevel 监管区域等级
     * @return  List<ThirdGjOrg>
     * @author  wuxq
     * @since    2023/10/24
     */
    List<ThirdGjOrg> getOverSixMonthsGjOrgList(Long areaId, Integer areaLevel);

    /**
     * 方法描述:  监管导入本辖区管家机构评分
     *
     * @param   list 评分信息
     * @return  List<String>
     * @author  wuxq
     * @date    2023/10/24
     */
    List<String> importGjOrgScore(List<GjOrgScoreParam> list);
}
