package cn.smarthse.fwgj.provider.supervise.thirdGjMessage;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgMessageReceiverDetail;
import cn.smarthse.fwgj.model.param.admin.ThirdGjOrgMessageReceiveParam;
import cn.smarthse.fwgj.model.param.admin.ThirdGjOrgOneMessageParam;
import cn.smarthse.fwgj.model.vo.third.ThirdGjOrgMessageReceiverDetailVo;

import java.util.List;

public interface IOrgGjMessageServiceProvider {

    /**
     * 根据用户类型发送一条简单消息
     *
     * @param msg
     * @author ShenZQ
     * @since 2023/12/5 14:07
     */
    void sendOneMessageToByUserType(ThirdGjOrgOneMessageParam msg);

    void sendMoreMessageToByUserType(List<ThirdGjOrgOneMessageParam> msgList);

    /**
     * 监管接收消息
     *
     * @param param
     * @return {@link JqGridData<ThirdGjOrgMessageReceiverDetailVo>}
     * @author ShenZQ
     * @since 2023/12/6 10:06
     */
    JqGridData<ThirdGjOrgMessageReceiverDetailVo> receiveForSUP(ThirdGjOrgMessageReceiveParam param);

    /**
     * 机构接收消息，一个机构中 只要有用户收到过消息，该消息不再发给新用户
     *
     * @param param
     * @return {@link JqGridData<ThirdGjOrgMessageReceiverDetailVo>}
     * @author ShenZQ
     * @since 2023/12/6 14:51
     */
    JqGridData<ThirdGjOrgMessageReceiverDetailVo> receiveForORG(ThirdGjOrgMessageReceiveParam param);

    /**
     * 更改消息状态为已读
     *
     * @param id
     * @return {@code Boolean}
     * @author ShenZQ
     * @since 2023/12/6 10:06
     */
    Boolean changeMessageStateIsRead(Long id);

}
