package cn.smarthse.fwgj.provider.supervise.thirdGjManage;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgAuditLog;
import cn.smarthse.fwgj.model.param.admin.*;
import cn.smarthse.fwgj.model.vo.admin.*;

import java.util.List;

/**
 * @Classname IOrgGjInfoAdminManageService
 * @Description 监管端-服务管家人员信息
 * @Date 2023/6/29 14:08
 * @Author chenliang
 */
public interface IOrgGjInfoAdminManageServiceProvider {
    /**
     * @description: 监管-单个服务管家信息统计
     * @author: chenliang
     * @date: 2023/6/30 13:34
     * @param param
     * @return: {@link JqGridData< OrgGjListAdminVo>}
     */
    JqGridData<OrgGjListAdminVo> getOrgGJStatisticsListForAdmin(OrgGjStatisticsListParam param);

    /**
     * @description: 监管-单个服务管家信息统计
     * @author: chenliang
     * @date: 2023/6/30 13:34
     * @param param
     * @return: {@link OrgGjAdminVo}
     */
    OrgGjAdminVo getOneOrgGJInfoStatisticsForAdmin(OrgGjStatisticsParam param);

    /**
     * @description: 监管-某个管家在某个机构的企业服务清单
     * @author: chenliang
     * @date: 2023/6/30 15:55
     * @param param
     * @return: {@link JqGridData< OrgGjServiceListAdminVo >}
     */
    JqGridData<OrgGjServiceListAdminVo> getGjServiceListForAdmin(OrgGjServiceListParam param);

    /**
     * @description: 获取历史服务清单年份列表
     * @author: chenliang
     * @date: 2023/7/14 13:22
     * @param param
     * @return: {@link List< Integer>}
     */
    List<Integer> getGjServiceYearList(GjServiceYearListParam param);

    /**
     * @description: 服务管家机构信息下拉列表
     * @author: chenliang
     * @date: 2023/7/11 10:41
     * @param param
     * @return: {@link List< GjOrgListAdminVo>}
     */
    List<GjOrgListAdminVo> getGjOrgSelectListForAdmin(GjOrgListAdminParam param);

    /**
     * @description: 服务管家与机构签约的操作列表
     * @author: chenliang
     * @date: 2023/7/11 10:47
     * @param param
     * @return: {@link List< GjOrgListAdminVo>}
     */
    List<GjOrgListAdminVo> getOrgOptListForAdmin(GjOrgListAdminParam param);

    /**
     * @description: 服务管家机构审核统计列表（新增审核、服务管家删除查看、服务管家启动审核）
     * @author: chenliang
     * @date: 2023/7/3 9:35
     * @param param
     * @return: {@link JqGridData< OrgAuditStatisticsListAdminVo>}
     */
    JqGridData<OrgAuditStatisticsListAdminVo> getOrgAuditList(OrgAuditListParam param);

    /**
     * @description: 服务管家机构审核统计列表-服务管家机构审核tab统计
     * @author: chenliang
     * @date: 2023/7/18 9:13
     * @param param
     * @return: {@link List< OrgAuditTabStatisticsAdminVo>}
     */
    List<OrgAuditTabStatisticsAdminVo> getOrgAuditTabStatistics(OrgAuditTabStatisticsParam param);

    /**
     * @description: 监管-服务管家新增审核-服务管家信息审核列表
     * @author: chenliang
     * @date: 2023/7/3 13:29
     * @param param
     * @return: {@link JqGridData< OrgGjAuditListAdminVo>}
     */
    JqGridData<OrgGjAuditListAdminVo> getOrgGjAddedInfoAuditListForAdmin(OrgGjAddedInfoAuditListParam param);

    /**
     * @description: 监管-服务管家新增审tab统计
     * @author: chenliang
     * @date: 2023/7/18 10:11
     * @param param
     * @return: {@link List< OrgGjAddedAuditTabStatisticsAdminVo>}
     */
    List<OrgGjAddedAuditTabStatisticsAdminVo> getOrgGjAddedAuditTabStatistics(OrgGjAddedAuditTabStatisticsParam param);

    /**
     * @description: 监管-服务管家信息审核列表-新增审核
     * @author: chenliang
     * @date: 2023/7/3 15:11
     * @param param
     * @return:
     */
    void auditAddedInfoReview(AddedInfoReviewBatchParam param);

    /**
     * @description: 监管-服务管家信息列表-启用禁用管家与服务机构签约关系
     * @author: chenliang
     * @date: 2023/7/4 8:54
     * @param param
     * @return:
     */
    void changeSigningStatus(ChangeSigningStatusParam param);

    /**
     * @description: 监管-服务管家信息禁用列表
     * @author: chenliang
     * @date: 2023/7/4 15:15
     * @param param
     * @return: {@link JqGridData< OrgGjForbiddenListAdminVo>}
     */
    JqGridData<OrgGjForbiddenListAdminVo> getOrgGjForbiddenListForAdmin(OrgGjForbiddenListParam param);

    /**
     * @description: 监管-服务管家禁用启用后待审核列表
     * @author: chenliang
     * @date: 2023/7/4 16:07
     * @param param
     * @return: {@link JqGridData< OrgGjAuditAgainListAdminVo>}
     */
    JqGridData<OrgGjAuditAgainListAdminVo> getOrgGjAuditAgainList(OrgGjAuditAgainListParam param);

    /**
     * @description: 监管-服务管家信息启用待审核tab统计
     * @author: chenliang
     * @date: 2023/7/18 13:47
     * @param param
     * @return: {@link List< OrgGjAuditAgainTabStatisticsAdminVo>}
     */
    List<OrgGjAuditAgainTabStatisticsAdminVo> getOrgGjAuditAgainTabStatistics(OrgGjAuditAgainTabStatisticsParam param);

    /**
     * @description: 监管-服务管家信息审核列表-重新启用审核
     * @author: chenliang
     * @date: 2023/7/4 16:46
     * @param param
     * @return:
     */
    void auditRestartInfo(AuditRestartInfoBatchParam param);

    /**
     * @description: 单个机构服务统计
     * @author: chenliang
     * @date: 2023/7/12 14:14
     * @param param
     * @return: {@link OneOrgStatisticsVo}
     */
    OneOrgStatisticsVo getOneOrgStatistics(OneOrgStatisticsParam param);

    /**
     * @description: -机构与服务管家雇佣的操作记录
     * @author: chenliang
     * @date: 2023/7/13 14:47
     * @param param
     * @return: {@link JqGridData< ThirdGjOrgAuditLog>}
     */
    JqGridData<ThirdGjOrgAuditLog> getGjAuditLogList(GjAuditLogListParam param);
}
