
package cn.smarthse.fwgj.model.vo.third;

import cn.smarthse.common.util.date.DateUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;

/**
 * 机构：管家-账号
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2023/6/20 13:34
 */
public @Data
class ThirdGjUserVo implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("gjUserId")
    private Long id;

    /**
     * 用户名
     */
    @ApiModelProperty("账号")
    private String username;
    /**
     * 用户姓名
     */
    @ApiModelProperty("用户姓名")
    private String fullname;
    /**
     * 手机号码
     */
    @ApiModelProperty("手机号码")
    private String mobile;
    /**
     * 身份证
     */
    @ApiModelProperty("身份证")
    private String idcard;
    /**
     * 性别（男；女）
     */
    @ApiModelProperty("性别（男；女）")
    private String sex;
    /**
     * 出生日期
     */
    @ApiModelProperty("出生日期")
    private Date birthday;
    /**
     * 年龄
     */
    @ApiModelProperty("年龄")
    private Integer age;
    /**
     * 从业年限/年
     */
    @ApiModelProperty("从业年限/年")
    private Integer workYear;
    /**
     * 专业职称
     */
    @ApiModelProperty("专业职称")
    private String post;
    /**
     * 文化程度
     */
    @ApiModelProperty("文化程度")
    private String edu;
    /**
     * 头像文件编号（file.id)
     */
    @ApiModelProperty("头像文件编号（file.id)")
    private Long faceId;

    /**
     * 浙里办userId
     */
    private String zlbUserId;

    @ApiModelProperty("管家账号log id")
    private Long gjUserLogId;

    @ApiModelProperty("提交时间（最近一次）")
    private Date subTime;

    @ApiModelProperty("提交时间（最近一次）")
    private String subTimeStr;

    @ApiModelProperty("管家账号状态（0-草稿；1-待审核；2-已通过；3-被退回；4-终止审核）")
    private Integer state;

    @ApiModelProperty("账号审核被退回原因（最新）")
    private String reason;

    @ApiModelProperty("禁用时间（最新）")
    private Date forbiddenDate;

    @ApiModelProperty("启用被退回原因（最新）")
    private String forbiddenReason;
    /**
     * 管家：管家账号 服务、风险统计
     */
    private GjUserStatisticsVo gjUserStatisticsVo;

    public Integer getAge() {
        if (this.birthday != null) {
            return (int) DateUtil.caculateYears(DateUtil.getFromDate2(this.birthday), LocalDate.now());
        }
        return 0;
    }

    public String getSubTimeStr() {
        if (this.subTime != null) {
            return DateUtil.format(this.subTime, "yyyy-MM-dd HH:mm:ss");
        }
        return "";
    }

}
