package cn.smarthse.fwgj.model.vo.third;

import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import lombok.Data;

/**
 * 管家：机构-企业签约详情 vo
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2023/7/11 14:01
 */
@Data
public class GjOrgCustomerVo implements Serializable {

    private static final long serialVersionUID = -4935149534125926985L;

    /**
     * 机构企业签约id
     */
    private Long id;
    /**
     * 签约单位id
     */
    private Long cid;
    /**
     * 机构id
     */
    private Long orgId;
    /**
     * 机构名称
     */
    private String orgName;
    /**
     * 机构统一社会信用代码
     */
    private String orgCreditCode;
    /**
     * 机构联系人
     */
    private String orgMan;
    /**
     * 机构联系电话
     */
    private String orgTel;
    /**
     * 机构法人
     */
    private String orgLegalName;
    /**
     * 机构法人联系电话
     */
    private String orgLegalTel;
    /**
     * 机构地址
     */
    private String orgAddress;

    /**
     * 签约企业名称
     */
    private String unitName;
    /**
     * 签约企业统一社会信用代码
     */
    private String unitCreditCode;
    /**
     * 企业联系人
     */
    private String unitMan;
    /**
     * 企业联系电话
     */
    private String unitTel;
    /**
     * 企业法人
     */
    private String unitLegalName;
    /**
     * 企业法人联系电话
     */
    private String unitLegalTel;
    /**
     * 企业行政区划
     */
    private Long areaId;
    /**
     * 企业地址
     */
    private String unitAddress;
    /**
     * 合同类型（1-签约；2-续约）
     */
    private Integer type;
    /**
     * 签约状态（1：签约待审核；2：已签约；3：签约被退回；4：解约待审核；5：已解约；6：解约被退回）
     */
    private Integer state;
    /**
     * 签约时间
     */
    private Date signTime;
    /**
     * 到期时间
     */
    private Date expireTime;
    /**
     * 解约理由
     */
    private String cancelReason;
    /**
     * 合同时间
     */
    private String contractDateStr;
    /**
     * 合同附件ids
     */
    private String contractFileId;
    /**
     * 直属企业类型（0-非直属，1-省直属，2-市属）来源数据中心
     */
    private Byte belongType;
    /**
     * 合同附件
     */
    private List<SysFileModel> contractFileList;

    public String getContractDateStr() {
        if (this.signTime != null && this.expireTime != null) {
            return DateUtil.format(this.signTime, "yyyy-MM-dd") + " 至 " + DateUtil.format(this.expireTime, "yyyy-MM-dd");
        }
        return "";
    }
}
