package cn.smarthse.fwgj.model.vo.third;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 机构：服务企业统计信息
 *
 * @author chuhy
 * @date 2023/7/4
 */
@Data
public class GjOrgCustomerStatisticVo implements Serializable {
    private static final long serialVersionUID = -331214418012896948L;

    /**
     * 企业id
     */
    private Long cid;

 
    /**
     * 签约单位名
     */
    private String unitName;
 
    /**
     * 单位地址
     */
    private String address;

    /**
     * 累计服务次数(统计流程已完成的检查记录次数)
     */
    private Integer checkedTotalNum;

    /**
     * 上半周期服务状态(0-未开始；1-进行中；2-已完成；3-未完成)
     */
    private Integer firstCheckStatus;

    /**
     * 下半周期服务状态(0-未开始；1-进行中；2-已完成；3-未完成)
     */
    private Integer secondCheckStatus;

    /**
     * 下半周期开始日期
     */
    private Date secondCheckStartDate;

    /**
     * 待验收风险清单数
     */
    private Integer unAcceptRiskNum;

    /**
     * 待整改风险清单数
     */
    private Integer unReformRiskNum;

    /**
     * 状态（1-签约待审核；2-已签约；3-签约被退回；4-解约待审核；5-已解约(未签约)；6-解约被退回）
     */
    private Integer state;

    /**
     * 签约企业-预警状态(0-无预警；1-含检查预警；2-含检查超期；3-超期与预警)
     */
    private Integer warningStatus;

    /**
     * 剩余签约天数(到期天数)
     */
    private Integer expirationDays;
    /**
     * 可以取消签约的合同数量 state in 0-待生效<续约>；2-已签约(签约中) ，多个合同的话，前端需要弹框展示
     */
    private Integer canCancelCustomerNum;
    /**
     * 校验是否能和指定企业续约 能续约true，反之false
     */
    private Boolean checkContinueGjOrgCustomer = false;
}
