package cn.smarthse.fwgj.model.vo.third;

import cn.smarthse.common.util.DateUtils;
import cn.smarthse.fwgj.enums.GjCustomerCheckStatusEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.http.annotation.Contract;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

/**
 * 机构-服务企业列表
 *
 * @author chuhy
 * @date 2023/7/4
 */
@Data
public class GjOrgCompanyListVo implements Serializable {
    private static final long serialVersionUID = -458366129618603630L;

    private Integer index;

    /**
     * 签约id
     */
    private Long customerId;

    /**
     * 续约id（有续约才有）
     */
    private Long renewalCustomerId;

    /**
     * 签约单位id
     */
    private Long cid;

    /**
     * 签约单位名称
     */
    private String unitName;

    /**
     * 签约单位社会统一信用代码
     */
    private String unitCreditCode;

    /**
     * 合同类型（1-签约；2-续约）
     */
    private Integer type;

    /**
     * 状态（0-待生效（续约）；1-签约待审核；2-已签约；3-签约被退回；4-解约待审核；5-已解约(未签约)；6-解约被退回）
     */
    private Integer state;
    // 续约状态
    private Integer renewalCustomerState;

    /**
     * 本周期服务检查次数
     */
    private Integer checkedNum;

    /**
     * 上半周期服务次数
     */
    private Integer firstCheckNum;

    /**
     * 下半周期服务次数
     */
    private Integer secondCheckNum;

    /**
     * 上半周期服务状态(0-未开始；1-进行中；2-已完成；3-未完成)
     */
    private Integer firstCheckStatus;

    /**
     * 下半周期服务状态(0-未开始；1-进行中；2-已完成；3-未完成)
     */
    private Integer secondCheckStatus;

    /**
     * 下半周期开始日期
     */
    private Date secondCheckStartDate;

    /**
     * 签约时间
     */
    private Date signTime;

    /**
     * 到期时间
     */
    private Date expireTime;

    /**
     * 当前合同周期(第几合约年)
     */
    private Integer curContractYear;

    /**
     * 当前半周期(1-上半周期；2-下半周期)
     */
    private Integer curCycle;

    /**
     * 当前周期开始时间
     */
    private Date curContractStartDate;

    /**
     * 当前周期截止时间
     */
    private Date curContractExpireDate;

    /**
     * 预警状态(0-无预警；1-含检查预警；2-含检查超期；3-超期与预警)
     */
    private Integer warningStatus;

    /**
     * 是否即将到期(0-否；1-是)
     */
    private Integer isNearDue;

    /**
     * 直属企业类型（0-非直属，1-省直属，2-市属）来源数据中心
     */
    private Integer belongType;

    /**
     * 是否在服务范围内(0-否；1-是)
     */
    private Integer isInRange;

    public Integer getCheckedNum() {
        if (firstCheckNum == null) {
            firstCheckNum = 0;
        }
        if (secondCheckNum == null) {
            secondCheckNum = 0;
        }

        return firstCheckNum + secondCheckNum;
    }

    public Integer getIsNearDue() {
        if (this.expireTime != null && this.state != null && "2,4,6".contains(this.state.toString())) {
            return DateUtils.isBefore(this.expireTime, DateUtils.addMonth(DateUtils.getStartTime(new Date()), 2)) ? 1 : 0;
        }
        return isNearDue;
    }

    /**
     * 获取下半周期开始时间
     * @return {@link java.util.Date}
     * @author chuhy
     * @date 2024/3/7 13:32
     */
    public Date getSecondCheckStartDate() {
        // 若当前处于下半周期，不返回下半周期开始时间
        if (curCycle == null || curCycle == 2){
            return null;
        }

        // 日期加一天
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(signTime);
        calendar.add(Calendar.YEAR, curContractYear - 1 );
        calendar.add(Calendar.MONTH, 6);
        calendar.add(Calendar.DATE, 1);

        return calendar.getTime();
    }

    // ====================================================== 导出字段 ===================================================
    /**
     * 所在行政区划
     */
    private String areaName;
    /**
     * 工作场所地址
     */
    private String unitAddress;
    /**
     * 企业主要负责人
     */
    private String unitMan;
    /**
     * 企业主要负责人电话
     */
    private String unitTel;
    /**
     * 当前服务管家（机构）名称
     */
    private String orgName;
    /**
     * 机构联系人
     */
    private String orgMan;
    /**
     * 机构联系人电话
     */
    private String orgTel;
    /**
     * 合同起止时间
     */
    private String contractTimeStr;
    /**
     * 当前周期时间
     */
    private String curCycleDateStr;
    /**
     * 上半周期服务状态(0-未开始；1-进行中；2-已完成；3-未完成)
     */
    private String firstCheckStatusStr;
    /**
     * 下半周期服务状态(0-未开始；1-进行中；2-已完成；3-未完成)
     */
    private String secondCheckStatusStr;

    public String getContractTimeStr() {
        if (this.signTime != null && this.expireTime != null) {
            return DateUtils.getDate(this.signTime) + "至" + DateUtils.getDate(this.expireTime);
        }
        return "";
    }

    public String getCurCycleDateStr() {
        if (this.curContractStartDate != null && this.curContractExpireDate != null) {
            return DateUtils.getDate(this.curContractStartDate) + "至" + DateUtils.getDate(this.curContractExpireDate);
        }
        return "";
    }

    public String getFirstCheckStatusStr() {
        if (this.firstCheckStatus != null) {
            return GjCustomerCheckStatusEnum.getName(this.firstCheckStatus);
        }
        return "";
    }

    public String getSecondCheckStatusStr() {
        if (this.secondCheckStatus != null) {
            return GjCustomerCheckStatusEnum.getName(this.secondCheckStatus);
        }
        return "";
    }
}
