package cn.smarthse.fwgj.model.vo.third;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 机构：服务检查统计信息
 *
 * @author chuhy
 * @date 2023/7/4
 */
@Data
public class GjOrgCheckStatisticVo implements Serializable {
    private static final long serialVersionUID = 4751010654832159715L;

 
    /**
     * 机构名
     */
    private String orgName;
 
    /**
     * 机构地址
     */
    private String address;
 
    /**
     * 服务范围区域 （多个用“,”隔开）只展示到区
     */
    private String serviceAreaName;
 
    /**
     * 服务管家人员数
     */
    private Integer gjUserNum;
 
    /**
     * 签约企业数
     */
    private Integer signedCompanyNum;

    /**
     * 检查超期企业数
     */
    private Integer overDueNum;

    /**
     * 需服务企业数
     */
    private Integer needCheckNum;
 
    /**
     * 合约即将到期企业数
     */
    private Integer nearDueNum;
 
    /**
     * 评分/星
     */
    private List<GjOrgScoreVo> scoreList;
    /**
     * 校验是否能和指定企业续约 能续约true，反之false
     */
    private Boolean checkContinueGjOrgCustomer = false;

    // /**
    //  * 完成两次检查企业数
    //  */
    // private Integer checkTwiceNum;
    //
    // /**
    //  * 完成一次检查企业数
    //  */
    // private Integer checkOnceNum;

}
