package cn.smarthse.fwgj.model.vo.company;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 服务企业统计信息
 *
 * @author chuhy
 * @date 2023/7/4
 */
@Data
public class CompanyCustomerStatisticVo implements Serializable {
    private static final long serialVersionUID = 3526991020543154665L;

    /**
     * 签约id
     */
    private Long customerId;

 
    /**
     * 单位名
     */
    private String unitName;
 
    /**
     * 单位地址
     */
    private String unitAddress;

    /**
     * 签约单位-社会统一信用代码
     */
    private String unitCreditCode;

    /**
     * 机构id
     */
    private Long orgId;

    /**
     * 机构账号id
     */
    private Long gjOrgId;

    /**
     * 机构名
     */
    private String orgName;

    /**
     * 机构-地址
     */
    private String orgAddress;

    /**
     * 机构-社会统一信用代码
     */
    private String orgCreditCode;

    /**
     * 当前机构的评分
     */
    private Integer score;

    /**
     * 签约企业-预警状态(0-无预警；1-含检查预警；2-含检查超期；3-超期与预警)
     */
    private Integer warningStatus;

    /**
     * 上半周期服务状态(0-未开始；1-进行中；2-已完成；3-未完成)
     */
    private Integer firstCheckStatus;

    /**
     * 下半周期服务状态(0-未开始；1-进行中；2-已完成；3-未完成)
     */
    private Integer secondCheckStatus;

    /**
     * 下半周期开始日期
     */
    private Date secondCheckStartDate;

    /**
     * 累计服务次数(统计流程已完成的检查记录次数)
     */
    private Integer checkedTotalNum;

    /**
     * 待验收风险清单数
     */
    private Integer unAcceptRiskNum;

    /**
     * 待整改风险清单数
     */
    private Integer unReformRiskNum;

    /**
     * 剩余签约天数(到期天数)
     */
    private Integer expirationDays;

    /**
     * 合同类型（1-签约；2-续约）
     */
    private Integer type;

    /**
     * 签约状态（1-签约待审核；2-已签约(签约中)；3-签约被退回；4-解约待审核；5-已解约(未签约)；6-解约被退回）
     */
    private Integer state;
    /**
     * 可以取消签约的合同数量 state in 0-待生效<续约>；2-已签约(签约中) ，多个合同的话，前端需要弹框展示
     */
    private Integer canCancelCustomerNum;
    /**
     * 校验是否能和指定企业续约 能续约true，反之false
     */
    private Boolean checkContinueGjOrgCustomer = false;
}
