package cn.smarthse.fwgj.model.vo.company;

import cn.smarthse.fwgj.enums.ThirdGjOrgCustomerStateEnum;
import cn.smarthse.fwgj.enums.ThirdGjOrgCustomerTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 企业- 历史合同
 *
 * @author chuhy
 * @date 2023/7/4
 */
@Data
public class CompanyCustomerHistoryListVo implements Serializable {
    private static final long serialVersionUID = 5335857365592173017L;


    /**
     * 签约id
     */
    private Long customerId;

    /**
     * 机构账号id
     */
    private Long gjOrgId;

    /**
     * 机构名
     */
    private String orgName;

    /**
     * 机构-地址
     */
    private String orgAddress;

    /**
     * 机构-社会统一信用代码
     */
    private String orgCreditCode;

    /**
     * 合约结束时间
     */
    private Date signTime;

    /**
     * 合约开始时间
     */
    private Date expireTime;

    /**
     * 签约时间
     */
    private Date concludeTime;

    /**
     * 解约时间
     */
    private Date cancelTime;

    @ApiModelProperty(value = "合同类型（1-签约；2-续约）")
    private Integer type;

    @ApiModelProperty(value = "状态（1-签约待审核；2-已签约(签约中)；3-签约被退回；4-解约待审核；5-已解约(未签约)；6-解约被退回）")
    private Integer state;

    public String getTypeName() {

        return ThirdGjOrgCustomerTypeEnum.getName(type);
    }

    public String getStateName() {
        return ThirdGjOrgCustomerStateEnum.getName(state);
    }
}
