package cn.smarthse.fwgj.model.vo.check;

import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.health.enums.reform.ReformSourceLiteEnum;
import cn.smarthse.modules.health.enums.reform.ReformStatusEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;


/**
 *
 * 移动端：风险列表vo
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2023/3/8 11:05
 */
@Data
public class ReformVo implements Serializable {

    private static final long serialVersionUID = -6755762928532958591L;

    @ApiModelProperty("cid")
    private Long cid;

    @ApiModelProperty("巡查id")
    private Long patrolId;

    @ApiModelProperty("风险id")
    private Long reformId;

    @ApiModelProperty("整改记录id")
    private Long reformRecordId;

    @ApiModelProperty("风险名")
    private String reformName;

    @ApiModelProperty("单位名称")
    private String unitName;

    @ApiModelProperty("风险状态(草稿-0; 待整改-1; 待验收-2; 已完成-3; 无需整改-4; 退回-5; ReformStatusEnum)")
    private Byte status;

    @ApiModelProperty("推送时间")
    private Date findTime;

    @ApiModelProperty("推送时间")
    private String findTimeStr;

    @ApiModelProperty("整改时间")
    private LocalDate actualFinishTime;

    @ApiModelProperty("要求完成时间")
    private LocalDate requireFinishTime;

    @ApiModelProperty("验收时间")
    private LocalDate acceptanceDate;

    @ApiModelProperty("生成来源(巡查包括10, 12, 13, 14, 15, 16, 17, 18) ReformGenerationSourceEnum")
    private Integer generationSource;

    @ApiModelProperty("风险来源（8-关键因素画像；9-服务管家）")
    private Byte reformItemSource;

    /**
     * 整改措施
     */
    @ApiModelProperty("整改措施")
    private String reformMeasure;

    @ApiModelProperty("是否超期(true: 超时；false：不超时)")
    private Boolean isDelay;

    public String getStatusStr() {
        //风险状态(草稿-0; 待整改-1; 待验收-2; 已完成-3; 无需整改-4; 退回-5;)
        return status == null ? null : ReformStatusEnum.getNameByValue(status);
    }

    public Boolean getIsDelay() {
        //是否超期  超期：actualFinishTime > requireFinishTime || now() > requireFinishTime
        return (actualFinishTime != null && requireFinishTime != null && actualFinishTime.isAfter(requireFinishTime))
                || (actualFinishTime == null && actualFinishTime != null && LocalDate.now().isAfter(requireFinishTime));
    }

    public String getFindTimeStr() {

        if (status != null && (ReformStatusEnum.WC.getValue() == status || ReformStatusEnum.WXZG.getValue() == status)
                && acceptanceDate != null
                && !acceptanceDate.isBefore(LocalDate.of(LocalDate.now().getYear(), 1, 1))
                && !acceptanceDate.isAfter(LocalDate.of(LocalDate.now().getYear(), 3, 1))) {
            return "无需推送";
        }

        return DateUtil.format(findTime, "yyyy-MM-dd");
    }

    public String getReformItemSourceStr() {

        return ReformSourceLiteEnum.getSourceNameByValue(reformItemSource);
    }
}
