package cn.smarthse.fwgj.model.vo.check;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;


/**
 *
 * 移动端：风险告知列表vo
 *
 * @author chuhy
 * @date 2023/3/13
 */
@Data
public class ReformListVo implements Serializable {
    private static final long serialVersionUID = -205638254129602422L;

    @ApiModelProperty("风险id")
    private Long reformId;

    @ApiModelProperty("风险名")
    private String reformName;

    @ApiModelProperty("发现时间")
    private Date findTime;

    @ApiModelProperty("整改时间")
    private LocalDate actualFinishTime;

    // @ApiModelProperty("要求完成时间")
    // private LocalDate requireFinishTime;

    @ApiModelProperty("验收时间")
    private LocalDate acceptanceDate;

    @ApiModelProperty("是否为本次巡查发现(0-否；1-是)")
    private Integer isThisFind;

    /**
     * 生成的整改项类型(ReformGenerationSourceEnum)
     */
    @ApiModelProperty("生成的整改项类型")
    private Byte ReformGenerationSource;

    /**
     * 整改措施
     */
    @ApiModelProperty("整改措施")
    private String reformMeasure;


    public ReformListVo() {
    }

    public ReformListVo(String reformName, String reformMeasure, Date findTime, Integer isThisFind, Byte reformGenerationSource) {
        this.reformMeasure = reformMeasure;
        this.reformName = reformName;
        this.findTime = findTime;
        this.isThisFind = isThisFind;
        this.ReformGenerationSource = reformGenerationSource;
    }
}
