
package cn.smarthse.fwgj.model.vo.check;

import cn.smarthse.modules.datacentre.enums.CompanySizeEnum;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;


/**
 * 新增检查记录参数(企业信息部分)
 * @author chuhy
 * @since 2023-03-08 11:01
 */
@Data
public class CheckInfoVo implements Serializable{
	private static final long serialVersionUID = -4318566770056778075L;

	/**
	 * 检查记录id
	 */
	@ApiModelProperty(value="检查记录id")
	private Long id;

	/**
	 * 检查名称
	 */
	@ApiModelProperty(value="检查名称")
	private String checkName;

	/**
	 * 机构id
	 */
	@ApiModelProperty(value="机构id")
	private Long orgId;

	/**
	 * 机构名称
	 */
	@ApiModelProperty(value="机构名称")
	private String orgName;
	
	/**
	 * 单位id
	 */
    @ApiModelProperty(value="单位id")
	private Long cid;
	
	/**
	 * 单位名称
	 */
    @ApiModelProperty(value="单位名称")
	private String unitName;
	
	/**
	 * 单位营业状态
	 */
    @ApiModelProperty(value="单位营业状态")
	private Integer unitStatus;
	
	/**
	 * 主要负责人
	 */
    @ApiModelProperty(value="主要负责人")
	private String manager;
	
	/**
	 * 联系电话
	 */
    @ApiModelProperty(value="联系电话")
	private String tel;
	
	/**
	 * 职业健康管理人员
	 */
    @ApiModelProperty(value="职业健康管理人员")
	private String hseManager;
	
	/**
	 * 职业健康管理人员-联系电话
	 */
    @ApiModelProperty(value="职业健康管理人员-联系电话")
	private String hesTel;
	
	/**
	 * 行政区划地址
	 */
    @ApiModelProperty(value="行政区划地址")
	private String address;
	
	/**
	 * 工作场所地址
	 */
    @ApiModelProperty(value="工作场所地址")
	private String workAddress;
	
	/**
	 * 行政区划
	 */
    @ApiModelProperty(value="行政区划")
	private Long areaId;
	
	/**
	 * 行业编码
	 */
    @ApiModelProperty(value="行业编码")
	private String industryCode;
	
	/**
	 * 行业名
	 */
    @ApiModelProperty(value="行业名")
	private String industryName;
	
	/**
	 * 规模
	 */
    @ApiModelProperty(value="规模")
	private String scaleCode;

	/**
	 * 规模名称
	 */
	@ApiModelProperty(value="规模名称")
	private String scaleName;
	
	/**
	 * 经济
	 */
    @ApiModelProperty(value="经济")
	private String economyCode;

	/**
	 * 经济名称
	 */
	@ApiModelProperty(value="经济名称")
	private String economyName;
	
	/**
	 * 检查年份
	 */
    @ApiModelProperty(value="检查年份")
	private Integer year;
	
	/**
	 * 检查人
	 */
    @ApiModelProperty(value="检查人")
	private String checkPeople;
	
	/**
	 * 检查时间
	 */
    @ApiModelProperty(value="检查时间")
	private Date checkTime;
	
	/**
	 * 检查痕迹附件
	 */
    @ApiModelProperty(value="检查痕迹附件")
	private String checkFile;

	/**
	 * 检查痕迹附件Url
	 */
	@ApiModelProperty(value="检查痕迹附件Url")
	private List<SysFileModel> checkFileUrl;

	/**
	 * 企业负责人签字
	 */
	@ApiModelProperty(value="企业负责人签字")
	private Long unitManageSign;

	/**
	 * 企业负责人签字Url
	 */
	@ApiModelProperty(value="企业负责人签字Url")
	private String unitManageSignUrl;

	/**
	 * 检查状态(0-未开始；1-进行中(存草稿)；2-已完成；3-已终止；4-未完成)
	 */
	@ApiModelProperty(value="检查状态(0-未开始；1-进行中(存草稿)；2-已完成；3-已终止；4-未完成)")
	private Integer checkStatus;

	/**
	 * 服务完成类型(0-无；1-巡查打卡；2-监管认定)
	 */
	@ApiModelProperty(value="服务完成类型(0-无；1-巡查打卡；2-监管认定)")
	private Integer doneType;

	/**
	 * 中止类型(1-企业暂停；2-企业关闭；3-区域变更)
	 */
	@ApiModelProperty(value="中止类型(1-企业暂停；2-企业关闭；3-区域变更)")
	private Integer stopType;

	public String getScaleName() {
		if (scaleCode != null){
			return CompanySizeEnum.getName(Integer.valueOf(scaleCode));
		} else {
			return null;
		}
	}

}
