package cn.smarthse.fwgj.model.vo.admin;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Classname UnitServcieAreaStatisticsAdminVo
 * @Description 监管-辖区服务清单
 * @Date 2023/6/29 10:25
 * @Author chenliang
 */
@Data
public class UnitServiceAreaStatisticsAdminVo implements Serializable {
    private static final long serialVersionUID = 5636997709607877753L;

    @ApiModelProperty("区域")
    private Long areaId;
    @ApiModelProperty("区域等级")
    private Byte areaLevel;
    @ApiModelProperty("区域名称")
    private String areaName;
    @ApiModelProperty("涉及机构数")
    private Integer orgNum;
    @ApiModelProperty("涉及管家数")
    private Integer gjNum;
    @ApiModelProperty("曾经签约企业数（包括已签约）")
    private Integer onceContractedUnitNum;
    @ApiModelProperty("签约企业数")
    private Integer contractedUnitNum;
    @ApiModelProperty("合约即将到期数")
    private Integer aboutToExpireUnitNum;
    @ApiModelProperty("未服务企业数")
    private Integer unservicedUnitNum;
    @ApiModelProperty("预警企业数")
    private Integer alarmUnitNum;
    @ApiModelProperty("上半周期服务企业数")
    private Integer upperHalfCycleServicedUnitNum;
    @ApiModelProperty("下半周期服务企业数")
    private Integer lowerHalfCycleServicedUnitNum;
    @ApiModelProperty("上半周期企业数")
    private Integer upperHalfCycleUnitNum;
    @ApiModelProperty("下半周期企业数")
    private Integer lowerHalfCycleUnitNum;
    @ApiModelProperty("姓名")
    private String fullname;
    @Deprecated
    @ApiModelProperty(value = "企业等级（null:全部 0-非直属，1-省直属，2-市属）",required = false)
    private Integer enterpriseLevel;
    @ApiModelProperty(value = "直属企业类（0-非直属，1-省直属，2-市属）",required = false)
    private Integer belongType;
    @ApiModelProperty(value = "最近更新时间")
    private Date latestUpdateTime;

}
