package cn.smarthse.fwgj.model.vo.admin;

import cn.smarthse.fwgj.model.vo.third.GjOrgScoreVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Classname OneOrgStatisticsVo
 * @Description 单个机构服务统计
 * @Date 2023/7/12 11:12
 * @Author chenliang
 */
@Data
public class OneOrgStatisticsVo implements Serializable {

    private static final long serialVersionUID = -6578093212482780597L;

    @ApiModelProperty("机构id")
    private String oid;

    @ApiModelProperty("机构名称")
    private String name;

    @ApiModelProperty("统一社会信用代码")
    private String creditCode;

    @ApiModelProperty("工作场所地址")
    private String workAddress;

    @ApiModelProperty("联系人")
    private String contactName;

    @ApiModelProperty("联系方式")
    private String contactPhone;

    @ApiModelProperty("主要负责人")
    private String principal;

    @ApiModelProperty("主要负责人联系电话")
    private String principalPhone;

    @ApiModelProperty("机构签约企业数")
    private Integer signedCompanyNum;

    @ApiModelProperty("机构所属服务管家数")
    private Integer gjNum;

    @ApiModelProperty("服务评分")
    private List<GjOrgScoreVo> orgScoreList;

    @ApiModelProperty("申请书文件id,逗哈隔开")
    private String applyFileIds;

    @ApiModelProperty("承诺书文件id,逗哈隔开")
    private String commitmentFileIds;

    @ApiModelProperty("营业执照文件id,逗哈隔开")
    private String busLicenseFileIds;
}
