package cn.smarthse.fwgj.model.vo.admin;

import cn.smarthse.common.util.DateUtils;
import cn.smarthse.fwgj.enums.GjCustomerCheckStatusEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Classname JurisdictionalUnitListAdminVo
 * @Description 监管-辖区服务清单-企业列表
 * @Date 2023/6/29 10:25
 * @Author chenliang
 */
@Data
public class JurisdictionalUnitListAdminVo implements Serializable {
    private static final long serialVersionUID = 5636997709607877753L;

    @ApiModelProperty
    private Integer index;
    
    @ApiModelProperty("企业id")
    private Long cid;

    @ApiModelProperty("审核记录id")
    private Long customerId;

    @ApiModelProperty("合同类型（1-签约；2-续约）")
    private Integer applicationType;

    @ApiModelProperty("企业名称")
    private String unitName;

    @ApiModelProperty("企业社会信用代码")
    private String unifiedSocialCc;

    @ApiModelProperty("企业详细注册地址")
    private String registerAddress;

    @ApiModelProperty("企业详细工作地址")
    private String workAddress;

    @ApiModelProperty("主要负责人")
    private String mainLeaderName;

    @ApiModelProperty("负责人联系方式")
    private String mainLeaderTel;

    @ApiModelProperty("机构名称")
    private String orgName;

    @ApiModelProperty("机构联系人")
    private String orgContactName;

    @ApiModelProperty("机构联系方式")
    private String orgContactPhone;

    @ApiModelProperty("合同起止日期")
    private String contractTime;

    @ApiModelProperty("当前周期时间")
    private String currentCycleTime;

//    @ApiModelProperty("上半周期合同开始时间")
//    private Date firstHalfCycleStartTime;
//    @ApiModelProperty("上半周期合同结束时间")
//    private Date firstHalfCycleEndTime;
    @ApiModelProperty("下半周期合同开始时间")
    private Date secondHalfCycleStartTime;
//    @ApiModelProperty("下半周期合同结束时间")
//    private Date secondHalfCycleEndTime;


    @ApiModelProperty("剩余天数")
    private Integer remainingSigningTime;

    @ApiModelProperty("本周期服务次数")
    private Integer cycleServiceTime;

    @ApiModelProperty("当前合同周期(第几合约年)")
    private Integer curContractYear;

    @ApiModelProperty("合同签约时间")
    private Date signTime;

    @ApiModelProperty("合同结束时间")
    private Date expireTime;

    @ApiModelProperty("上半周期服务状态(0-未开始；1-进行中；2-已完成；3-未完成)")
    private Integer upperHalfCycleStatus;
    @ApiModelProperty("上半周期服务状态(0-未开始；1-进行中；2-已完成；3-未完成)")
    private String upperHalfCycleStatusName;

    @ApiModelProperty("下半周期服务状态(0-未开始；1-进行中；2-已完成；3-未完成)")
    private Integer lowerHalfCycleStatus;
    @ApiModelProperty("下半周期服务状态(0-未开始；1-进行中；2-已完成；3-未完成)")
    private String lowerHalfCycleStatusName;

    @ApiModelProperty("是否即将到期")
    private Boolean ifAboutToExpire;

    @ApiModelProperty("预警状态(0-无预警；1-检查预警；2-超期小于等于30天；3-超期大于30天)")
    private Integer warningStatus;

    @ApiModelProperty("签约状态状态（1-签约待审核；2-已签约；3-签约被退回；4-解约待审核；5-已解约(未签约)；6-解约被退回）")
    private Integer signingStatus;

    public String getUpperHalfCycleStatusName() {
        return this.upperHalfCycleStatus == null ? null : GjCustomerCheckStatusEnum.getName(this.upperHalfCycleStatus);
    }

    public String getLowerHalfCycleStatusName() {
        return this.lowerHalfCycleStatus == null ? null : GjCustomerCheckStatusEnum.getName(this.lowerHalfCycleStatus);
    }

//    public Boolean getIfAboutToExpire() {
//        if (this.expireTime != null && this.signingStatus != null && "2,4,6".contains(this.signingStatus.toString())) {
//            return DateUtils.isBefore(this.expireTime, DateUtils.addMonth(DateUtils.getStartTime(new Date()), 2));
//        }
//        return ifAboutToExpire;
//    }
}
