package cn.smarthse.fwgj.model.vo.admin;

import cn.smarthse.fwgj.entity.thirdGj.ThirdGjOrgCustomerLotDetail;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 服务管家机构 添加企业对象 VO类
 *
 * @author wuxq
 * @date 2023/6/29 09:34
 */
@Data
public class GjOrgAddCompDetailVo implements Serializable {

    private static final long serialVersionUID = -1L;

    @ApiModelProperty(value = "lot_id")
    private Long lotId;

    @ApiModelProperty(value = "机构id")
    private Long orgId;
    @ApiModelProperty(value = "服务管家id")
    private Long gjOrgId;
    @ApiModelProperty(value = "机构名")
    private String orgName;
    @ApiModelProperty(value = "机构联系人")
    private String orgMan;
    @ApiModelProperty(value = "机构联系电话")
    private String orgTel;
    @ApiModelProperty(value = "机构联系电话")
    private String chooseAreas;
    @ApiModelProperty(value = "已勾选区域ids")
    private List<Long> selectedAreaIds;

    @ApiModelProperty(value = "签约时间")
    private Date signTime;
    @ApiModelProperty(value = "到期时间")
    private Date expireTime;

    @ApiModelProperty(value = "0-存草稿；1-添加")
    private Integer state;

    @ApiModelProperty(value = "已勾选保存企业")
    private List<ThirdGjOrgCustomerLotDetail> customerLotDetails;
    @ApiModelProperty(value = "已勾选保存企业ids")
    private List<Long> selectedCids;

    public List<Long> getSelectedAreaIds() {
        if (StringUtil.isNotEmpty(chooseAreas)) {
            return Arrays.stream(chooseAreas.split(",")).map(Long::parseLong).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public List<Long> getSelectedCids() {
        if (CollectionUtils.isNotEmpty(customerLotDetails)) {
            return customerLotDetails.stream().map(ThirdGjOrgCustomerLotDetail::getCid).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}
