package cn.smarthse.fwgj.model.vo.admin;

import cn.smarthse.common.util.date.DateUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 服务管家机构备案申请审核对象 VO类
 *
 * @author wuxq
 * @date 2023/6/29 09:34
 */
@Data
public class GjFilingAuditVo implements Serializable {

    private static final long serialVersionUID = -1L;

    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "org_id")
    private Long orgId;

    @ApiModelProperty(value = "机构名")
    private String orgName;

    @ApiModelProperty(value = "机构地址")
    private String address;

    @ApiModelProperty(value = "状态（0：草稿；1：待审核；2：已通过；3：被退回）")
    private Integer state;

    @ApiModelProperty(value = "提交时间")
    private Date subTime;

    @ApiModelProperty(value = "提交时间")
    private String subTimeStr;

    public String getSubTimeStr() {
        if (subTime != null) {
            return DateUtil.format(subTime, "yyyy-MM-dd HH:mm:ss");
        }
        return "-";
    }

}
