package cn.smarthse.fwgj.model.vo.admin;

import cn.smarthse.common.util.date.DateUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 服务管家机构备案申请审核统计对象（省市区级） VO类
 *
 * @author wuxq
 * @date 2023/6/29 09:34
 */
@Data
public class GjFilingAuditStatisticsVo implements Serializable {

    private static final long serialVersionUID = -1L;

    @ApiModelProperty(value = "区域id")
    private Long areaId;

    @ApiModelProperty(value = "区域名称")
    private String areaName;

    @ApiModelProperty(value = "区域等级")
    private Integer areaLevel;

    @ApiModelProperty(value = "当前监管账号区域等级")
    private Integer loginAdminAreaLevel;

    @ApiModelProperty(value = "新增审核数")
    private String pendingAuditNum;

    @ApiModelProperty(value = "服务管家机构数")
    private String gjOrgNum;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(value = "更新时间")
    private String updateTimeStr;

    public String getUpdateTimeStr() {
        if (updateTime != null) {
            return DateUtil.format(updateTime, "yyyy-MM-dd HH:mm:ss");
        }
        return "-";
    }
}
