package cn.smarthse.fwgj.model.param.third;

import cn.smarthse.util.common.StringUtils;
import com.alibaba.excel.annotation.ExcelIgnore;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import javax.validation.constraints.NotNull;
import lombok.Data;

/**
 * 机构端：管家账号新增 参数对象
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2023/6/29 17:02
 */
@Data
public class GjUserAddParam implements Serializable {


    private static final long serialVersionUID = -4232719703767566141L;

    @ApiModelProperty("机构id")
    @ExcelIgnore
    private Long orgId;

    @ApiModelProperty("机构账号id")
    @ExcelIgnore
    private Long userId;
    /**
     * 用户姓名
     */
    @ApiModelProperty("用户姓名")
    @NotNull
    private String fullname;
    /**
     * 手机号码
     */
    @ApiModelProperty("手机号码")
    @NotNull
    private String mobile;
    /**
     * 身份证
     */
    @ApiModelProperty("身份证")
    @NotNull
    private String idcard;
    /**
     * 性别（男；女）
     */
    @ApiModelProperty("性别（男；女）")
    private String sex;
    /**
     * 出生日期
     */
    @ApiModelProperty(value = "出生日期", hidden = true)
    @ExcelIgnore
    private Date birthday;
    /**
     * 从业年限/年
     */
    @Deprecated
    @ApiModelProperty("从业年限/年")
    @ExcelIgnore
    private Integer workYear;
    /**
     * 专业职称
     */
    @ApiModelProperty("专业职称")
    private String post;
    /**
     * 文化程度
     */
    @ApiModelProperty("文化程度")
    private String edu;

    public void setIdcard (String idcard) {
        this.idcard = idcard;
        this.birthday = StringUtils.getBirthDayFromIdCard(idcard);
    }
}
