package cn.smarthse.fwgj.model.param.third;

import java.io.Serializable;
import java.util.Date;
import javax.validation.constraints.NotNull;
import lombok.Data;

/**
 *
 * 机构：
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2023/7/11 15:25
 */
@Data
public class GjOrgCustomerAddParam implements Serializable {

    private static final long serialVersionUID = 9220306986862985016L;

    /**
     * 签约id
     */
    private Long id;
    /**
     * 机构id
     */
    private Long orgId;
    /**
     * 机构账号id
     */
    private Long userId;
    /**
     * 签约单位id
     */
    @NotNull
    private Long cid;
    /**
     * 机构名
     */
    private String orgName;
    /**
     * 机构联系人
     */
    private String orgMan;
    /**
     * 机构联系电话
     */
    private String orgTel;

    /**
     * 签约企业名称
     */
    private String unitName;
    /**
     * 签约企业统一社会信用代码
     */
    private String unitCreditCode;
    /**
     * 企业联系人
     */
    private String unitMan;
    /**
     * 企业联系电话
     */
    private String unitTel;
    /**
     * 企业地址
     */
    @NotNull
    private Long areaId;
    /**
     * 签约企业省id
     */
    private Long areaId1;
    /**
     * 签约企业市id
     */
    private Long areaId2;
    /**
     * 签约企业区id
     */
    private Long areaId3;
    /**
     * 签约企业街道id
     */
    private Long areaId4;
    /**
     * 企业地址
     */
    private String unitAddress;
    /**
     * 合同类型（1-签约；2-续约）
     */
    private Integer type = 1;
    /**
     * 合同附件id（多个用,隔开）
     */
    @NotNull
    private String contractFileId;
    /**
     * 签约时间
     */
    @NotNull
    private Date signTime;
    /**
     * 到期时间
     */
    @NotNull
    private Date expireTime;
    /**
     * 机构、企业签约状态（1：签约待审核；2：已签约；3：签约被退回；4：解约待审核；5：已解约；6：解约被退回）
     */
    private Integer state = 1;
    /**
     * 直属企业类型（0-非直属，1-省直属，2-市属）来源数据中心
     */
    @NotNull
    private Byte belongType;
}
