
package cn.smarthse.fwgj.model.param.check;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;


/**
 * 更新检查记录参数(企业信息部分)
 * @author chuhy
 * @since 2023-03-08 11:01
 */
@Data
public class UpdateCheckInfoParam implements Serializable{
	private static final long serialVersionUID = -7068383493375846711L;

	/**
	 * 检查id
	 */
	@ApiModelProperty(value="检查id")
	private Long id;
	
	/**
	 * 单位id
	 */
    @ApiModelProperty(value="单位id")
	private Long cid;
	
	/**
	 * 单位名称
	 */
    @ApiModelProperty(value="单位名称")
	private String unitName;
	
	/**
	 * 单位营业状态
	 */
    @ApiModelProperty(value="单位营业状态")
	private Integer unitStatus;
	
	/**
	 * 主要负责人
	 */
    @ApiModelProperty(value="主要负责人")
	private String manager;
	
	/**
	 * 联系电话
	 */
    @ApiModelProperty(value="联系电话")
	private String tel;
	
	/**
	 * 职业健康管理人员
	 */
    @ApiModelProperty(value="职业健康管理人员")
	private String hseManager;
	
	/**
	 * 职业健康管理人员-联系电话
	 */
    @ApiModelProperty(value="职业健康管理人员-联系电话")
	private String hesTel;
	
	/**
	 * 行政区划地址
	 */
    @ApiModelProperty(value="行政区划地址")
	private String address;
	
	/**
	 * 工作场所地址
	 */
    @ApiModelProperty(value="工作场所地址")
	private String workAddress;
	
	/**
	 * 行政区划
	 */
    @ApiModelProperty(value="行政区划")
	private Long areaId;
	
	/**
	 * 行业编码
	 */
    @ApiModelProperty(value="行业编码")
	private String industryCode;
	
	/**
	 * 行业名
	 */
    @ApiModelProperty(value="行业名")
	private String industryName;
	
	/**
	 * 规模
	 */
    @ApiModelProperty(value="规模")
	private String scaleCode;
	
	/**
	 * 经济
	 */
    @ApiModelProperty(value="经济")
	private String economyCode;

	/**
	 * 经济名称
	 */
	@ApiModelProperty(value="经济名称")
	private String economyName;
	
	/**
	 * 检查年份
	 */
    @ApiModelProperty(value="检查年份")
	private Integer year;
	
	/**
	 * 检查人
	 */
    @ApiModelProperty(value="检查人")
	private String checkPeople;
	
	/**
	 * 检查时间
	 */
    @ApiModelProperty(value="检查时间")
	private Date checkTime;
	
	/**
	 * 检查痕迹附件
	 */
    @ApiModelProperty(value="检查痕迹附件")
	private String checkFile;

	/**
	 * 企业负责人签字
	 */
	@ApiModelProperty(value="企业负责人签字")
	private Long unitManageSign;

	/**
	 * 检查状态(0-未开始；1-进行中(存草稿)；2-已完成；3-已终止；4-未完成)
	 */
	@ApiModelProperty(value="检查状态(0-未开始；1-进行中(存草稿)；2-已完成；3-已终止；4-未完成)")
	private Integer checkStatus;

	/**
	 * 中止类型(1-企业暂停；2-企业关闭；3-区域变更)
	 */
	@ApiModelProperty(value="中止类型(1-企业暂停；2-企业关闭；3-区域变更)")
	private Integer stopType;



}
