package cn.smarthse.fwgj.model.param.check;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;


/**
 *
 * 提交风险参数
 *
 * @author chuhy
 * @date 2023/3/13
 */
@Data
public class AddReformParam implements Serializable {
    private static final long serialVersionUID = -342597557777969110L;

    @ApiModelProperty("巡查id")
    private Long checkId;

    // @NotNull
    @ApiModelProperty("风险id")
    private Long reformId;

    @ApiModelProperty("企业id")
    private Long cid;

    @ApiModelProperty("风险名")
    private String reformName;

    @ApiModelProperty("发现时间")
    private Date findTime;

    @ApiModelProperty("发现人")
    private String finderName;

    @ApiModelProperty("整改时间")
    private Date actualFinishTime;

    // @ApiModelProperty("要求完成时间")
    // private LocalDate requireFinishTime;

    @ApiModelProperty("验收时间")
    private Date acceptanceDate;

    /**
     * 整改措施
     */
    @ApiModelProperty("整改措施")
    private String reformMeasure;

    @ApiModelProperty("是否为本次巡查发现(0-否；1-是)")
    private Integer isThisFind;

    /**
     * 生成的整改项类型(ReformGenerationSourceEnum)
     */
    @ApiModelProperty("生成的整改项类型")
    private Byte ReformGenerationSource;

}
